﻿/* テスト */
/* 
 * Debug Status: Not checked.
 * - Fixed __T on this page.
 */
/*
 * File: player/p-util.c
 * Purpose: 
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
extern "C"
{
#include "angband.h"
#include "object/tvalsval.h" 
}
extern void msg_print(const _TCHAR *msg);

/*
 * Modify a stat value by a "modifier", return new value
 *
 * Stats go up: 3,4,...,17,18,18/10,18/20,...,18/220
 * Or even: 18/13, 18/23, 18/33, ..., 18/220
 *
 * Stats go down: 18/220, 18/210,..., 18/10, 18, 17, ..., 3
 * Or even: 18/13, 18/03, 18, 17, ..., 3
 */
s16b modify_stat_value(int value, int amount)
{
	int i;

	/* Reward */
	if (amount > 0)
	{
		/* Apply each point */
		for (i = 0; i < amount; i++)
		{
			/* One point at a time */
			if (value < 18) value++;

			/* Ten "points" at a time */
			else value += 10;
		}
	}

	/* Penalty */
	else if (amount < 0)
	{
		/* Apply each point */
		for (i = 0; i < (0 - amount); i++)
		{
			/* Ten points at a time */
			if (value >= 18+10) value -= 10;

			/* Hack -- prevent weirdness */
			else if (value > 18) value = 18;

			/* One point at a time */
			else if (value > 3) value--;
		}
	}

	/* Return new value */
	return (value);
}

/* Is the player capable of casting a spell? */ 
bool player_can_cast(void) 
{ 
	if (!cp_ptr->spell_book) 
	{ 
			msg_print(LS(__T("You cannot pray or produce magics."),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	if (p_ptr->timed[TMD_BLIND] || no_lite()) 
	{ 
			msg_print(LS(__T("You cannot see!"),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	if (p_ptr->timed[TMD_CONFUSED]) 
	{ 
			msg_print(LS(__T("You are too confused!"),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	return TRUE; 
} 
 
/* Is the player capable of studying? */ 
bool player_can_study(void) 
{ 
	if (!player_can_cast()) 
			return FALSE; 

	if (!p_ptr->new_spells) 
	{ 
			const _TCHAR * p = ((cp_ptr->spell_book == TV_MAGIC_BOOK) 
					? __T("spell") : __T("prayer")); 
			msg_format(__T("You cannot learn any new %ss!"), p); 
			return FALSE; 
	} 

	return TRUE; 
} 
 
/* Determine if the player can read scrolls. */ 
bool player_can_read(void) 
{ 
	if (p_ptr->timed[TMD_BLIND]) 
	{ 
			msg_print(LS(__T("You can't see anything."),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	if (no_lite()) 
	{ 
			msg_print(LS(__T("You have no light to read by."),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	if (p_ptr->timed[TMD_CONFUSED]) 
	{ 
			msg_print(LS(__T("You are too confused to read!"),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	if (p_ptr->timed[TMD_AMNESIA]) 
	{ 
			msg_print(LS(__T("You can't remember how to read!"),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
			return FALSE; 
	} 

	return TRUE; 
}
