﻿/* テスト */
/*
 * File: lang-support.h
 * Purpose: Definitions etc. required for support of internationalization.
 *
 * Copyright (c) 2009 Paul Blay
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */

/*
 * Available language modes
 */
#define LNG_ENGLISH			0
#define LNG_JAPANESE		1

/* 
 * LS = Language Select
 * 
 * This macro is used for complete sentences that don't need formatting
 * (the simplest case).  Note that spaceme still needs to be used (hence 
 * you need a buffer variable).
 */
#define LS(a, b) arg_language == LNG_ENGLISH ? a : b
/*
 * LFTAG = Language File Tag 
 * 
 * This macro adds a tag to filenames that differe between English and 
 * Japanese versions (for example help files).
 */
#define LFTAG arg_language == LNG_ENGLISH ? __T("") : __T("_jpn")

/* 
 * Add no-break-spaces after Japanese characters to make them display with correct spacing.
 * Note that spaceme may need to be moved to z-util.c and z-util.h
 *
 * XXX XXX This is a horrible hack.
 */
extern _TCHAR *spaceme(_TCHAR *s2, const _TCHAR *s1);
