/*
**
**	$Id: jlib.c,v 1.14 2008-05-03 15:40:59 argrath Exp $
**
*/

/* Copyright (c) Issei Numata 1994-2000 */
/* JNetHack may be freely redistributed.  See license for details. */

#include <stdio.h>
#include <ctype.h>
#include "hack.h"

int xputc(CHAR_P);
int xputc2(int, int);


#define EUC	0
#define SJIS	1
#define JIS	2

/* internal kcode */
/* IC=0 EUC */
/* IC=1 SJIS */
#define IC ((unsigned char)(""[0])==0x8a)

/* default input kcode */
#ifndef INPUT_KCODE
# ifdef MSDOS
#  define INPUT_KCODE SJIS
# else
#  define INPUT_KCODE EUC
# endif
#endif

/* default output kcode */
#ifndef OUTPUT_KCODE
# ifdef MSDOS
#  define OUTPUT_KCODE SJIS
# else
#  define OUTPUT_KCODE EUC
# endif
#endif

#ifdef WIN32_PLATFORM_PSPC 
#define putchar(x) {}
#endif

static int	output_kcode = OUTPUT_KCODE;
static int	input_kcode = INPUT_KCODE;

/*
**	Kanji code library....
*/

/*
 * (1ʸ)ɤĴ٤
 */
int
is_kanji(c)
     unsigned c;
{
    if(IC == EUC)
      return (c & 0x80);
    else
      return ((unsigned int)c>=0x81 && (unsigned int)c<=0x9f)
	|| ((unsigned int)c>=0xe0 && (unsigned int)c<=0xfc);
}

void
setkcode(c)
     int c;
{
    if(c == 'E' || c == 'e' )
      output_kcode = EUC;
    else if(c == 'J' || c == 'j')
      output_kcode = JIS;
    else if(c == 'S' || c == 's')
      output_kcode = SJIS;
    else if(c == 'I' || c == 'i')
#ifdef MSDOS
      output_kcode = SJIS;
#else
      output_kcode = IC;
#endif
    else{
	output_kcode = IC;
    }
    input_kcode = output_kcode;
}
/*
**	EUC->SJIS
*/

unsigned char *
e2sj(s)
     unsigned char *s;
{
    unsigned char h,l;
    static unsigned char sw[2];

    h = s[0] & 0x7f;
    l = s[1] & 0x7f;

    sw[0] = ((h - 1) >> 1)+ ((h <= 0x5e) ? 0x71 : 0xb1);
    sw[1] = l + ((h & 1) ? ((l < 0x60) ? 0x1f : 0x20) : 0x7e);

    return sw;
}
/*
**	SJIS->EUC
*/
unsigned char *
sj2e(s)
     unsigned char *s;
{
    unsigned int h,l;
    static unsigned char sw[2];

    h = s[0];
    l = s[1];

    h = h + h - ((h <=0x9f) ? 0x00e1 : 0x0161);
    if( l<0x9f )
      l = l - ((l > 0x7f) ? 0x20 : 0x1f);
    else{
	l = l-0x7e;
	++h;
    }
    sw[0] = h | 0x80;
    sw[1] = l | 0x80;
    return sw;
}
/*
**	translate string to internal kcode
*/
const char *
str2ic(s)
     const char *s;
{
    static unsigned char buf[1024];
    const unsigned char *up;
    unsigned char *p, *pp;
    int kin;

    if(!s)
      return s;

    buf[0] = '\0';

    if( IC==input_kcode ){
	strcpy((char *)buf, s);
	return (char *)buf;
    }

    p = buf;
    if( IC==EUC && input_kcode == SJIS ){
	while(*s){
	    up = s;
	    if(is_kanji(*up)){
		pp = sj2e((unsigned char *)s);
		*(p++) = pp[0];
		*(p++) = pp[1];
		s += 2;
	    }
	    else
	      *(p++) = (unsigned char)*(s++);
	}
    }
    else if( IC==EUC && input_kcode == JIS ){
	kin = 0;
	while(*s){
	    if(s[0] == 033 && s[1] == '$' && (s[2] == 'B' || s[3] == '@')){
		kin = 1;
		s += 3;
	    }
	    else if(s[0] == 033 && s[1] == '(' && (s[2] == 'B' || s[3] == 'J')){
		kin = 0;
		s += 3;
	    }
	    else if( kin )
	      *(p++) = (*(s++) | 0x80);
	    else
	      *(p++) = *(s++);
	}
    }
    else{
	strcpy((char *)buf, s);
	return (char *)buf;
    }

    *(p++) = '\0';
    return (char *)buf;
}

#ifdef SJIS_FILESYSTEM
/*
**	translate string to output kcode
*/
const char *
ic2str(s)
     const char *s;
{
    static unsigned char buf[1024];
    const unsigned char *up;
    unsigned char *p, *pp;
    int kin;

    if(!s)
      return s;

    buf[0] = '\0';

    p = buf;
    if( IC==EUC && output_kcode == SJIS ){
	while(*s){
	    up = s;
	    if( *up & 0x80 ){
		pp = e2sj((unsigned char *)s);
		*(p++) = pp[0];
		*(p++) = pp[1];
		s += 2;
	    }
	    else
	      *(p++) = (unsigned char)*(s++);
	}
    }
    else{
	strcpy((char *)buf, s);
	return (char *)buf;
    }

    *(p++) = '\0';
    return (char *)buf;
}
#endif /* MSDOS */

/*
**	primitive function
*/

static int kmode;	/* 0: Kanji out */
			/* 1: Kanji in */

static void
tty_reset()
{
    if(kmode && output_kcode==JIS ){
	putchar(033);
	putchar('(');
	putchar('B');
/*
    if (flags.DECgraphics){
      putchar(033);
      putchar('$');
      putchar(')');
      putchar('B');
    }
*/
    }
    kmode = 0;
}

/* print out 1 byte character to tty (no conversion) */
static void
tty_cputc(unsigned int c)
{
    if(kmode && output_kcode==JIS ){
	putchar(033);
	putchar('(');
	putchar('B');
    }
    kmode = 0;

#if defined(NO_TERMS) && (defined(MSDOS) || defined(WIN32CON))
    xputc(c);
#else
    putchar(c);
#endif
} 

/* print out 2 bytes character to tty (no conversion) */
static void
tty_cputc2(unsigned int c, unsigned int c2)
{
    kmode = 1;

#if defined(NO_TERMS) && (defined(MSDOS) || defined(WIN32CON))
    xputc2(c, c2);
#else
    putchar(c);
    putchar(c2);
#endif
} 

/* print out 1 byte character to tty (IC->output_kcode) */
static void
tty_jputc(unsigned int c)
{
    if(kmode && output_kcode==JIS ){
	putchar(033);
	putchar('(');
	putchar('B');
    }
    kmode = 0;

#if defined(NO_TERMS) && (defined(MSDOS) || defined(WIN32CON))
    xputc(c);
#else
    putchar(c);
#endif
}

/* print out 2 bytes character to tty (IC->output_kcode) */
static void
tty_jputc2(unsigned int c, unsigned int c2)
{
    if(!kmode && output_kcode==JIS ){
	putchar(033);
	putchar('$');
	putchar('B');
    }
    kmode = 1;

#if defined(NO_TERMS) && (defined(MSDOS) || defined(WIN32CON))
    xputc2(c, c2);
#else
    putchar(c);
    putchar(c2);
#endif
}

/*
 *  2ХʸХåե󥰤ʤϤ
 *  ѴԤ
 */
int
jbuffer(
     unsigned int c,
     unsigned int *buf,
     void (*reset)(),
     void (*f1)(unsigned int),
     void (*f2)(unsigned int, unsigned int))
{
    static unsigned int ibuf[2];
    unsigned int c1, c2;
    unsigned char uc[2];
    unsigned char *p;

    if(!buf) buf = ibuf;
    if(!reset) reset = tty_reset;
    if(!f1) f1 = tty_jputc;
    if(!f2) f2 = tty_jputc2;

    c = c & 0xff;

    if(!(buf[0]) && (is_kanji(c))){
	buf[1] = c;
	++buf[0];
	return 0;
    }
    else if(buf[0]){
	c1 = buf[1];
	c2 = c;

	if(IC == output_kcode)
	  ;
	else if(IC == EUC){
	    switch(output_kcode){
	      case JIS:
		c1 &= 0x7f;
		c2 &= 0x7f;
		break;
	      case SJIS:
		uc[0] = c1;
		uc[1] = c2;
		p = e2sj(uc);
		c1 = p[0];
		c2 = p[1];
		break;
	      default:
		impossible("Unknown kcode!");
		break;
	    }
	}
	else if(IC == SJIS){
	    uc[0] = c1;
	    uc[1] = c2;
	    p = sj2e(uc);
	    switch(output_kcode){
	      case JIS:
		c1 &= 0x7f;
		c2 &= 0x7f;
		break;
	      case EUC:
		break;
	      default:
		impossible("Unknown kcode!");
		break;
	    }
	}
	f2(c1, c2);
	buf[0] = 0;
	return 2;
    }
    else if(c){
	f1(c);
	return 1;
    }
    reset();
    return -1;
}

/*
 *  2ХʸХåե󥰤ʤϤ
 *  ѴϹԤʤ
 */
int
cbuffer(
     unsigned int c,
     unsigned int *buf,
     void (*reset)(),
     void (*f1)(unsigned int),
     void (*f2)(unsigned int, unsigned int))
{
    static unsigned int ibuf[2];

    if(!buf) buf = ibuf;
    if(!reset) reset = tty_reset;
    if(!f1) f1 = tty_cputc;
    if(!f2) f2 = tty_cputc2;

    if(!(buf[0]) && is_kanji(c)){
	buf[1] = c;
	++buf[0];
	return 0;
    }
    else if(buf[0]){
	f2(buf[1], c);
	buf[0] = 0;
	return 2;
    }
    else if(c){
	f1(c);
	return 1;
    }
    reset();
    return -1;
}

void
jputchar(int c)
{
    static unsigned int buf[2];
    jbuffer((unsigned int)(c & 0xff), buf, NULL, NULL, NULL);
}
void
cputchar(int c)
{
    static unsigned int buf[2];
    cbuffer((unsigned int)(c & 0xff), buf, NULL, NULL, NULL);
}

void
jputs(s)
     const char *s;
{
    while(*s)
      jputchar((unsigned char)*s++);
    jputchar('\n');
}

int
is_kanji2(s, pos)
     const char *s;
     int pos;
{
    unsigned char *str;

    str = (unsigned char *)s;
    while(*str && pos>0){
	if(is_kanji(*str)){
	    str+=2;
	    pos-=2;
	}
	else{
	    ++str;
	    --pos;
	}
    }
    if(pos<0)
      return 1;
    else
      return 0;
}

int
is_kanji1(s, pos)
     const char *s;
     int pos;
{
    unsigned char *str;

    str = (unsigned char *)s;
    while(*str && pos>0){
	if(is_kanji(*str)){
	    str+=2;
	    pos-=2;
	}
	else{
	    ++str;
	    --pos;
	}
    }
    if(!pos && is_kanji(*str))
      return 1;
    else
      return 0;
}

/*
** 8ӥåȥ롼isspace()
*/
int
isspace_8(c)
     int c;
{
    unsigned int *up;

    up = (unsigned int *)&c;
    return *up<0x80 ? isspace(*up) : 0;
}
/*
** split string(str) including japanese before pos and return to
** str1, str2.
*/
void
split_japanese( str, str1, str2, pos )
     char *str;
     char *str1;
     char *str2;
     int pos;
{
    int len, i, j, k, mlen;
    char *pstr;
    char *pnstr;
    int	sq_brac;

retry:
    len = strlen((char *)str);

    if( len < pos ){
	strcpy(str1,str);
	*str2 = '\0';
	return;
    }

    if(pos > 20)
      mlen = 20;
    else
      mlen = pos;

    i = pos;
    if(is_kanji2(str, i))
      --i;

/* 1:
** search space character
*/
    j = 0;
    while( j<mlen ){
	if(isspace_8(str[i-j])){
	    --j;
	    goto found;
	}
	else if(is_kanji1(str,i-j)){
	    if(!strncmp(str+i-j,"",2)){
		j -= 2;
		goto found;
	    }
	}
	++j;
    }

/* 3:
** search second bytes of japanese
*/
    j = 0;
    sq_brac = 0;
    while( j<mlen ){
	if(str[i-j] == '['){
	    sq_brac = 0;
	    goto found;
	}
	else if(str[i-j] == ']')
	  sq_brac = 1;
	
	if(!sq_brac && is_kanji1(str,i-j)){
	    goto found;
	}

	++j;
    }
    if(pos > 2){
	pos -= 2;
	goto retry;
    }
found:

    if(pos > 2){
	if((str[i-j] == ']' ||
	    str[i-j] == ')' ||
	    str[i-j] == '}')){
	    pos -= 2;
	    goto retry;
	}
	else if(!strncmp(str+i-j, "", 2) ||
		!strncmp(str+i-j, "", 2) ||
		!strncmp(str+i-j, "", 2)){
	    pos -= 2;
	    goto retry;
	}
	else if(!strncmp(str+i-j,"",2) ||
		!strncmp(str+i-j,"",2) ||
		!strncmp(str+i-j,"",2) ||
		!strncmp(str+i-j,"",2) ||
		!strncmp(str+i-j,"",2)){
	    pos -= 2;
	    goto retry;
	}
    }

    if(i == j){
	/* ʬʤä */
	strcpy(str1, str);
	str2[0] = '\0';
	return;
    }

    pstr = str;

    pnstr = str1;
    for( k=0 ; k<i-j ; ++k )
      *(pnstr++) = *(pstr++);
    *(pnstr++) = '\0';

    pnstr = str2;
    for( ; str[k] ; ++k )
      *(pnstr++) = *(pstr++);
    *(pnstr++) = '\0';
}

void 
jrndm_replace(c)
     char *c;
{
    unsigned char cc[3];

    if(IC==SJIS)
      memcpy(cc, (char *)sj2e(c), 2);
    else
      memcpy(cc, c, 2);

    cc[0] &= 0x7f;
    cc[1] &= 0x7f;

    switch(cc[0]){
      case 0x21:
	cc[1] = rn2(94) + 0x21;
	break;
      case 0x23:
	if(cc[1] <= 0x39) /*  */
	  cc[1] = rn2(10) + 0x30;
	else if(cc[1] <= 0x5A) /*  */
	  cc[1] = rn2(26) + 0x41;
	else if(cc[2] <= 0x7A) /*  */
	  cc[1] = rn2(26) + 0x61;
	break;
      case 0x24:
      case 0x25:
	cc[1] = rn2(83) + 0x21; /*  or  */
	break;
      case 0x26:
	if(cc[1] <= 0x30)
	  cc[1] = rn2(24) + 0x21; /*  ꥷʸ */
	else
	  cc[1] = rn2(24) + 0x41; /*  ꥷʸ */
	break;
      case 0x27:
	if(cc[1] <= 0x40)
	  cc[1] = rn2(33) + 0x21; /*  ʸ */
	else
	  cc[1] = rn2(33) + 0x51; /* ѡ ʸ */
	break;
      case 0x4f:
	cc[1] = rn2(51) + 0x21; /* ϡ  */
	break;
      case 0x74:
	cc[1] = rn2(4) + 0x21; /*     4ʸ*/
	break;
      default:
	if(cc[0] >= 0x30 && cc[1] <= 0x74)
	  cc[1] = rn2(94) + 0x21;
	break;
    }

    cc[0] |= 0x80;
    cc[1] |= 0x80;

    if(IC==SJIS)
      memcpy(c, (char *)e2sj(cc), 2);
    else
      memcpy(c, cc, 2);
}

/*
 * "put off"оݤˤäŬڤ
 */
const char *
joffmsg(otmp, joshi)
register struct obj *otmp;
const char **joshi;
{
    static char buf[BUFSZ];

    *joshi = "";

    if(otmp->oclass == RING_CLASS){
	Sprintf(buf, "%sϤ", body_part(FINGER));
	return buf;
    }
    if( otmp->oclass == AMULET_CLASS){
	return "Ϥ";
    }
    else if(is_helmet(otmp))
      return "";
    else if(is_gloves(otmp))
      return "Ϥ";
    else if(otmp->oclass == WEAPON_CLASS||is_shield(otmp)){
	*joshi = "";
	return "";
    }
    else if(is_suit(otmp))
      return "æ";
    else
      return "Ϥ";
}

/*
 * "put on"оݤˤäŬڤ
 */
const char *
jonmsg(otmp, joshi)
register struct obj *otmp;
const char **joshi;
{
    static char buf[BUFSZ];

    *joshi = "";

    if(otmp->oclass == RING_CLASS){
	Sprintf(buf, "%sˤϤ", body_part(FINGER));
	return buf;
    }
    else if(otmp->oclass == AMULET_CLASS)
      return "ȤˤĤ";
    else if(is_gloves(otmp))
      return "ȤˤĤ";
    else if(is_shield(otmp)){
	*joshi = "";
	return "Ȥ";
    }
    else if(is_helmet(otmp))
      return "֤";
    else if(otmp->oclass == WEAPON_CLASS){
	Sprintf(buf, "%sˤ", body_part(HAND));
	return buf;
    }
    else if(is_boots(otmp))
      return "";
    else if(is_suit(otmp))
      return "";
    else
      return "ȤˤĤ";
}

/*
 * ֤
 */
const char *
numeral(obj)
register struct obj *obj;
{
    switch(obj->oclass){
      case WEAPON_CLASS:
      case WAND_CLASS:
	if(obj->otyp==SHURIKEN)
	  return "";
	else
	  return "";
      case ARMOR_CLASS:
	return "";
      case GEM_CLASS:
      case ROCK_CLASS:
      case BALL_CLASS:
	return "";
      case SCROLL_CLASS:
	return "";
      case SPBOOK_CLASS:
	return "";
      case POTION_CLASS:
      case RING_CLASS:
      case AMULET_CLASS:
      case FOOD_CLASS:
	if(obj->quan < 10L)
	  return "";
	else
	  return "";
      case COIN_CLASS:
	return "";
      default:
	switch(obj->otyp){
	  case CREDIT_CARD:
	  case TOWEL:
	  case BLINDFOLD:
	    return "";
	  case SKELETON_KEY:
	  case TALLOW_CANDLE:
	  case WAX_CANDLE:
	  case PICK_AXE:
	  case UNICORN_HORN:
	  case LEASH:
	  case STETHOSCOPE:
	  case MAGIC_MARKER:
	    return "";
	  case CRYSTAL_BALL:
	    return "";
	    break;
	  default:
	    if(obj->quan < 10L)
	      return "";
	    else
	      return "";
	}
    }
}

/*-------------------------------------------------------------------------
	ʸΤѥ
  -------------------------------------------------------------------------*/
static const char *ro0 =
	"                                                  "
	"                      ()ݡݡ            "
	"        š               (  )            [  ]    {  "
	"}                           ʡΡˡϡݣ    ܡݡݡ"
	"  ᡿<    >  桦š            ã١ӡ"
	"á    //      ã          ()á    <>    "
	"  ʢܢ  ˡ  ߡᨨ-><-âʡâˡ                  "
	"                            ᢿᢾᢿ(    )  ||    "
	"                            /  /  ᢪ<>ˢ        "
	"                                    á            "
	"<<>>/   š                                  "
	"||äá|)ԡܢ                  ()                "
	"                                            ()áâޢܢޢܡ"
	"֢ޣ /                            ʣţ( ޣ )"
	"Ƣ֨  ||    |<  |_  Σ||֣()Ƣϥ  ޡ"
	"ʤ /VVΡˡá                              "
	"  ݣ  ã졦|<    ||||      ܡ"
	"||  vv><Ρݢ                    ᤪɡá"
	"    Τ襫    <     |+  ˡ  ܣ㤵  "
	"l     ʣ  t+  ƣڤ  ʤ  Ĥ         ("
	"        äΤJ)Τ褱    Ʋ    Ͼ  "
	"      Ϥޤ    7+ߤ()áܤġܤ    "
	"夦äΤ  äåĤΤȥ/v            "
	"                                ݥեΥΣΣ  ߨݣԢ"
	"    ᥫ  ᨫ  Υե  Υ   ]  ++    "
	"տͥ  伷  Υ  ᥿    ΡΥ  ᢩ  á"
	"  ܥΡݡեе    Ρ    ̥    Υ    "
	"        աܡΡ    ݥݥᥳ"
	"գΥΥΥᨣա֥եաΥ  ʨ        "
	"                        ʣţáܢʣƣ̣||ϡݡ  |<  "
	"/ ֣||ʥˢ()ƣ>_ܡâˡááܢ          "
	"                            |3B                                 "
	"                                                                "
	"                                                                "
	"                                                                "
	"                ʧţá  ƣ̧    ޤ||֧  |<  "
	"J|Σ||()Ƣ( ޡãΡ񧰡̢ݤ||ݧ  "
	"||â-)  |O                                            "
	"                  ( 茶ԡ      ݧ                    "
	"                                                      "
	"                                                              "
	"                                          "
	"                                "
	"    ";

static const char *ro1 =
	"г  B е            ب    "
	"    ڿ͵  ɽ˴ܻ    "
	"͹߽    粻װڸ    Ω    "
	"ӽ        ޴        Ķ¿  ķ  "
	"е        ҹ# е      ͭ      Υұ    ӵ"
	"  в  ѹǰ    ݡÿ  ѹ      "
	"    в  Ңв      Ļ    Ţӥ  "
	"      ؽϷ̴  ޥ粦º  ෳ  Ǥ  "
	"  Ϥͳ            ǵǥǱ  "
	"ʶѼ  Ȭϼܾ緻      ҹ翽"
	"߽׮ɿ    Ȭ    е  ˭    "
	"  ȬĻ      Ƽ    "
	"չڸ  Ļ  Ļͳ              "
	"ƣڱ  ǰ  Ωԥȥȿ    о  ϸ"
	"Ȳɴ  ɴʬͥڲӧ  ӥ  Ӳ"
	"              ̲    ӥ    ʸȲ"
	"    ͳÿͲó𲿩Ϥ/|ر      "
	"  ׮      װھ  ۻ  ̲Ĳ"
	"          ܰͼȰ    ߺ  "
	"ݻԷ챹Τ  ڻ    ̾"
	"Թ    ɢ            ָ    "
	"  ֻڵǷ  Ω      ұ    "
	"            ֳ      ڼѹ  "
	"    Ļɴ̷    ƥ괢    𥤸̸  "
	"  ϸ      踵  ߸  Խ        "
	"          紳            û    "
	"      ƴ  𲸫ĳ          "
	"  꿩Ҵ  ̴  ܺн  𲸵"
	"ɧǸǻ        ¶  Ĵ    ٥ʿ  "
	"¶¶¶      ե㥷ͶԲ  "
	"  ׸ʳ  ʼֶϴ񷻥    ٳ  "
	"    ¶  ҥޥͻӲ    ұ  ұ  ұθ    "
	"ڵ̷  ڸ  ǳ    ȣ֥    奤ǵ  "
	"  Ϥ  ҹ迴ھڣ    Ω  ײвȵݵ    彽"
	"ᥭڥҹŵ        ­  漨"
	"еλ        ѺΩ  ϡҹ¨ݸ"
	"    ˵  ޿  ھ          Ǿҳϡ"
	"Ʊ    ¨  ﶿϥǵ  Ѻڡġдದ  "
	"Ʊ    ұḶ̌ԶԷ粦ӼͥϾ  û  "
	"  ͺ    ̸⺱ L  ұ  ҹ  "
	"ȶ϶ϵ϶ö  ȸ⿩  깩        業  "
	"ж  ײַ귽ǽ    ڻڶ⽩ư  "
	"  Ӽ    Ȳð      Ѻھڲ"
	"    װͳ    弫  ǵھö    ķ"
	"  Ƽֻ巵  ڷ    ݷɸĻ    "
	"ּ  ڿͥӷ  ȬȻ    "
	"            ڽ׮濴  ϼ    "
	"    ̶      иܼͷܷóִ  "
	"  ϱñѺ̴յݸ    е帼"
	"ɧ  ʿ  θŽŻұ  ֵݱھڸ"
	"  Ǵ  ոŷ  ѹ­ŸƦٲ      "
	"޸鲷ڸ  ¶иӸղ  "
	"Τϻ    еѺϥ๩ϸϥұ̻ᥳĸи"
	"жڹһҤߥԢݥڿݥྮ˾"
	"ж      ھ  ж        𥷹"
	"йӹƹ幩岬аڣ߷ж"
	"ƢԵʹʸB ӹ⹭йⲬǲе"
	"Ļl|ϸظ      ֡ұŷ  ȶ̲ӻ"
	"ӹΤ  ޿  ӥ    ǥإ"
	"ڿ츺츺ںں  ұ˥"
	"    ʥ浺ڳоⳭк    "
	"      𴨥  ĥ    ߲вӥ"
	"ͼƼĺ  B     ں  Ͳ  ȿ  "
	"ȿ      ͭŷ  дϩĻ    ֥  "
	"۳    ڽ  һ  Һ  ͼ    ڤ"
	"  ̲ĵ||Ф  ݻ    ھ"
	"Ʋɧװŷ  ׳Ӱ  ֶԻΥ"
	"  ۳  =]  ɤݽԼλ  һο"
	"Ŀ  ھ¶ڻپ  ƥ[+EE  ͻ߲ӥ"
	"ٷݥѽ˸ʸָ׺𲿩ʻЯ"
	"    ѹ߻      汫  м"
	"  ܻ  ɥͼ湩׵޺ͳϻܸ"
	"׽  ӿ  Գ      ѻ׺Ƿ    "
	"ġ  Ϳ  ˽ھ;ͼ  ڻ徯ڱƤ  "
	"  ұ  Ȭڼ۲мۺӼ۲Ӽܶױ    ݱ㿴  "
	"  ѥ  Ƽ  ӽŷ  ɴ        "
	"ڵ˻      Ľ    ǵӲл"
	"  ð      ζ  ­ּ    ӽȻӵ"
	"ż  ɥ  ̷ҽ><᷸彾Τ⽼      "
	"ͷ      ڻԥܥ    ׽  Ω  ϰ  "
	"    ƽܵ  Ȼ      º  ӵܥͶ"
	"Խ    Լ        Գ;ͽ;  ǡ"
	";        ҹԥװ  ΩȾ  ݾΩ  "
	"  Э    Ⱦλ徯        "
	"ڸھھھǾ      ж    оо"
	"Ӳ  ƾ徤      Խž"
	"  ӶŶƸ  ׾Өݥʥλ  ܾ      "
	"    ͫ  ھ    ĳ  °  "
	"ľ  Ҽ  ľ  ľȼȥó  ä翽  "
	"ää    Ϥ  ä  ɶ  ӡ  ͳ"
	"Ϳ  忽      ɸļΩ  ⽽äΤإ"
	"    Υ¶ɤ  ÷      ׿ϻ  "
	"Ʀ  鿽    Эзܿ´    "
	"ͭ  ͭھڶ  ھ  Ǿ  "
	"    ܤ  ĵɥ    Ͻ      ھ«"
	"ں߲  ļ  ޸"
	"  ʸ  ӷҾܶ    ڶԸ  "
	"  λ׷­­Ǽ    ><  շ"
	"¨忧ѸñѺ  ͳl|ñͱ"
	"ç  ð            ɥӼ"
	"ͼȬ  ­ç    ͵ӷl|ӵȻ  "
	"ФñҾڻ  Ȭɥ  ɥɥ«"
	"ͳӳƳڻӸͳ            ȼ"
	"          ҹʪ꿴ͳ  鿽  ö"
	"ñ      ʥͳܷ꿴彡    װ"
	"  ԰ɥŷ    ұ¾      ¢      "
	"­  §    Ǽ­  ۳§  ɥ«  ë  㻳ек"
	"ͳų  ʻһҷϽ  ¹    ͼ      ͭ  "
	"    ཮ں  ñڽʸ廳¶һ  "
	"濴ǽ׿      峭      "
	"׵ͥǴĻε  ζ    ߥ        "
	"ڲ쵸߷  㼪    Ӹϸǿö    "
	"ʶ  ظΤ  ºװ  ᷸öóö  "
	"׷    ƦΩñ꼪  öɥй  ñ"
	"ƶй  ϸľ  鼪  βľ  "
	"ھڸĥTT    ӼФܥ"
	"ͳ  濴ͳ  öڼ    ϼڱ  "
	"      Эѹ̼  ζ  ĹĹھħ  "
	"  ī  Ĺ­"
	"  Ǳ«    ŷǤ⿿      "
	";g        ٫ڵ    нĻ  ڽ"
	"  ʿͳȬҶĻе        곭"
	"  ɥ  Ω׮Ĥ          "
	"뽮­          侦ھ  "
	"ͳ  ⾦  ޸    ֻ  ⼺ʻڿ    "
	"  ųֱʩ֢  б÷  ʪ  ;  "
	"      Ʀ  ;    л"
	"ۿ      Υ      Ĺ  Ļ  Ļ    "
	"  «        ұ    Х  Ʀ      "
	"Ʊ  彼          ­      Ʀ"
	"    ư    ƻƸ  Ƹ  Ʊ  Ƹ  ΩΤƱ    Ʊ"
	"岼Ļ  ҹƿ    ܲѹ        []"
	"  ͳĻ׵          ھ      "
	"𱦱  缨Ŀͥ          ӥ  嵵"
	"ġ  ַ    ׵  ұä    ++    "
	"դΡ  ½ѿϿǦ      ҲĴ  "
	"𺣿ǰ      ꥢ  ׮е¶Ķ  ҥĶ"
	"  äʸ̦              Ƚ    "
	"ţ  ȯ  ٰ٪  ھԻ̷Ӹʰ̸Ω˿"
	"  ˿  ˿    ξ鳭ΩΩ  ʿ    "
	"            ˽    ˽    öŷͧ  "
	"    ë      θ    ܲľĥΡȯ    ȯ"
	"ͧ  ͧ  Ȳ  ȲĻ      Ⱦ  Ⱦ  Ⱦȿ"
	"̲ʸȿ  :e    ȿ)e  Ⱦ    ȿ  "
	"ʬǿȿ    й̻  ҹĥУ    "
	"󿴸    ʸɬ  ɬ    ǽ      "
	"ʦ  ]E  ̲¶  ھ  ĺȫ  "
	"  ҹѹļ    ɴ  Τ      ڲý"
	"屯  ɽ  ɼ    ɼ  ɼ  ʿ츼ī  ʺ"
	"Ӿ  Ķʼ  Ϸӿ  ʼ  ʬ  ھ"
	"Ф  ŷ  Ʊĥʶ        "
	"ȬЩ  Ȱ  Ἣ  ȡ      ̵  ׵̵"
	"̵  Ω    ϩ  帤ķȿķ  "
	"  Ĥ  ʦ  ޵Ȭ        ʬ  ӲӴ  ʬ"
	"ưۻʬʬеЩ缪      ֢  ɶҴ  װʺ  ¹  "
	"ڢɴ      ٨  ٨  ٨  "
	"  ȿ  ٨    Ͻȥװص  ߾ѿ  "
	"  ʬ׵  ð      ұڹȿФ"
	"  黳      ھʷ        尩  "
	"          챡    Ļ  ĻǷ  еҾ  Ω"
	"˴˴    ˴ܻ  ˿"
	"  ̶  ǥ  Ц    ڥȵھΦ  Ķ"
	"        ֱ  ʬ㵴Τ  ̤̤"
	"ھ  Τ      ͭº  еŷЩ    "
	"      Ϥ  ξ      ̤    ̤  ¶  "
	"ɬɬ    ǰ    ӻ  ̷̱ھͼ  ¥ͽ̳"
	"Ļڵɥöͼá  ̾ĻҳꥯѺ"
	"  ɴ      ˴һ  ˴ܻ̤Ӳ  "
	"Թڹұ    ƿ翴ʸF]  ұ"
	"  е    Τͽ  ŷ    ռ      ­Ωı  "
	"        ͳ    𲥤ͫ    ͭ    "
	"ɴ  ͳͦ        ͱë      "
	"  ո  ϻ  ͽ  Ͻë        "
	"ͣ            ö液Ⱦ      "
	"        ë  ë  Ω        ̤    «"
	"ĳ    ӳ夷    ܯ      øӥ˾"
	"ڻڲΤΤ  Τ  ´еΧ    ĳ"
	"    α    Ľ  ΩΩ  Ϥ  ȻTK˥Э  "
	"з  Ļз  ۴      зз      з  öΤ"
	"  ʻ  Τ    ʼα  "
	"Τ    Ļ纣            ͤ  ᴾ"
	"ᱫ¼  ƥ꾯  Ϣ    "
	"  Ϣ      ϥ  иͳ­Ʊϩ    Ϻװ"
	"ɷƽϺ        ε  ڥζ  еȬ  ͥ"
	"    ӥͭϡ谿  Ļö    "
	"    ׿      ";

static const char *ro2 =
	"׵  ұ  أ          ΡЪ          ͽ"
	"С  ][  ۰  еܵ    ^^ǵ  ̿ͥȥ楤"
	"Ͻ  ж      ʦ        ¿          "
	"ɴ  ͭ    к      ͳ      Τ      "
	"      ѻ    ´                  ҹ  "
	"糧  ɧ                  ҿ  ̿      "
	"  Ϭ            Ƹ    ѡ              "
	"̴                ѹ  Ѻ            Ȭ"
	"̰ۦ ]̦  ͳƱͳ  ѽ̸        "
	"                  ѹ  ȽǤܹܣ̡д"
	"              «      "
	"  Ы      ɼ  ѡ  ѡѡ          Ͼϵ"
	"  Ͻ  ϫ                  Υ޿϶ұұ"
	"ұұ  ң̦ҹҹҹҹ  ҹʶ彽װװ  "
	"Ȼڲе|]  ëǴ  Ρ§̲  ̻ȥ    "
	"        Ȭвԥж"
	"ʬʸܥʥåܥۥ"
	"եϷ  "
	"                Ϯ          ::  "
	"    ǰ                      á  ñ    "
	"      μ          Ϸ    ҿ      ²      "
	"  Ϣ        ѻ  ī  ̵          ڹ  ǫ  "
	"ɡ  έ                                £      "
	"  ͭ  "
	"ڲڻڷڶڻڴЪ  ڰںڹ"
	"ڻ岼ڳڰڲ´ӥ"
	"ڱڲڳڻڻڴڵºڱ  ԧ  "
	"        ע          ζ    гƦ  ɥ    "
	"ץ      ͼ¿    罽磵  Ω緽"
	"        ҿ  ۽    öӽ"
	"װǤ        ˽Ѱ        ӽ"
	"        ٽ  ҿ        ɼ            "
	"˽˽  ɡ          λ  ǵһ    ۻҰ  "
	"    ʸҼ  е  ߥ߿ä                        "
	"  ı۰              "
	"        ʻỳ    ʬ"
	"ͳỳʿ̱ۻ        Ļ  ë  "
	"                    ŷ        "
	"    ҿ            ѡ    δ            ſ  "
	"      <<  к  ûҥҶҼ۶    Ҳ"
	"̽Ԣ  ׵Ƹȶ++TTװ  е§"
	"̵  İ    "
	"׮ͳʽװ  װ                  ۵ݵݼ  ӧ      "
	"ݥ    ̥  ĥ  ƳʦƲƺƽ"
	"        ƹƴ            ľ  ʬ  "
	"        㿴Ҳö    ʦ  ʿ      Ǥ  ٿ"
	"ҳ  ϡ            Ʊ  ӿ        «  "
	"        ͸      г      ´        Ĺ  "
	"      ާ    տ          §    ̱ھ  "
	"                Ͱ              "
	"      ¤    ư  ƿ  ɼ          ż          "
	"    ̵                            "
	"                ׵              "
	"        ͺ          "
	"ͽ      ȴ            ۼ        Ⱦ  "
	"  ʦ    Ω                ¸      "
	"          ұ      ̿          "
	"        鱱    ͼ̴              "
	"        ĳ        з  ҩ        й    "
	"ã        еХ              ע  Ţ    "
	"              ھ  ھ  ھھھ  "
	"«ھ;ھ;ھھھڽ  ѡھɻͿж  ð"
	"Ω֥  ᴳ  ŷмʸ  "
	"ް      ä        "
	"        ̽  ö          з      ע    "
	"    Ÿз¶    ζ    ǵ"
	"ڴڸڹ׵ڻڲ  ڸͽھʬڸھ"
	"װ۶ڲڲ«  ҹڶڳڻڽΩ"
	"ڱڴڶڱڹڻڽ¸̶ڳĻ"
	"ڹڰʼϤӲгڼڷڵ"
	"¶ڼ۳  ڹڷڲڶ  ںڽڰڽھ۳  "
	"ھǰŵڻǵڳڸڽڼڷ"
	"ڼڿ̷ڼڻ  ڵ"
	"ڹڹڹںڴںڱڲ̽α"
	"εڳԳ  ڷ  ڻڻڽڿҿ"
	"̩̪ڱϬڴڴڴںھƸĻ"
	"ڸڰڷѡԧݡڴҼǫڱ"
	"ڳܯڱک  ڱڸڴ  "
	"    ҿ籩ѡзͼƱ"
	"Ωư׵׵  ҿձ轼"
	"ӵ    ӱй˴̱ᤷʬƹ廳      "
	"          ʬ    ȿ                  "
	"          ˳  ̱  ʿ      ҳ          "
	"  ǡ                    ڱ  "
	"ȡ  ¶        ´              ѹ"
	"      ڲ          ö          "
	"ޥ        һ    ˡޫ            "
	"    ̽        ͸        «  "
	"ĥ            ۷              Ƹ  "
	"        з      ʹ                    "
	"ǫ              ˽    έ  θ              "
	"  ߾׽    ͼвоĲĲеʺа  "
	"ог  кΩ̦      йĲੲнŲ"
	"©йײа    ׵زֲзб̲пã"
	"쵽۲⺲ʲ  ͧ    Щ૳=|    ԧ"
	"ϴ              "
	"ʦ              ѻ      ´          "
	"            ǫ                  "
	"            Ϻ        ˡ    ɬ    "
	"        ̶      ̲  ζ      򱻿ɱ"
	"鴤ִʬӴɴѴҿ촤̴    "
	"ŹĲİĥĥİĻĳĽ;"
	"Ĵľ  ļ      "
	"ö´"
	"    α"
	"ҩ  ſ    ŷ"
	"ѹȿ鷳鷳в"
	"ӻ绮滮廮ȻƢܾ  ܸݶ"
	"̶̤ܺܰѻ  ܹܼ  ̽  "
	"Ʋ    ܴܵܰѡܸܸľ̷"
	"йעгз´вΩп"
	"йкŸбе"
	"еۼ̦ʼἨм㼨ɬ׵¶"
	"Ƽż˭  ӱӵ  ݲӾӲ¶ľ"
	"ӼӲ󼨲ǲӱӹӰƲӷòӺԲԧӺвӵ޲ӵ"
	"ķ꥿귯ӥ  ̷ʷͷδη"
	"ΩΩΩʬΩΩΩΩ  ΩɴΩΩ«ΩΩҴ        "
	"                  װ          Ϥ  "
	"            ٺ                    "
	"        ŷ          ̬      ζ    ²  "
	"Ħ  ɭ                    ѡ      "
	"  α        ȵ  ȵ    Υ  ƽƸͱƹ缡Ƽ"
	"Ʊɴƹ´ƽƲƽƿƲ  "
	"Ƽƻ  夷в屾ʸĻ幭"
	"ȾԻ  彿ǡȻ߻彨ŻϤǦ"
	"ͻ崬ӻ᷻岸ϻջ崱弪"
	"ʻ׼  庪һ׸ϻ˻庹  快忸ɻ  Ļ嶯"
	"ػɼϬ߻Ϣ延ֻз幬  "
	"ѻƻƻлɻƷǻ廿λϹǻŻȻ"
	"ǻ̹  ̳  ޴ĥᴳ  ˴    ̱    "
	"    Ƥ        ϳ״Ѻ  ӻӷ    "
	"й  ӸٱΩ籩ӱ٨"
	"ϷϷϷ̤бϤнпм߼Ἢ弪ͳ  "
	"μ꼪װ    ǫ  襭Ĺ˴"
	"÷ɥͳУȾʷ߷ä"
	"ŵܷܷ׷߷̷"
	"շι߷Ԣ׷ַ´·"
	"ѡƷͷ⺷¢꼼  ͱװ"
	"˱ϻ㽮Ľͳսҽ׽㽮⽮Ƹ"
	"ԧؽϥ⺽ͳ׺˭֥  ++Щ  ˴        ʬ  "
	"                    ʿ          Ω  "
	"            ǡ  ¸        ̾        "
	"              ;  Ʀ  Ǧ            "
	"沦    ´          Ĺ      ޤˢ    װ  "
	"ο    ť                          "
	"  ӥ          Ϸ              "
	"            ²    Ҷ              "
	"  ͱ      ĵ  ̴  ԧ    Ϭھ        "
	"    ¢      㼷ݼ        ӵ    "
	"  ζ        強Իʸȱ  "
	"ͳϷ"
	"ұäѼ;"
	"ӥ٨"
	"  ̽ϺΨƲϬ"
	"  굻  "
	"    챯ϹԸԸ  İ  ᰥ  ͿǤ"
	"ĥöȾͷ岼͹԰ȵ"
	"ͷ΢  ߷ͰܥͶҥͺʥͷ٨ݰ    Ϳ"
	"͸ץͶɽ  ͽϬťñͼʹƥ͵ȥΥͿƥ"
	"ک  ϸ  긫หԸ챸ʸ      "
	"ѱѺѻӳȸĸ"
	"  ܸи"
	"Ӹ৸˸Ը٨"
	"̸ӧ׸¸ĸɬո̸ҿ׸ظ"
	"સ̷иظظ  ʸиθï"
	"ȸë糲ëë  ƦƦƦͩƦλ쵷쵼  "
	"츺츾츳층ɴΤѻⳭ泭"
	"˳      Գ쳭ĳճ"
	"⸳Ƴ곭ʳȿּǷ  ­­­­"
	"­­­­­­­­­­­«­­­­­"
	"­­­­­ͦ­  ­­­­­­­­­­ξ"
	"­ɭ­­º­­­­­­­­­Ţ­­­­"
	"ȵݿܿ˭۴ȴ֤  ֲּļļֳֻּ"
	"߼ּȼ᷼ξξ׼ռļϼֹŸ"
	"ִֶּּۼ⺿  ɿ«  ɸ      "
	"  ͳ                              "
	"  ѹ                          "
	"                              ë  "
	"          ӴӲ̾Ӱ"
	"´ӻӰӻ˭  ͳӹ  Ȭ"
	"Ȭ϶϶⺵۶Զ⾯ܶⱯȿŶ⸼"
	"жĶţԶⱬ⽨Ӷгⰸ"
	"Ƕ᷶৶˧ֶĶӶ׶"
	"öƶ⼯¶ɶ²ضĶϢϬب"
	"ֶзⰥĶ  ע۶θͶ"
	"Ͷ⻿⻿ɶ  粼绳ʸ"
	"緽綦Ϥ籱簿罭  "
	"  ã          ɴ  ͭ  ʺ      "
	"                  ѡ          ζ  "
	"  ſó  ͽ´𲱫𲱫񱫾ӱ䱫ﱫѻ"
	"ӱѱα䱫Ʊ쾱ڱᱫ౫"
	"̸̱޳ϳ׺׿ϳױöʺ׷޳׾"
	"׷ҳ׽׽詳ѳãΥ걱  첻"
	"жǸǿǵǴǲɧǻй"
	"ǲΩɼɼֿ𿩸򿩸ſ㿩;"
	"˧꿩տƿαؿ忩ç"
	"˶󰿹ʸϻϻϰϸϳϽ"
	"Ͽͳ¶٨Ϻҿϻɼ϶"
	"ϹѡϼϡչƹܹϬ"
	"˭Ĺʦ"
	"||++򨶦ѻ  ҥ򵴵ѵ樵ξ"
	"  ޵ʿеߵµݵٵϵӵ"
	"ᵵ׵ѻ᷵׵ǰĵ"
	"յ˵ҵ  յαĵϵɼ"
	"˭ܵĻĻĻĻĻĻĻĻĻĻĻ"
	"ĻĻĻĻĻĻĻ̶ĻĻĻĻĻĻĻĻĻ"
	"ĻĻĻĻĻĻĻĻĻ  ĻĻ  ĻĻĻĻĻ"
	"ĻĻĻĻ̷ĻĻĻзĻĻ  ĻĻĻôƼ  "
	"缯Ƽ⼯¶        "
	"նٹйĹȹ޹ζ      "
	"Ʀͳɡ    ﾤﺱ"
	"­ﲰζ  ն    ̥  ̦";

/*
 * 򤸤ʸʸä
 */
static int
kanji2index(c1, c2)
unsigned char c1, c2;
{
#if (('')==0x8181)
	/* SJIS */
	if (c1 >= 0xe0) c1 -= 0x40;
	c1 -= 0x81;
	if (c2 >= 0x80) c2--;
	c2 -= 0x40;
	return ((int)c1 * (0xfc - 0x40 + 1 - 1)) + (int)c2;
#else
	/* EUC */
    	return (((int)c1 & 0x7f) - 0x21) * (0x7e - 0x21 + 1) +
	       (((int)c2 & 0x7f) - 0x21);
#endif
}

int
jrubout(engr, nxt, use_rubout, select_rnd)
     char *engr;
     int nxt;
     int use_rubout;
     int select_rnd;
{
    int j;
    unsigned char *s;
    const unsigned char *p;

    if(is_kanji2(engr, nxt)){
	return 1;
      }

    s = (unsigned char *)&engr[nxt];
    if (*s == ' ') return 1;

    if(!is_kanji1(engr, nxt)) return 0;

    j = kanji2index(engr[nxt], engr[nxt + 1]);
    if (j >= 0x0000 && j <= 0x02B1) p = &ro0[j << 2];
    else if (j >= 0x0582 && j <= 0x1116) p = &ro1[(j - 0x0582) << 2];
    else if (j >= 0x1142 && j <= 0x1E7F) p = &ro2[(j - 0x1142) << 2];
    else p = "";
    
    if (p[2] != ' ' || p[3] != ' ') p += select_rnd * 2;
    engr[nxt] = *p++;
    engr[nxt + 1] = *p;

    return 1;
}
