/**
 *
 */
package jp.sourceforge.jnfc;



import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef.HWND;

/**
 * @author hiroaki
 *
 */
public interface FelicaNfcLibrary extends Library {

	FelicaNfcLibrary INSTANCE = (FelicaNfcLibrary) Native.loadLibrary("./felica_nfc_library", FelicaNfcLibrary.class);

	int DEVICE_TYPE_NFC_14443A_18092_106K = 0x00000001;
	int DEVICE_TYPE_NFC_18092_212K = 0x00000002;
	int DEVICE_TYPE_NFC_18092_424K = 0x00000004;
	int DEVICE_TYPE_NFC_14443B_106K = 0x00000008;
	int DEVICE_TYPE_NFC_JEWEL_106K = 0x00000010;

	int	RE_NOTIFICATION_SAME_DEVICE = 0x00000000;
	int	NOT_RE_NOTIFICATION_SAME_DEVICE = 0x00000001;

    boolean felicalib_nfc_initialize();
    boolean felicalib_nfc_uninitialize();
    boolean felicalib_nfc_open(String port_name);
    boolean felicalib_nfc_close();
    boolean felicalib_nfc_start_poll_mode(long target_device);
    boolean felicalib_nfc_stop_poll_mode();
    boolean felicalib_nfc_start_dev_access(long target_number);
    boolean felicalib_nfc_stop_dev_access(long stop_mode);
    boolean felicalib_nfc_select_device();
    boolean felicalib_nfc_deselect_device();
    boolean felicalib_nfc_thru(
    	Pointer command_packet_data,
    	short command_packet_data_length,
    	Pointer response_packet_data,
    	short response_packet_data_length
    );
    boolean felicalib_nfc_set_timeout(int timeout);
    boolean felicalib_nfc_get_timeout(int timeout);
    boolean felicalib_nfc_set_poll_callback_parameters(
    	HWND handle,
    	final String msg_str_of_find,
    	final String msg_str_of_enable
    );

    boolean felicalib_nfc_get_last_error(int[] error_info);
    boolean felicalib_nfc_start_logging(final String filename);
    boolean felicalib_nfc_stop_logging();

    boolean felicalib_nfc_poll_and_start_dev_access(
    	int target_device,
    	int timeout,
    	Pointer device_info
    	);

    public static class DEVICE_INFO extends Structure {

    	public int target_device;
    	public byte[] dev_info = new byte[1];

    	public DEVICE_INFO() {
    		super();
    	}

    	public DEVICE_INFO(Pointer p) {
    		super(p);
    		read();
    	}
    }

    /* DEVICE_TYPE_NFC_14443A_18092_106K */
    public static class DEVICE_DATA_NFC_14443A_18092_106K extends Structure {

    	public DEVICE_DATA_NFC_14443A_18092_106K() {

    	}

    	public DEVICE_DATA_NFC_14443A_18092_106K(Pointer p) {
    		super(p);
    		read();
    	}

    	public int target_number;
    	public short sens_res;
    	public byte sel_res;
    	public byte NFCID1_size;
    	public byte[] NFCID1 = new byte[10];
    	public byte ATS_size;
    	public byte[] ATS = new byte[1];
    }

    /* DEVICE_TYPE_NFC_14443B_106K */
    public static class DEVICE_DATA_NFC_14443B_106K extends Structure {

    	public DEVICE_DATA_NFC_14443B_106K() {

    	}

    	public DEVICE_DATA_NFC_14443B_106K(Pointer p) {
    		super(p);
    		read();
    	}
    	public int target_number;
    	public byte[] ATQB = new byte[12];
    	public byte ATTRIB_size;
    	public byte[] ATTRIB = new byte[1];
    } ;

    /* DEVICE_TYPE_NFC_18092_212K or 424K */
    public static class DEVICE_DATA_NFC_18092_212_424K extends Structure {

    	public DEVICE_DATA_NFC_18092_212_424K() {

    	}

    	public DEVICE_DATA_NFC_18092_212_424K(Pointer p) {
    		super(p);
    		read();
    	}
    	public byte id;
    	public int target_number;
    	public byte[] NFCID2 = new byte[8];
    	public byte[] Pad = new byte[8];
    	public byte RD_size;
    	public byte[] RD = new byte[1];
    }
}
