package jp.sourceforge.jnfc;

import com.sun.jna.Callback;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.X11.Atom;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinNT.HANDLE;
import com.sun.jna.win32.W32APIOptions;

public interface MyUser32 extends User32 {

	public static final MyUser32 INSTANCE = (MyUser32)Native.loadLibrary("user32", MyUser32.class, W32APIOptions.DEFAULT_OPTIONS);

    public static class UNIT extends IntegerType {

        /**
		 * VAo[WUID
		 */
		private static final long serialVersionUID = -7015196814412748057L;

		public UNIT()
        {
            this(0L);
        }

        public UNIT(long value)
        {
            super(Native.LONG_SIZE, value);
        }
    }

	int SetWindowLong(HWND hWnd, int nIndex, Callback callback);

	int RegisterWindowMessage(String msg);

	class WNDCLASSEX extends Structure {
		public int cbSize;
		public int style;
		public WNDPROC lpfnWndProc;
		public int cbClsExtra;
		public int cbWndExtra;
		public HINSTANCE hInstance;
		public HICON hIcon;
		public HCURSOR hCursor;
		public HBRUSH hbrBackground;
		public String lpszMenuName;
		public String lpszClassName;
		public HICON hIconSm;
	}

	Atom RegisterClass(WNDCLASSEX wndclassex);

	class WNDCLASS extends Structure {
		public int style;
		public WNDPROC lpfnWndProc;
		public int cbClsExtra;
		public int cbWndExtra;
		public HINSTANCE hInstance;
		public HICON hIcon;
		public HCURSOR hCursor;
		public HBRUSH hbrBackground;
		public String lpszMenuName;
		public String lpszClassName;
	}

	Atom RegisterClassEx(WNDCLASSEX wndclass);

/*	HWND CreateWindowEx(int dwExStyle, String lpClassName,
			Pointer lpWindowName, int dwStyle, int x, int y, int nWidth,
			int nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance,
			Pointer lpParam);*/

	class HBRUSH extends HANDLE {

	}

	class HCURSOR extends HANDLE {

	}

	interface WNDPROC extends StdCallCallback {
		LRESULT callback(HWND hWnd, UNIT uMsg, WPARAM wParam, LPARAM lParam);
	}

	class HMENU extends HANDLE {

	}

/*	HWND CreateWindow(String lpClassName, String lpWindowName, int dwStyle,
			int x, int y, int nWidth, int nHeight, HWND hWndParent,
			HMENU hMenu, HINSTANCE hInstance, Pointer lpParam);*/

/*	HWND CreateWindow(String lpClassName, String lpWindowName, int dwStyle,
			int x, int y, int nWidth, int nHeight, int hWndParent,
			int hMenu, HINSTANCE hInstance, int lpParam);*/

	HWND CreateWindowEx(
			  int dwExStyle,      // gEBhEX^C
			  Atom lpClassName,  // o^ĂNX
			  String lpWindowName, // EBhE
			  int dwStyle,        // EBhEX^C
			  int x,                // EBhẺ̈ʒu
			  int y,                // EBhȄc̈ʒu
			  int nWidth,           // EBhE̕
			  int nHeight,          // EBhE̍
			  int hWndParent,      // eEBhE܂̓I[i[EBhẼnh
			  int hMenu,          // j[nh܂͎qʎq
			  HINSTANCE hInstance,  // AvP[VCX^X̃nh
			  int lpParam        // EBhE쐬f[^
			);

	HCURSOR LoadCursor(HINSTANCE hInstance, String lpCursorName);

	LRESULT DefWindowProc(
			  HWND hWnd,      // EBhẼnh
			  UNIT Msg,       // bZ[W̎ʎq
			  WPARAM wParam,  // bZ[W̍ŏ̃p[^
			  LPARAM lParam   // bZ[W 2 Ԗڂ̃p[^
			);

	boolean DestroyWindow(
			  HWND hWnd   // jEBhẼnh
			);
}
