'''
Utility module to help with setting up the initial contents of the
JOY_HOME directory.

These contents are kept in this Python module as a base64-encoded zip
file, so you can just do, e.g.:

    import init_joy_home
    init_joy_home.initialize(JOY_HOME)

'''
from __future__ import print_function
from future import standard_library
standard_library.install_aliases()
import base64, os, io, zipfile


def initialize(joy_home):
	Z.extractall(joy_home)


def create_data(from_dir='./default_joy_home'):
	f = io.StringIO()
	z = zipfile.ZipFile(f, mode='w')
	for fn in os.listdir(from_dir):
		from_fn = os.path.join(from_dir, fn)
		z.write(from_fn, fn)
	z.close()
	return base64.encodestring(f.getvalue())


Z = zipfile.ZipFile(io.BytesIO(base64.decodestring(b'''\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==''')))


if __name__ == '__main__':
	print(create_data())
