class CfgVehicles
{
	class AllVehicles;	// External class reference
	
	class Air 				: AllVehicles
	{
		accuracy			= 0;		// accuracy needed to recognize type of this target
		flareVelocity 			= 100;
		class NewTurret;				// External class reference
		class ViewPilot;				// External class reference
		class ViewOptics;				// External class reference
		class AnimationSources;				// External class reference
	};
	class JSDF_Air	 			: Air
	{
		cost 				= 2000000;
		scope 				= 0;
		side 				= 1;
		faction 			= JSDF;
		vehicleClass 			= "Air";

		icon 				= "iconPlane";
		displayName 			= $STR_DN_PLANE;
		nameSound 			= "veh_airplane";
		unitInfoType 			= "RscUnitInfoAir";
		simulation 			= "airplane";
		vtol 				= 0;
		accuracy 			= 0.02;	// accuracy needed to recognize type of this target
		camouflage 			= 100;	// how dificult to spot - bigger - better spotable
		audible 			= 20;	// audible - bigger - better heard
		type 				= 2;//VAir;
		threat[] 			= {0.1, 1, 0.5};

		maxSpeed 			= 450;
		envelope[] 			= {0.0, 0.2, 0.9, 2.1, 2.5, 3.3, 3.5, 3.2, 2.5, 2.0, 1.5, 1.0};
		landingSpeed 			= 0;
		landingAoa 			= 10*3.1415/180;
		precision 			= 200;
		airBrake 			= 1;
		brakeDistance 			= 500;
		steerAheadSimul 		= 1.0;
		steerAheadPlan 			= 2.0;
		aileronSensitivity 		= 1;
		elevatorSensitivity 		= 1;
		flaps 				= 1;
		flapsFrictionCoef 		= 0.5;

		cabinOpening 			= 1;
		ejectSpeed[] 			= {0, 0, 0};
		ejectDamageLimit 		= 0.45;

		gearRetracting 			= 1;
		lightOnGear 			= 1;
		gearUpTime 			= 3.33;
		gearDownTime 			= 2.0;
		wheelSteeringSensitivity 	= 1.0;

		minFireTime 			= 60;
		minGunElev 			= 0;
		maxGunElev 			= 0;
		minGunTurn 			= 0;
		maxGunTurn 			= 0;
		gunAimDown 			= 0;
		weapons[] 			= {"FakeWeapon"};
		magazines[] 			= {"FakeWeapon"};

		extCameraPosition[] 		= {0, 1.4, -25};
		formationX 			= 200;
		formationZ 			= 300;
		
		class ViewPilot : ViewPilot
		{
			initFov 	=    1;
			minFov 		=    0.3;
			maxFov 		=    1.2;
			initAngleX 	=   10;
			minAngleX 	=  -65;
			maxAngleX 	=   85;
			initAngleY 	=    0;
			minAngleY 	= -150;
			maxAngleY 	=  150;
		};
		class ViewOptics : ViewOptics
		{
			initAngleX 	= 0;
			minAngleX 	= 0;
			maxAngleX 	= 0;
			initAngleY 	= 0;
			minAngleY 	= 0;
			maxAngleY 	= 0;
			initFov 	= 0.5;
			minFov 		= 0.5;
			maxFov 		= 0.5;
		};
		selectionFireAnim 		= "muzzleflash";
		selectionRotorStill 		= "Rotor_Static";
		selectionRotorMove 		= "Rotor_Blurred";
		selectionBackLights 		= "light";
		selectionBrakeLights 		= "light_stop";
		selectionDashboard 		= "light_panel";

		getInAction 			= "GetInHigh";
		getOutAction 			= "GetOutHigh";
		cargoGetInAction[] 		= {"GetInHigh"};
		cargoGetOutAction[] 		= {"GetOutHigh"};
		gunnerGetInAction 		= "GetInHigh";
		gunnerGetOutAction 		= "GetOutHigh";

		memoryPointsGetInDriver 	= "pos_driver";
		memoryPointsGetInDriverDir 	= "pos_driver_dir";
		memoryPointsGetInCoDriver 	= "pos_codriver";
		memoryPointsGetInCoDriverDir 	= "pos_codriver_dir";
		memoryPointsGetInGunner 	= "pos_gunner";
		memoryPointsGetInGunnerDir 	= "pos_gunner_dir";
		memoryPointsGetInCargo	 	= "pos_cargo";
		memoryPointsGetInCargoDir	= "pos_cargo_dir";
//		memoryPointsGetInCargo[] 	= {"pos_codriver", 	"pos_cargo"};
//		memoryPointsGetInCargoDir[] 	= {"pos_codriver_dir", 	"pos_cargo_dir"};
		getInRadius 			= 1.5;
		supplyRadius 			= 1.2;

		memoryPointDriverOptics[] 	= {"driverview", "pilot"};
		memoryPointGunnerOptics 	= "gunnerview";
		memoryPointGun 			= "pos_gun";
//		memoryPointMissile[] 		= {"spice rakety", "usti hlavne"};
//		memoryPointMissileDir[] 	= {"konec rakety", "konec hlavne"};
		memoryPointLMissile 		= "pos_Missile_L";
		memoryPointRMissile 		= "pos_Missile_R";
		memoryPointLRocket 		= "pos_Rocket_L";
		memoryPointRRocket 		= "pos_Rocket_R";

		memoryPointLDust 		= "levy prach";
		memoryPointRDust 		= "pravy prach";
/*
		class GunFire			: WeaponFireGun {};
		class GunClouds			: WeaponCloudsGun {};
		class MGunFire			: WeaponFireMGun {};
		class MGunClouds		: WeaponCloudsMGun {};
*/
		class DestructionEffects {};
		leftDustEffect 			= "LDustEffects";
		rightDustEffect 		= "RDustEffects";
		dustEffect 			= "HeliDust";
		waterEffect 			= "HeliWater";
		damageEffect 			= "DamageSmokePlane";

		class Exhausts
		{
			class Exhaust
			{
				position 	= "exhaust";
				direction 	= "exhaust_dir";
				effect 		= "ExhaustsEffect";
			};
		};
		class Reflectors
		{
			class Front
			{
				color[] 	= {1.0, 0.5, 0.3, 1.0};
				ambient[] 	= {0.2, 0.2, 0.2, 1.0};
				position 	= "light_front";
				direction 	= "light_front_dir";
				hitpoint 	= "light_front";
				selection 	= "light_front";
				size 		= 0.5;
				brightness 	= 1.0;
			};
		};
		aggregateReflectors[] 		= {{"Front"}};

		class MarkerLights
		{
			class RedStill		{name = "light_position_Red";		color[] = {0.20, 0.02, 0.02, 1};	ambient[] = {0.30, 0.03, 0.03, 1};	brightness = 0.01;	blinking = 0;	};
			class RedBlinking	{name = "light_position_Red_blik";	color[] = {1.00, 0.05, 0.05, 1};	ambient[] = {0.20, 0.02, 0.02, 1};	brightness = 0.01;	blinking = 1;	};
			class GreenStill	{name = "light_position_Green";		color[] = {0.02, 0.20, 0.10, 1};	ambient[] = {0.03, 0.30, 0.03, 1};	brightness = 0.01;	blinking = 0;	};
			class WhiteStill	{name = "light_position";		color[] = {0.20, 0.20, 0.20, 1};	ambient[] = {0.03, 0.03, 0.03, 1};	brightness = 0.01;	blinking = 0;	};
			class WhiteBlinking	{name = "light_position_blik";		color[] = {1.00, 1.00, 1.00, 1};	ambient[] = {0.20, 0.20, 0.20, 1};	brightness = 0.01;	blinking = 1;	};
		};
		armorStructural 		= 4;
		class HitPoints
		{
//			class HitHull 		{armor = 1;	material = 50;	name = "telo";			visual = "trup";		passThrough = true;	};
			class HitHull		{armor = 1;	material = 51;	name = "hull";			visual = "hull";		passThrough = 1;	};
			class HitTail		{armor = 1;	material = 51;	name = "hull_tail";		visual = "hull_tail";		passThrough = 1;	};
			class HitEngine		{armor = 0.25;	material = 51;	name = "engine";		visual = "engine";		passThrough = 1;	};
			class HitAvionics	{armor = 0.15;	material = 51;	name = "avionics";		visual = "avionics";		passThrough = 1;	};
			class HitVRotor		{armor = 0.3;	material = 51;	name = "rotor_main";		visual = "rotor_main";		passThrough = 1;	};
			class HitHRotor		{armor = 0.2;	material = 51;	name = "rotor_tail";		visual = "rotor_tail";		passThrough = 1;	};
			class HitMissiles	{armor = 0.1;	material = 51;	name = "missile";		visual = "missile";		passThrough = 0.5;	};

			class Hit_light_F	{armor = 0.001;	material = -1;	name = "light_front";		visual= "";			passThrough = 0;	convexComponent = "light_front";	};
			class Hit_light_FL	{armor = 0.001;	material = -1;	name = "light_front_L";		visual= "";			passThrough = 0;	convexComponent = "light_front_L";	};
			class Hit_light_FR	{armor = 0.001;	material = -1;	name = "light_front_R";		visual= "";			passThrough = 0;	convexComponent = "light_front_R";	};

			class HitRGlass 	{armor = 0.1;	material = 51;	name = "Glass R";		visual = "Glass R";		passThrough = 0;	};
			class HitLGlass 	{armor = 0.1;	material = 51;	name = "Glass L";		visual = "Glass L";		passThrough = 0;	};
			class HitGlass1 	{armor = 2;	material = -1;	name = "glass1";		visual = "glass1";		passThrough = 0;	};
			class HitGlass2		{armor = 2;	material = -1;	name = "glass2";		visual = "glass2";		passThrough = 0;	};
			class HitGlass3		{armor = 2;	material = -1;	name = "glass3";		visual = "glass3";		passThrough = 0;	};
			class HitGlass4		{armor = 2;	material = -1;	name = "glass4";		visual = "glass4";		passThrough = 0;	};
			class HitGlass5 	{armor = 2;	material = -1;	name = "glass5";		visual = "glass5";		passThrough = 0;	};
			class HitGlass6 	{armor = 2;	material = -1;	name = "glass6";		visual = "glass6";		passThrough = 0;	};
		};
		class AnimationSources 		: AnimationSources
		{
			class HitGlass1 			{hitpoint = "HitGlass1";	source = "Hit";	raw = 1;	};
			class HitGlass2 	: HitGlass1 	{hitpoint = "HitGlass2";	};
			class HitGlass3 	: HitGlass1 	{hitpoint = "HitGlass3";	};
			class HitGlass4 	: HitGlass1 	{hitpoint = "HitGlass4";	};
			class HitGlass5 	: HitGlass1 	{hitpoint = "HitGlass5";	};
			class HitGlass6 	: HitGlass1 	{hitpoint = "HitGlass6";	};
		};
		dammageHalf[] 			= {};
		dammageFull[] 			= {};
		destrType 			= "DestructWreck";
		secondaryExplosion 		= -0.1;

		class MFD
		{
			class HUD 		: AirplaneHUD
			{
				borderLeft 	= 0.09;
				borderRight 	= 0.02;
				borderTop 	= 0.02;
				borderBottom 	= 0.1;
				
				class pos10vector : Pos10Vector {};
				
				class bones : bones {
					class AGLMove1;	// External class reference
					class AGLMove2;	// External class reference
					class ASLMove1;	// External class reference
					class ASLMove2;	// External class reference
					class VertSpeed;	// External class reference
					class SpdMove2;	// External class reference
					class ILS;	// External class reference
					class WeaponAim;	// External class reference
					class Target;	// External class reference
					class TargetDistanceMissile;	// External class reference
					class TargetDistanceMGun;	// External class reference
					class Level0;	// External class reference
					class LevelP5;	// External class reference
					class LevelM5;	// External class reference
					class LevelP10;	// External class reference
					class LevelM10;	// External class reference
					class LevelP15;	// External class reference
					class LevelM15;	// External class reference
					class Velocity;	// External class reference
					class PlaneW;	// External class reference
				};
				
				class Draw : Draw
				{
					class Altitude;	// External class reference
					
					class DimmedBase : DimmedBase
					{
						class AltitudeBase;	// External class reference
					};
					class Speed;	// External class reference
					class SpeedNumber;	// External class reference
					
					class PlaneW : PlaneW
					{
						class LineHL;	// External class reference
						class Velocity;	// External class reference
					};
					
					class MGun : MGun
					{
						class Circle;	// External class reference
					};
					
					class Missile : Missile
					{
						class Circle;	// External class reference
						class Target;	// External class reference
					};
					
					class Horizont : Horizont
					{
						class Dimmed : Dimmed
						{
							class Level0;	// External class reference
						};
						class LevelP5;	// External class reference
						class LevelM5;	// External class reference
						class LevelP10;	// External class reference
						class LevelM10;	// External class reference
						class LevelP15;	// External class reference
						class LevelM15;	// External class reference
					};
					
					class ILS : ILS
					{
						class Glideslope : Glideslope
						{
							class ILS;	// External class reference
						};
						class AOABracket;	// External class reference
					};
				};
			};
		};
/*
		class Turrets
		{
			class MainTurret : NewTurret
			{
				commanding 			= -1;
				selectionFireAnim 		= "zasleh";
				body 				= "gun_main_turret";
				gun 				= "gun_main";
				gunBeg 				= "pos_gun_dir";
				gunEnd 				= "pos_gun";
				memoryPointGun 			= "pos_gun";
				memoryPointGunnerOptics 	= "pos_gunne_rview";
				memoryPointsGetInGunner 	= "pos_gunner";
				memoryPointsGetInGunnerDir 	= "pos_gunner_dir";
				castGunnerShadow 		= 1;
				viewGunnerShadow 		= 1;
				gunnerGetInAction 		= "GetInHigh";
				gunnerGetOutAction 		= "GetOutHigh";
				gunnerAction 			= "AH1Z_Gunner";
				gunnerInAction 			= "AH1Z_Gunner";
				gunnerOpticsModel 		= "\ca\air\optika_AH1Z";
				gunnerOpticsEffect[] 		= {"TankCommanderOptics1", BWTV};
				gunnerForceOptics 		= 0;
				enableManualFire 		= 0;
				outGunnerMayFire 		= 1;
				
				class HitPoints
				{
					class HitTurret	{armor = 0.2;	material = 51;	name = "vez";	visual = "vez";		passThrough = 0.3;	};
					class HitGun 	{armor = 0.2;	material = 51;	name = "zbran";	visual = "zbran";	passThrough = 0.1;	};
				};
			};
		};
*/
		class Sounds
		{
			class Engine			{sound = "soundEngine";		frequency = "(1-randomizer*0.05)*(thrust+0.5)*rpm";	volume = "thrust+0.5";		};
			class Movement			{sound = "soundEnviron";	frequency = "1";					volume = "speed*0.03334";	};
		};
		soundDammage[] = {"ca\sounds\air\noises\alarm_loop1", 0.0001, 1};

		class Eventhandlers 		: DefaultEventhandlers {};
	};
};