/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;

public abstract class AbstractSingletonProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean {
    private Object target;
    private Class[] proxyInterfaces;
    private Object[] preInterceptors;
    private Object[] postInterceptors;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private transient ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object proxy;

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProxyInterfaces(Class[] proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
    }

    public void setPreInterceptors(Object[] preInterceptors) {
        this.preInterceptors = preInterceptors;
    }

    public void setPostInterceptors(Object[] postInterceptors) {
        this.postInterceptors = postInterceptors;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() {
        int i;
        if (this.target == null) {
            throw new IllegalArgumentException("Property 'target' is required");
        }
        if (this.target instanceof String) {
            throw new IllegalArgumentException("'target' needs to be a bean reference, not a bean name as value");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.preInterceptors != null) {
            for (i = 0; i < this.preInterceptors.length; ++i) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.preInterceptors[i]));
            }
        }
        proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.createMainInterceptor()));
        if (this.postInterceptors != null) {
            for (i = 0; i < this.postInterceptors.length; ++i) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.postInterceptors[i]));
            }
        }
        proxyFactory.copyFrom(this);
        TargetSource targetSource = this.createTargetSource(this.target);
        proxyFactory.setTargetSource(targetSource);
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!this.isProxyTargetClass()) {
            proxyFactory.setInterfaces(ClassUtils.getAllInterfacesForClass(targetSource.getTargetClass(), this.beanClassLoader));
        }
        this.proxy = this.getProxy(proxyFactory);
    }

    protected TargetSource createTargetSource(Object target) {
        if (target instanceof TargetSource) {
            return (TargetSource)target;
        }
        return new SingletonTargetSource(target);
    }

    protected Object getProxy(AopProxy aopProxy) {
        return aopProxy.getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        if (this.proxy == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.proxyInterfaces != null && this.proxyInterfaces.length == 1) {
            return this.proxyInterfaces[0];
        }
        if (this.target instanceof TargetSource) {
            return ((TargetSource)this.target).getTargetClass();
        }
        if (this.target != null) {
            return this.target.getClass();
        }
        return null;
    }

    public final boolean isSingleton() {
        return true;
    }

    protected abstract Object createMainInterceptor();
}

