/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public class ContentDisposition {
    private String _disposition;
    private ParameterList _list;

    public ContentDisposition() {
        this.setDisposition(null);
        this.setParameterList(null);
    }

    public ContentDisposition(String disposition) throws ParseException {
        int semicolon;
        ParameterList list = null;
        if (disposition != null && (semicolon = disposition.indexOf(";")) != -1) {
            list = new ParameterList(disposition.substring(semicolon + 1));
            disposition = disposition.substring(0, semicolon);
        }
        this.setDisposition(disposition);
        this.setParameterList(list);
    }

    public ContentDisposition(String disposition, ParameterList list) {
        this.setDisposition(disposition);
        this.setParameterList(list);
    }

    public String getDisposition() {
        return this._disposition;
    }

    public String getParameter(String name) {
        if (this._list == null) {
            return null;
        }
        return this._list.get(name);
    }

    public ParameterList getParameterList() {
        return this._list;
    }

    public void setDisposition(String string) {
        this._disposition = string;
    }

    public void setParameter(String name, String value) {
        this._list = new ParameterList();
        this._list.set(name, value);
    }

    public void setParameterList(ParameterList list) {
        this._list = list == null ? new ParameterList() : list;
    }

    public String toString() {
        if (this._disposition == null && this._list.size() == 0) {
            return null;
        }
        return (this._disposition == null ? "" : this._disposition) + (this._list.size() == 0 ? "" : this._list.toString());
    }
}

