/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ModifierUtil {
    static final int BRIDGE = 64;
    static final int SYNTHETIC = 4096;

    private ModifierUtil() {
    }

    public static boolean isPublic(Method m) {
        return ModifierUtil.isPublic(m.getModifiers());
    }

    public static boolean isPublic(Field f) {
        return ModifierUtil.isPublic(f.getModifiers());
    }

    public static boolean isPublicStaticFinalField(Field f) {
        return ModifierUtil.isPublicStaticFinal(f.getModifiers());
    }

    public static boolean isPublicStaticFinal(int modifier) {
        return ModifierUtil.isPublic(modifier) && ModifierUtil.isStatic(modifier) && ModifierUtil.isFinal(modifier);
    }

    public static boolean isPublic(int modifier) {
        return Modifier.isPublic(modifier);
    }

    public static boolean isAbstract(Class clazz) {
        return ModifierUtil.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(int modifier) {
        return Modifier.isAbstract(modifier);
    }

    public static boolean isStatic(int modifier) {
        return Modifier.isStatic(modifier);
    }

    public static boolean isFinal(int modifier) {
        return Modifier.isFinal(modifier);
    }

    public static boolean isFinal(Method method) {
        return ModifierUtil.isFinal(method.getModifiers());
    }

    public static boolean isTransient(Field field) {
        return ModifierUtil.isTransient(field.getModifiers());
    }

    public static boolean isTransient(int modifier) {
        return Modifier.isTransient(modifier);
    }

    public static boolean isInstanceField(Field field) {
        int m = field.getModifiers();
        return !ModifierUtil.isStatic(m) && !ModifierUtil.isFinal(m);
    }
}

