/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.meta;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.seasar.extension.jdbc.ColumnMetaFactory;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.PropertyMetaFactory;
import org.seasar.extension.jdbc.RelationshipType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.exception.BothMappedByAndJoinColumnRuntimeException;
import org.seasar.extension.jdbc.exception.IdGeneratorNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.JoinColumnNameAndReferencedColumnNameMandatoryRuntimeException;
import org.seasar.extension.jdbc.exception.MappedByMandatoryRuntimeException;
import org.seasar.extension.jdbc.exception.OneToManyNotGenericsRuntimeException;
import org.seasar.extension.jdbc.exception.OneToManyNotListRuntimeException;
import org.seasar.extension.jdbc.exception.RelationshipNotEntityRuntimeException;
import org.seasar.extension.jdbc.exception.TemporalTypeNotSpecifiedRuntimeException;
import org.seasar.extension.jdbc.exception.UnsupportedPropertyTypeRuntimeException;
import org.seasar.extension.jdbc.exception.UnsupportedRelationshipRuntimeException;
import org.seasar.extension.jdbc.exception.VersionPropertyNotNumberRuntimeException;
import org.seasar.extension.jdbc.id.IdentityIdGenerator;
import org.seasar.extension.jdbc.id.SequenceIdGenerator;
import org.seasar.extension.jdbc.id.TableIdGenerator;
import org.seasar.extension.jdbc.types.EnumType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SequenceGenerator(name="default")
@TableGenerator(name="default")
public class PropertyMetaFactoryImpl
implements PropertyMetaFactory {
    protected static final SequenceGenerator DEFAULT_SEQUENCE_GENERATOR = PropertyMetaFactoryImpl.class.getAnnotation(SequenceGenerator.class);
    protected static final TableGenerator DEFAULT_TABLE_GENERATOR = PropertyMetaFactoryImpl.class.getAnnotation(TableGenerator.class);
    protected static final Map<Class<?>, ValueType> valueTypes = CollectionsUtil.newHashMap();
    protected ColumnMetaFactory columnMetaFactory;
    protected PersistenceConvention persistenceConvention;

    @Override
    public PropertyMeta createPropertyMeta(Field field, EntityMeta entityMeta) {
        PropertyMeta propertyMeta = new PropertyMeta();
        this.doField(propertyMeta, field, entityMeta);
        this.doName(propertyMeta, field, entityMeta);
        this.doTransient(propertyMeta, field, entityMeta);
        if (!propertyMeta.isTransient()) {
            Object relationshipAnnotation = this.getRelationshipAnnotation(field);
            if (relationshipAnnotation == null) {
                this.doColumnMeta(propertyMeta, field, entityMeta);
                this.doId(propertyMeta, field, entityMeta);
                this.doTemporal(propertyMeta, field, entityMeta);
                this.doVersion(propertyMeta, field, entityMeta);
                this.doLob(propertyMeta, field, entityMeta);
                this.doValueType(propertyMeta, entityMeta);
            } else {
                this.doRelationship(propertyMeta, field, entityMeta, relationshipAnnotation);
            }
        }
        this.doCustomize(propertyMeta, field, entityMeta);
        return propertyMeta;
    }

    protected void doField(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        propertyMeta.setField(field);
    }

    protected void doName(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        propertyMeta.setName(this.persistenceConvention.fromFieldNameToPropertyName(field.getName()));
    }

    protected void doColumnMeta(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        propertyMeta.setColumnMeta(this.columnMetaFactory.createColumnMeta(field, entityMeta, propertyMeta));
    }

    protected void doId(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        propertyMeta.setId(field.getAnnotation(Id.class) != null);
        GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            return;
        }
        GenerationType generationType = generatedValue.strategy();
        propertyMeta.setGenerationType(generationType);
        switch (generationType) {
            case AUTO: {
                this.doIdentityIdGenerator(propertyMeta, entityMeta);
                this.doSequenceIdGenerator(propertyMeta, generatedValue, entityMeta);
                this.doTableIdGenerator(propertyMeta, generatedValue, entityMeta);
                break;
            }
            case IDENTITY: {
                this.doIdentityIdGenerator(propertyMeta, entityMeta);
                break;
            }
            case SEQUENCE: {
                if (this.doSequenceIdGenerator(propertyMeta, generatedValue, entityMeta)) break;
                throw new IdGeneratorNotFoundRuntimeException(entityMeta.getName(), propertyMeta.getName(), generatedValue.generator());
            }
            case TABLE: {
                if (this.doTableIdGenerator(propertyMeta, generatedValue, entityMeta)) break;
                throw new IdGeneratorNotFoundRuntimeException(entityMeta.getName(), propertyMeta.getName(), generatedValue.generator());
            }
        }
    }

    protected void doIdentityIdGenerator(PropertyMeta propertyMeta, EntityMeta entityMeta) {
        propertyMeta.setIdentityIdGenerator(new IdentityIdGenerator(entityMeta, propertyMeta));
    }

    protected boolean doSequenceIdGenerator(PropertyMeta propertyMeta, GeneratedValue generatedValue, EntityMeta entityMeta) {
        SequenceGenerator sequenceGenerator;
        String name = generatedValue.generator();
        if (StringUtil.isEmpty((String)name)) {
            sequenceGenerator = DEFAULT_SEQUENCE_GENERATOR;
        } else {
            sequenceGenerator = propertyMeta.getField().getAnnotation(SequenceGenerator.class);
            if (!(sequenceGenerator != null && name.equals(sequenceGenerator.name()) || (sequenceGenerator = entityMeta.getEntityClass().getAnnotation(SequenceGenerator.class)) != null && !name.equals(sequenceGenerator.name()))) {
                return false;
            }
        }
        propertyMeta.setSequenceIdGenerator(new SequenceIdGenerator(entityMeta, propertyMeta, sequenceGenerator));
        return true;
    }

    protected boolean doTableIdGenerator(PropertyMeta propertyMeta, GeneratedValue generatedValue, EntityMeta entityMeta) {
        TableGenerator tableGenerator;
        String name = generatedValue.generator();
        if (StringUtil.isEmpty((String)name)) {
            tableGenerator = DEFAULT_TABLE_GENERATOR;
        } else {
            tableGenerator = propertyMeta.getField().getAnnotation(TableGenerator.class);
            if (!(tableGenerator != null && name.equals(tableGenerator.name()) || (tableGenerator = entityMeta.getEntityClass().getAnnotation(TableGenerator.class)) != null && !name.equals(tableGenerator.name()))) {
                return false;
            }
        }
        propertyMeta.setTableIdGenerator(new TableIdGenerator(entityMeta, propertyMeta, tableGenerator));
        return true;
    }

    protected void doTemporal(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        if (propertyMeta.getPropertyClass() != java.util.Date.class && propertyMeta.getPropertyClass() != Calendar.class) {
            return;
        }
        Temporal temporal = field.getAnnotation(Temporal.class);
        if (temporal == null) {
            throw new TemporalTypeNotSpecifiedRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
        propertyMeta.setTemporalType(temporal.value());
    }

    protected void doVersion(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        if (field.getAnnotation(Version.class) == null) {
            return;
        }
        Class clazz = ClassUtil.getWrapperClassIfPrimitive(field.getType());
        if (clazz != Integer.class && clazz != Long.class && clazz != Integer.TYPE && clazz != Long.TYPE) {
            throw new VersionPropertyNotNumberRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
        propertyMeta.setVersion(true);
    }

    protected void doTransient(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        propertyMeta.setTransient(field.getAnnotation(Transient.class) != null || ModifierUtil.isTransient((Field)field));
    }

    protected void doLob(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        propertyMeta.setLob(field.getAnnotation(Lob.class) != null);
    }

    protected void doValueType(PropertyMeta propertyMeta, EntityMeta entityMeta) {
        Class<?> propertyClass = propertyMeta.getPropertyClass();
        ValueType valueType = valueTypes.get(propertyClass);
        if (valueType != null) {
            propertyMeta.setValueType(valueType);
            return;
        }
        if (propertyClass == String.class) {
            if (propertyMeta.isLob()) {
                propertyMeta.setValueType(ValueTypes.CLOB);
            } else {
                propertyMeta.setValueType(ValueTypes.STRING);
            }
            return;
        }
        if (propertyClass == byte[].class) {
            if (propertyMeta.isLob()) {
                propertyMeta.setValueType(ValueTypes.BLOB);
            } else {
                propertyMeta.setValueType(ValueTypes.BYTE_ARRAY);
            }
            return;
        }
        if (propertyClass == java.util.Date.class) {
            switch (propertyMeta.getTemporalType()) {
                case DATE: {
                    propertyMeta.setValueType(ValueTypes.DATE_SQLDATE);
                    return;
                }
                case TIME: {
                    propertyMeta.setValueType(ValueTypes.DATE_TIME);
                    return;
                }
                case TIMESTAMP: {
                    propertyMeta.setValueType(ValueTypes.DATE_TIMESTAMP);
                    return;
                }
            }
        }
        if (propertyClass == Calendar.class) {
            switch (propertyMeta.getTemporalType()) {
                case DATE: {
                    propertyMeta.setValueType(ValueTypes.CALENDAR_SQLDATE);
                    return;
                }
                case TIME: {
                    propertyMeta.setValueType(ValueTypes.CALENDAR_TIME);
                    return;
                }
                case TIMESTAMP: {
                    propertyMeta.setValueType(ValueTypes.CALENDAR_TIMESTAMP);
                    return;
                }
            }
        }
        if (propertyClass.isEnum()) {
            propertyMeta.setValueType((ValueType)new EnumType(propertyClass));
            return;
        }
        if (Serializable.class.isAssignableFrom(propertyClass)) {
            if (propertyMeta.isLob()) {
                propertyMeta.setValueType(ValueTypes.SERIALIZABLE_BLOB);
            } else {
                propertyMeta.setValueType(ValueTypes.SERIALIZABLE_BYTE_ARRAY);
            }
            return;
        }
        ValueType userDefinedValueType = ValueTypes.createUserDefineValueType(propertyClass);
        if (userDefinedValueType != null) {
            propertyMeta.setValueType(userDefinedValueType);
            return;
        }
        throw new UnsupportedPropertyTypeRuntimeException(entityMeta.getName(), propertyMeta.getName(), propertyMeta.getPropertyClass());
    }

    protected Object getRelationshipAnnotation(Field field) {
        OneToOne oneToOne = field.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            return oneToOne;
        }
        OneToMany oneToMany = field.getAnnotation(OneToMany.class);
        if (oneToMany != null) {
            return oneToMany;
        }
        ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
        if (manyToOne != null) {
            return manyToOne;
        }
        ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
        if (manyToMany != null) {
            return manyToMany;
        }
        return null;
    }

    protected void doRelationship(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta, Object annotation) {
        this.doJoinColumn(propertyMeta, field, entityMeta);
        if (OneToOne.class.isInstance(annotation)) {
            this.doOneToOne(propertyMeta, field, entityMeta, (OneToOne)OneToOne.class.cast(annotation));
        } else if (OneToMany.class.isInstance(annotation)) {
            this.doOneToMany(propertyMeta, field, entityMeta, (OneToMany)OneToMany.class.cast(annotation));
        } else if (ManyToOne.class.isInstance(annotation)) {
            this.doManyToOne(propertyMeta, field, entityMeta, (ManyToOne)ManyToOne.class.cast(annotation));
        } else {
            throw new UnsupportedRelationshipRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
    }

    protected void doJoinColumn(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
        JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
        if (joinColumn != null) {
            JoinColumnMeta meta = new JoinColumnMeta(joinColumn.name(), joinColumn.referencedColumnName());
            propertyMeta.addJoinColumnMeta(meta);
        } else {
            JoinColumns joinColumns = field.getAnnotation(JoinColumns.class);
            if (joinColumns != null) {
                JoinColumn[] array = joinColumns.value();
                for (int i = 0; i < array.length; ++i) {
                    JoinColumn jc = array[i];
                    JoinColumnMeta meta = new JoinColumnMeta(jc.name(), jc.referencedColumnName());
                    if (i > 0 && (meta.getName() == null || meta.getReferencedColumnName() == null)) {
                        throw new JoinColumnNameAndReferencedColumnNameMandatoryRuntimeException(entityMeta.getName(), propertyMeta.getName(), i + 1);
                    }
                    propertyMeta.addJoinColumnMeta(meta);
                }
            }
        }
    }

    protected void doOneToOne(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta, OneToOne oneToOne) {
        propertyMeta.setRelationshipType(RelationshipType.ONE_TO_ONE);
        Class<?> relationshipClass = field.getType();
        if (relationshipClass.getAnnotation(Entity.class) == null) {
            throw new RelationshipNotEntityRuntimeException(entityMeta.getName(), propertyMeta.getName(), relationshipClass);
        }
        propertyMeta.setRelationshipClass(relationshipClass);
        String mappedBy = oneToOne.mappedBy();
        if (!StringUtil.isEmpty((String)mappedBy)) {
            if (propertyMeta.getJoinColumnMetaList().size() > 0) {
                throw new BothMappedByAndJoinColumnRuntimeException(entityMeta.getName(), propertyMeta.getName());
            }
            propertyMeta.setMappedBy(mappedBy);
        }
    }

    protected void doOneToMany(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta, OneToMany oneToMany) {
        propertyMeta.setRelationshipType(RelationshipType.ONE_TO_MANY);
        if (!List.class.isAssignableFrom(field.getType())) {
            throw new OneToManyNotListRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
        Class<?> relationshipClass = ReflectionUtil.getElementTypeOfList(field.getGenericType());
        if (relationshipClass == null) {
            throw new OneToManyNotGenericsRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
        if (relationshipClass.getAnnotation(Entity.class) == null) {
            throw new RelationshipNotEntityRuntimeException(entityMeta.getName(), propertyMeta.getName(), relationshipClass);
        }
        propertyMeta.setRelationshipClass(relationshipClass);
        String mappedBy = oneToMany.mappedBy();
        if (!StringUtil.isEmpty((String)mappedBy)) {
            if (propertyMeta.getJoinColumnMetaList().size() > 0) {
                throw new BothMappedByAndJoinColumnRuntimeException(entityMeta.getName(), propertyMeta.getName());
            }
        } else {
            throw new MappedByMandatoryRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
        propertyMeta.setMappedBy(mappedBy);
    }

    protected void doManyToOne(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta, ManyToOne manyToOne) {
        propertyMeta.setRelationshipType(RelationshipType.MANY_TO_ONE);
        Class<?> relationshipClass = field.getType();
        if (relationshipClass.getAnnotation(Entity.class) == null) {
            throw new RelationshipNotEntityRuntimeException(entityMeta.getName(), propertyMeta.getName(), relationshipClass);
        }
        propertyMeta.setRelationshipClass(relationshipClass);
    }

    protected Class<?> getRelationshipClass(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) throws OneToManyNotGenericsRuntimeException {
        Class<?> clazz = field.getType();
        if (List.class.isAssignableFrom(clazz) && (clazz = ReflectionUtil.getElementTypeOfList(field.getGenericType())) == null) {
            throw new OneToManyNotGenericsRuntimeException(entityMeta.getName(), propertyMeta.getName());
        }
        return clazz;
    }

    protected void doCustomize(PropertyMeta propertyMeta, Field field, EntityMeta entityMeta) {
    }

    public ColumnMetaFactory getColumnMetaFactory() {
        return this.columnMetaFactory;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setColumnMetaFactory(ColumnMetaFactory columnMetaFactory) {
        this.columnMetaFactory = columnMetaFactory;
    }

    public PersistenceConvention getPersistenceConvention() {
        return this.persistenceConvention;
    }

    public void setPersistenceConvention(PersistenceConvention persistenceConvention) {
        this.persistenceConvention = persistenceConvention;
    }

    static {
        valueTypes.put(Boolean.TYPE, ValueTypes.BOOLEAN);
        valueTypes.put(Boolean.class, ValueTypes.BOOLEAN);
        valueTypes.put(Character.TYPE, ValueTypes.CHARACTER);
        valueTypes.put(Character.class, ValueTypes.CHARACTER);
        valueTypes.put(Byte.TYPE, ValueTypes.BYTE);
        valueTypes.put(Byte.class, ValueTypes.BYTE);
        valueTypes.put(Short.TYPE, ValueTypes.SHORT);
        valueTypes.put(Short.class, ValueTypes.SHORT);
        valueTypes.put(Integer.TYPE, ValueTypes.INTEGER);
        valueTypes.put(Integer.class, ValueTypes.INTEGER);
        valueTypes.put(Long.TYPE, ValueTypes.LONG);
        valueTypes.put(Long.class, ValueTypes.LONG);
        valueTypes.put(Float.TYPE, ValueTypes.FLOAT);
        valueTypes.put(Float.class, ValueTypes.FLOAT);
        valueTypes.put(Double.TYPE, ValueTypes.DOUBLE);
        valueTypes.put(Double.class, ValueTypes.DOUBLE);
        valueTypes.put(BigDecimal.class, ValueTypes.BIGDECIMAL);
        valueTypes.put(BigInteger.class, ValueTypes.BIGINTEGER);
        valueTypes.put(Date.class, ValueTypes.SQLDATE);
        valueTypes.put(Time.class, ValueTypes.TIME);
        valueTypes.put(Timestamp.class, ValueTypes.TIMESTAMP);
    }
}

