/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.seasar.extension.jdbc.AutoBatchInsert;
import org.seasar.extension.jdbc.IdGenerator;
import org.seasar.extension.jdbc.IntoClause;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ValuesClause;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractAutoBatchUpdate;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBatchInsertImpl<T>
extends AbstractAutoBatchUpdate<T, AutoBatchInsert<T>>
implements AutoBatchInsert<T> {
    protected static final String INSERT_STATEMENT = "insert into ";
    protected static final Long INITIAL_VERSION = 1L;
    protected final Set<String> includesProperties = CollectionsUtil.newHashSet();
    protected final Set<String> excludesProperties = CollectionsUtil.newHashSet();
    protected final List<PropertyMeta> targetProperties = CollectionsUtil.newArrayList();
    protected final IntoClause intoClause = new IntoClause();
    protected final ValuesClause valuesClause = new ValuesClause();
    protected boolean supportBatch = true;
    protected boolean useGetGeneratedKeys;

    public AutoBatchInsertImpl(JdbcManagerImplementor jdbcManager, List<T> entities) {
        super(jdbcManager, entities);
    }

    @Override
    public AutoBatchInsert<T> includes(String ... propertyNames) {
        this.includesProperties.addAll(Arrays.asList(propertyNames));
        return this;
    }

    @Override
    public AutoBatchInsert<T> excludes(String ... propertyNames) {
        this.excludesProperties.addAll(Arrays.asList(propertyNames));
        return this;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareTargetProperties();
        this.prepareIntoClause();
        this.prepareValuesClause();
        this.prepareSql();
    }

    protected void prepareTargetProperties() {
        for (PropertyMeta propertyMeta : this.entityMeta.getAllColumnPropertyMeta()) {
            String propertyName = propertyMeta.getName();
            if (!propertyMeta.getColumnMeta().isInsertable()) continue;
            if (propertyMeta.isId()) {
                if (propertyMeta.hasIdGenerator()) {
                    IdGenerator idGenerator = propertyMeta.getIdGenerator(this.entityMeta, this.jdbcManager.getDialect());
                    this.supportBatch &= idGenerator.supportBatch(this.jdbcManager);
                    this.useGetGeneratedKeys |= idGenerator.useGetGeneratedKeys(this.jdbcManager);
                    if (!idGenerator.isInsertInto(this.jdbcManager)) continue;
                    this.targetProperties.add(propertyMeta);
                    continue;
                }
                this.targetProperties.add(propertyMeta);
                continue;
            }
            if (!this.includesProperties.isEmpty() && !this.includesProperties.contains(propertyName) || this.excludesProperties.contains(propertyName)) continue;
            this.targetProperties.add(propertyMeta);
        }
    }

    protected void prepareIntoClause() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            this.intoClause.addSql(propertyMeta.getColumnMeta().getName());
        }
    }

    protected void prepareValuesClause() {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            this.valuesClause.addSql();
        }
    }

    @Override
    protected String toSql() {
        String tableName = this.entityMeta.getTableMeta().getFullName();
        StringBuilder buf = new StringBuilder(INSERT_STATEMENT.length() + tableName.length() + this.intoClause.getLength() + this.valuesClause.getLength());
        return new String(buf.append(INSERT_STATEMENT).append(tableName).append(this.intoClause.toSql()).append(this.valuesClause.toSql()));
    }

    @Override
    protected PreparedStatement createPreparedStatement(JdbcContext jdbcContext) {
        if (this.useGetGeneratedKeys) {
            return jdbcContext.getPreparedStatement(this.executedSql, 1);
        }
        return super.createPreparedStatement(jdbcContext);
    }

    @Override
    protected int[] executeBatch(PreparedStatement ps) {
        if (this.supportBatch) {
            return super.executeBatch(ps);
        }
        int[] updateRows = new int[this.entities.size()];
        for (int i = 0; i < updateRows.length; ++i) {
            Object entity = this.entities.get(i);
            this.prepareParams(entity);
            this.logSql();
            this.prepareInParams(ps);
            updateRows[i] = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
            this.postExecute(ps, entity);
            this.resetParams();
        }
        return updateRows;
    }

    @Override
    protected void prepareParams(T entity) {
        for (PropertyMeta propertyMeta : this.targetProperties) {
            Object value;
            if (propertyMeta.isId() && propertyMeta.hasIdGenerator()) {
                value = this.getIdValue(propertyMeta, entity);
            } else {
                value = FieldUtil.get((Field)propertyMeta.getField(), entity);
                if (propertyMeta.isVersion() && (value == null || ((Number)Number.class.cast(value)).longValue() <= 0L)) {
                    value = INITIAL_VERSION;
                    Class fieldClass = ClassUtil.getWrapperClassIfPrimitive(propertyMeta.getPropertyClass());
                    FieldUtil.set((Field)propertyMeta.getField(), entity, (Object)NumberConversionUtil.convertNumber((Class)fieldClass, (Object)value));
                }
            }
            this.addParam(value, propertyMeta);
        }
    }

    protected Object getIdValue(PropertyMeta propertyMeta, T entity) {
        IdGenerator idGenerator = propertyMeta.getIdGenerator(this.entityMeta, this.jdbcManager.getDialect());
        return idGenerator.preInsert(this.jdbcManager, entity, this);
    }

    protected void postExecute(PreparedStatement ps, T entity) {
        for (PropertyMeta propertyMeta : this.entityMeta.getIdPropertyMetaList()) {
            if (!propertyMeta.hasIdGenerator()) continue;
            IdGenerator idGenerator = propertyMeta.getIdGenerator(this.entityMeta, this.jdbcManager.getDialect());
            idGenerator.postInsert(this.jdbcManager, entity, ps, this);
        }
    }

    @Override
    protected boolean isOptimisticLock() {
        return false;
    }
}

