/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.util;

import java.io.InputStream;
import java.util.Set;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassLoader
extends ClassLoader {
    protected final Set<String> includedNames = CollectionsUtil.newHashSet();

    public AbstractClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public AbstractClassLoader(ClassLoader parent) {
        super(parent);
    }

    public AbstractClassLoader(ClassLoader parent, Set<String> includedNames) {
        super(parent);
        this.includedNames.addAll(includedNames);
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.getSystemClass(className);
        if (clazz != null) {
            return this.resolveClass(resolve, clazz);
        }
        if (!this.isIncludedClass(className)) {
            return super.loadClass(className, resolve);
        }
        clazz = this.findLoadedClass(className);
        if (clazz != null) {
            return this.resolveClass(resolve, clazz);
        }
        clazz = ClassLoaderUtil.findLoadedClass((ClassLoader)this.getParent(), (String)className);
        if (clazz != null) {
            return this.resolveClass(resolve, clazz);
        }
        clazz = this.findClass(className);
        return this.resolveClass(resolve, clazz);
    }

    protected Class<?> getSystemClass(String className) {
        try {
            return Class.forName(className, true, null);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected boolean isIncludedClass(String className) {
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return false;
        }
        if (className.endsWith("package-info")) {
            return false;
        }
        if (this.includedNames.isEmpty()) {
            return true;
        }
        return this.includedNames.contains(className);
    }

    protected Class<?> resolveClass(boolean resolve, Class<?> clazz) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String path = ClassUtil.getResourcePath((String)className);
        InputStream in = this.getResourceAsStream(path);
        if (in == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            byte[] bytes = InputStreamUtil.getBytes((InputStream)in);
            return this.doDefineClass(className, bytes);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(className, e);
        }
    }

    protected abstract Class<?> doDefineClass(String var1, byte[] var2);
}

