/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.unit.impl.AnnotationTestIntrospector;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionTestIntrospector
extends AnnotationTestIntrospector {
    protected final Set<Class<? extends Annotation>> nonTestAnnotations = CollectionsUtil.newHashSet();
    protected final Set<Pattern> nonTestMethodNamePatterns = new HashSet<Pattern>();
    protected String beforeClassMethodName = "beforeClass";
    protected String afterClassMethodName = "afterClass";
    protected String beforeMethodName = "before";
    protected String afterMethodName = "after";
    protected String recordMethodName = "record";

    @InitMethod
    public void init() {
        this.addNonTestAnnotation(this.beforeAnnotation);
        this.addNonTestAnnotation(this.afterAnnotation);
        if (this.beforeMethodName != null) {
            this.addNonTestMethodNamePattern(this.beforeMethodName + ".*");
        }
        if (this.afterMethodName != null) {
            this.addNonTestMethodNamePattern(this.afterMethodName + ".*");
        }
        if (this.recordMethodName != null) {
            this.addNonTestMethodNamePattern(this.recordMethodName + ".+");
        }
    }

    public void setBeforeClassMethodName(String beforeClassMethodName) {
        this.beforeClassMethodName = beforeClassMethodName;
    }

    public void setAfterClassMethodName(String afterClassMethodName) {
        this.afterClassMethodName = afterClassMethodName;
    }

    public void setBeforeMethodName(String beforeMethodName) {
        this.beforeMethodName = beforeMethodName;
    }

    public void setAfterMethodName(String afterMethodName) {
        this.afterMethodName = afterMethodName;
    }

    public void setRecordMethodName(String recordMethodName) {
        this.recordMethodName = recordMethodName;
    }

    public void addNonTestAnnotation(Class<? extends Annotation> annotation) {
        this.nonTestAnnotations.add(annotation);
    }

    public void addNonTestMethodNamePattern(String pattern) {
        this.nonTestMethodNamePatterns.add(Pattern.compile(pattern));
    }

    @Override
    public List<Method> getBeforeClassMethods(Class<?> clazz) {
        List<Method> methods = super.getBeforeClassMethods(clazz);
        Method method = this.getMethod(clazz, this.beforeClassMethodName);
        if (method != null && this.hasValidStaticSignature(method) && !methods.contains(method)) {
            methods.add(method);
        }
        return methods;
    }

    @Override
    public List<Method> getAfterClassMethods(Class<?> clazz) {
        List<Method> methods = super.getAfterClassMethods(clazz);
        Method method = this.getMethod(clazz, this.afterClassMethodName);
        if (method != null && this.hasValidStaticSignature(method) && !methods.contains(method)) {
            methods.add(method);
        }
        return methods;
    }

    @Override
    public List<Method> getBeforeMethods(Class<?> clazz) {
        List<Method> methods = super.getBeforeMethods(clazz);
        Method method = this.getMethod(clazz, this.beforeMethodName);
        if (method != null && this.hasValidNonStaticSignature(method) && !methods.contains(method)) {
            methods.add(method);
        }
        return methods;
    }

    @Override
    public List<Method> getAfterMethods(Class<?> clazz) {
        List<Method> methods = super.getAfterMethods(clazz);
        Method method = this.getMethod(clazz, this.afterMethodName);
        if (method != null && this.hasValidNonStaticSignature(method) && !methods.contains(method)) {
            methods.add(method);
        }
        return methods;
    }

    @Override
    public Method getEachBeforeMethod(Class<?> clazz, Method method) {
        if (this.beforeMethodName == null) {
            return null;
        }
        String methodName = this.beforeMethodName + StringUtil.capitalize((String)method.getName());
        return this.getMethod(clazz, methodName);
    }

    @Override
    public Method getEachAfterMethod(Class<?> clazz, Method method) {
        if (this.afterMethodName == null) {
            return null;
        }
        String methodName = this.afterMethodName + StringUtil.capitalize((String)method.getName());
        return this.getMethod(clazz, methodName);
    }

    @Override
    public Method getEachRecordMethod(Class<?> clazz, Method method) {
        if (this.recordMethodName == null) {
            return null;
        }
        String methodName = this.recordMethodName + StringUtil.capitalize((String)method.getName());
        return this.getMethod(clazz, methodName);
    }

    @Override
    public List<Method> getTestMethods(Class<?> clazz) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Class<?> eachClass : this.getSuperClasses(clazz)) {
            Method[] methods;
            for (Method eachMethod : methods = eachClass.getDeclaredMethods()) {
                if (!this.isTestMethod(eachMethod) || this.isShadowed(eachMethod, results)) continue;
                results.add(eachMethod);
            }
        }
        return results;
    }

    protected List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList results = new ArrayList();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            results.add(current);
        }
        return results;
    }

    protected boolean isShadowed(Method method, List<Method> results) {
        for (Method each : results) {
            if (!this.isShadowed(method, each)) continue;
            return true;
        }
        return false;
    }

    protected boolean isShadowed(Method current, Method previous) {
        if (!previous.getName().equals(current.getName())) {
            return false;
        }
        if (previous.getParameterTypes().length != current.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < previous.getParameterTypes().length; ++i) {
            if (previous.getParameterTypes()[i].equals(current.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isTestMethod(Method method) {
        return !this.hasNonTestAnnotation(method) && !this.hasNonTestMethodName(method) && this.hasValidNonStaticSignature(method);
    }

    protected boolean hasNonTestAnnotation(Method method) {
        for (Annotation each : method.getAnnotations()) {
            if (!this.nonTestAnnotations.contains(each.annotationType())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasNonTestMethodName(Method method) {
        for (Pattern each : this.nonTestMethodNamePatterns) {
            Matcher matcher = each.matcher(method.getName());
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasValidStaticSignature(Method method) {
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return this.hasValidSignature(method);
    }

    protected boolean hasValidNonStaticSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return this.hasValidSignature(method);
    }

    protected boolean hasValidSignature(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        return method.getParameterTypes().length == 0;
    }

    protected Method getMethod(Class<?> clazz, String methodName) {
        for (Class<?> eachClass : this.getSuperClasses(clazz)) {
            Method[] methods;
            for (Method eachMethod : methods = eachClass.getDeclaredMethods()) {
                if (!eachMethod.getName().equals(methodName)) continue;
                return eachMethod;
            }
        }
        return null;
    }
}

