/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.log.Logger;

public class ToStringInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 8867582188275644844L;
    private static final String FIELD_SEPARATOR = ",";
    private static final String VALUE_SEPARATOR = "=";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String FIELDS_BEGIN = "[";
    private static final String FIELDS_END = "]";
    private static final String ARRAY_BEGIN = "{";
    private static final String ARRAY_END = "}";
    private static final Logger logger = Logger.getLogger(ToStringInterceptor.class);
    public static final String includeConstant_BINDING = "bindingType=none";
    private boolean includeConstant;
    public static final String includeStatic_BINDING = "bindingType=none";
    private boolean includeStatic;
    private DateFormat dateFormat = new SimpleDateFormat();

    public void setIncludeConstant(boolean includeConstant) {
        this.includeConstant = includeConstant;
    }

    public void setIncludeStatic(boolean includeStatic) {
        this.includeStatic = includeStatic;
    }

    public void setDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = this.getTargetClass(invocation);
        if (logger.isDebugEnabled()) {
            String methodName = invocation.getMethod().getName();
            logger.debug("[ToStringInterceptor] modifying " + targetClass.getName() + "#" + methodName);
        }
        try {
            return this.toString(targetClass, invocation.getThis());
        }
        catch (Exception e) {
            logger.error("[ToStringInterceptor] modify failed", e);
            return invocation.proceed();
        }
    }

    private String toString(Class targetClass, Object target) throws IllegalAccessException {
        StringBuffer buf = new StringBuffer(100);
        buf.append(targetClass.getName());
        buf.append("@");
        buf.append(Integer.toHexString(System.identityHashCode(target)));
        buf.append(FIELDS_BEGIN);
        boolean hasFields = false;
        while (targetClass != null) {
            Field[] fields = targetClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && !this.includeConstant || Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !this.includeStatic) continue;
                buf.append(field.getName());
                buf.append(VALUE_SEPARATOR);
                this.append(buf, field.get(target));
                buf.append(FIELD_SEPARATOR);
                hasFields = true;
            }
            targetClass = targetClass.getSuperclass();
        }
        if (hasFields) {
            buf.setLength(buf.length() - FIELD_SEPARATOR.length());
        }
        buf.append(FIELDS_END);
        return new String(buf);
    }

    private void append(StringBuffer buf, Object value) {
        if (value == null) {
            buf.append((String)null);
            return;
        }
        if (value.getClass().isArray()) {
            this.appendArray(buf, value);
            return;
        }
        if (value instanceof String) {
            buf.append(DOUBLE_QUOTE).append(value).append(DOUBLE_QUOTE);
            return;
        }
        if (value instanceof Character) {
            buf.append(SINGLE_QUOTE).append(value).append(SINGLE_QUOTE);
            return;
        }
        if (value instanceof Date) {
            buf.append(this.dateFormat.format((Date)value));
            return;
        }
        buf.append(value);
    }

    private void appendArray(StringBuffer buf, Object array) {
        buf.append(ARRAY_BEGIN);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            this.append(buf, Array.get(array, i));
            buf.append(FIELD_SEPARATOR);
        }
        if (length > 0) {
            buf.setLength(buf.length() - FIELD_SEPARATOR.length());
        }
        buf.append(ARRAY_END);
    }
}

