/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi.resourceFactories;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import winstone.Logger;
import winstone.jndi.resourceFactories.WinstoneDataSource;

public class WinstoneConnection
implements Connection {
    private Connection realConnection;
    private WinstoneDataSource datasource;

    public WinstoneConnection(Connection connection, WinstoneDataSource datasource) {
        this.realConnection = connection;
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        if (this.datasource != null && this.datasource.getLogWriter() != null) {
            this.datasource.getLogWriter().println(WinstoneDataSource.DS_RESOURCES.getString("WinstoneConnection.ReleaseRollback"));
        } else {
            Logger.log(Logger.FULL_DEBUG, WinstoneDataSource.DS_RESOURCES, "WinstoneConnection.ReleaseRollback");
        }
        Connection realConnectionHolder = null;
        try {
            if (this.realConnection != null) {
                realConnectionHolder = this.realConnection;
                this.realConnection = null;
                if (!realConnectionHolder.getAutoCommit()) {
                    realConnectionHolder.rollback();
                }
            }
            Object var3_2 = null;
            if (this.datasource == null || realConnectionHolder == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.datasource == null || realConnectionHolder == null) throw throwable;
            this.datasource.releaseConnection(this, realConnectionHolder);
            this.datasource = null;
            throw throwable;
        }
        this.datasource.releaseConnection(this, realConnectionHolder);
        this.datasource = null;
    }

    public boolean isClosed() throws SQLException {
        return this.realConnection == null;
    }

    public void commit() throws SQLException {
        this.realConnection.commit();
    }

    public void rollback() throws SQLException {
        this.realConnection.rollback();
    }

    public void rollback(Savepoint sp) throws SQLException {
        this.realConnection.rollback(sp);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.realConnection.getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.realConnection.setAutoCommit(autoCommit);
    }

    public int getHoldability() throws SQLException {
        return this.realConnection.getHoldability();
    }

    public void setHoldability(int hold) throws SQLException {
        this.realConnection.setHoldability(hold);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.realConnection.getTransactionIsolation();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.realConnection.setTransactionIsolation(level);
    }

    public void clearWarnings() throws SQLException {
        this.realConnection.clearWarnings();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.realConnection.getWarnings();
    }

    public boolean isReadOnly() throws SQLException {
        return this.realConnection.isReadOnly();
    }

    public void setReadOnly(boolean ro) throws SQLException {
        this.realConnection.setReadOnly(ro);
    }

    public String getCatalog() throws SQLException {
        return this.realConnection.getCatalog();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.realConnection.setCatalog(catalog);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.realConnection.getMetaData();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.realConnection.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.realConnection.setSavepoint(name);
    }

    public void releaseSavepoint(Savepoint sp) throws SQLException {
        this.realConnection.releaseSavepoint(sp);
    }

    public Map getTypeMap() throws SQLException {
        return this.realConnection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.realConnection.setTypeMap(map);
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.realConnection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.realConnection.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Statement createStatement() throws SQLException {
        return this.realConnection.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.realConnection.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.realConnection.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int autogeneratedKeys) throws SQLException {
        return this.realConnection.prepareStatement(sql, autogeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.realConnection.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.realConnection.prepareStatement(sql, columnNames);
    }
}

