/*
 * Copyright 2008 Hidekatsu Izuno
 * Distributed under the terms of either:
 * - the common development and distribution license (CDDL), v1.0; or
 * - the GNU Lesser General Public License, v2.1 or later
 */
package winstone.classLoader;

import java.net.URL;
import java.net.URLStreamHandlerFactory;

import winstone.Logger;
import winstone.WinstoneResourceBundle;

public class WebappDevLoader extends WebappClassLoader {
    private static final WinstoneResourceBundle CL_RESOURCES = new WinstoneResourceBundle("winstone.classLoader.LocalStrings");
    
    private static final int SYSTEM_CL = 0;
    private static final int THIS_CL = 1;
    private static final int PARENT_CL = 2;
    
    
    private static final String[] KEYS = {
    	"WebappClassLoader.LoadedBySystemCL",
    	"WebappClassLoader.LoadedByThisCL",
    	"WebappClassLoader.LoadedByParentCL"
    };

    public WebappDevLoader(URL[] urls) {
        super(DevLoaderUtil.appendClassPathes(urls));
    }

    public WebappDevLoader(URL[] urls, ClassLoader parent) {
        super(DevLoaderUtil.appendClassPathes(urls), parent);
    }
    
    public WebappDevLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(DevLoaderUtil.appendClassPathes(urls), parent, factory);
    }
    
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = findLoadedClass(name);
        
        if (c == null) {
	        int[] order = null;
	        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("winstone")) {
	        	order = new int[] {SYSTEM_CL, THIS_CL, PARENT_CL};
	        } else {
	        	order = new int[] {THIS_CL, PARENT_CL, SYSTEM_CL};
	        }
	        
	        for (int i = 0; i < order.length; i++) {
	        	try {
	        		if (order[i] == SYSTEM_CL) {
	        			c = system.loadClass(name);
	        		} else if (order[i] == THIS_CL) {
	        			c = findClass(name);
	        		} else if (order[i] == PARENT_CL){
	        			ClassLoader parent = getParent();
	        			c = (parent != null) ? parent.loadClass(name) : null;
	        		}
	        	} catch (ClassNotFoundException e) {
	        		if (i == order.length-1) {
	        			throw e;
	        		} else {
	        			c = null;
	        		}
	        	}
	    		
	    		if (c != null) {
	                Logger.log(Logger.MAX, CL_RESOURCES, KEYS[i], name);
	                break;
	    		}
	        }
	        
	        if (c == null) throw new ClassNotFoundException(name);
        }
        
        if (resolve && (c != null)) {
            resolveClass(c);
        }
        return c;
    }
}
