#ifndef JTK_H
#define JTK_H

#ifndef NULL
#define NULL 0
#endif /* NULL */

/* JtkWChar */
typedef unsigned long JtkWChar;

/* JtkColor */
typedef unsigned long JtkColor;
JtkColor jtkRGB(unsigned char r, unsigned char g, unsigned char b);
JtkColor jtkRGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a);
unsigned char jtkGetRValue(JtkColor color);
unsigned char jtkGetGValue(JtkColor color);
unsigned char jtkGetBValue(JtkColor color);
unsigned char jtkGetAValue(JtkColor color);

/* Mouse Button */
#define JTK_MOUSE_BUTTON_LEFT		1
#define JTK_MOUSE_BUTTON_MIDDLE		2
#define JTK_MOUSE_BUTTON_RIGHT		3
#define JTK_MOUSE_BUTTON_WHEELUP	4
#define JTK_MOUSE_BUTTON_WHEELDOWN	5

/* Jtk Virtual Keycode (JVK) */
typedef unsigned int JtkKeySym;
#include "jvk.h"

/* Modifier Key */
typedef unsigned int JtkKeyMask;
#define JTK_KEYMASK_SHIFT	(1<<0)
#define JTK_KEYMASK_LOCK	(1<<1)
#define JTK_KEYMASK_CONTROL	(1<<2)
#define JTK_KEYMASK_MOD1	(1<<3)
#define JTK_KEYMASK_MOD2	(1<<4)
#define JTK_KEYMASK_MOD3	(1<<5)
#define JTK_KEYMASK_MOD4	(1<<6)
#define JTK_KEYMASK_MOD5	(1<<7)
#define JTK_KEYMASK_BUTTON1	(1<<8)
#define JTK_KEYMASK_BUTTON2	(1<<9)
#define JTK_KEYMASK_BUTTON3	(1<<10)
#define JTK_KEYMASK_BUTTON4	(1<<11)
#define JTK_KEYMASK_BUTTON5	(1<<12)

/* JtkBool */
typedef enum JtkBool JtkBool;
enum JtkBool
{
	JTK_FALSE = 0,
	JTK_TRUE = 1,
};

/* JtkError */
typedef enum JtkError JtkError;
enum JtkError
{
	JTK_NOERROR = 0,
	JTK_ERROR = 1,
};

/* JtkLineStyle */
typedef enum JtkLineStyle JtkLineStyle;
enum JtkLineStyle
{
	JTK_LINESTYLE_SOLID,
	JTK_LINESTYLE_ONOFFDASH,
	JTK_LINESTYLE_DOUBLEDASH,
};

/* JtkCapStyle */
typedef enum JtkCapStyle JtkCapStyle;
enum JtkCapStyle
{
	JTK_CAPSTYLE_BUTT,
	JTK_CAPSTYLE_ROUND,
	JTK_CAPSTYLE_PROJECTING,
};

/* JtkJoinStyle */
typedef enum JtkJoinStyle JtkJoinStyle;
enum JtkJoinStyle
{
	JTK_JOINSTYLE_MITER,
	JTK_JOINSTYLE_ROUND,
	JTK_JOINSTYLE_BEVEL,
};

/* JtkArcMode */
typedef enum JtkArcMode JtkArcMode;
enum JtkArcMode
{
	JTK_ARCMODE_PIESLICE,
	JTK_ARCMODE_CHORD,
};

/* JTKGCMode */
typedef enum JtkGCMode JtkGCMode;
enum JtkGCMode
{
	JTK_GCMODE_SCREEN,
	JTK_GCMODE_BUFFER,
	JTK_GCMODE_DOUBLE,
};

/* JtkGCType */
typedef enum JtkGCType JtkGCType;
enum JtkGCType
{
	JTK_GCTYPE_NORMAL,
	JTK_GCTYPE_SURFACE,
	JTK_GCTYPE_GL,
};

/* JtkPoint */
typedef struct JtkPoint JtkPoint;
struct JtkPoint
{
	int px;
	int py;
};

JtkPoint* jtkSetPoint(JtkPoint *p, int px, int py);

/* JtkSize */
typedef struct JtkSize JtkSize;
struct JtkSize
{
	int width;
	int height;
};

JtkSize* jtkSetSize(JtkSize *s, int width, int height);

/* JtkRect */
typedef struct JtkRect JtkRect;
struct JtkRect
{
	int x;
	int y;
	int width;
	int height;
};

JtkRect* jtkSetRect(JtkRect *r, int x, int y, int width, int height);

/* Initialization and Finalization */
JtkError jtkInit();
void jtkFinal();

/* system */
void* j_malloc(unsigned int size);
void j_free(void *p);
void j_zero(void *data, unsigned int size);
unsigned int j_strlen(const char *text);
unsigned int j_wcslen(const JtkWChar *text);
void j_strcpy(char *dest, const char *src);

/* image */
typedef struct JtkPixel JtkPixel;
struct JtkPixel
{
	unsigned char r;
	unsigned char g;
	unsigned char b;
	unsigned char a;
};
void jtkMakePixel(JtkPixel *pixel,
	unsigned char r,
	unsigned char g,
	unsigned char b,
	unsigned char a);
unsigned char jtkGetPixelRValue(JtkPixel *pixel);
unsigned char jtkGetPixelGValue(JtkPixel *pixel);
unsigned char jtkGetPixelBValue(JtkPixel *pixel);
unsigned char jtkGetPixelAValue(JtkPixel *pixel);

typedef struct JtkImage JtkImage;
struct JtkImage
{
	int width;
	int height;
	JtkPixel src_colorkey;
	JtkBool src_colorkey_enable;
	JtkPixel dest_colorkey;
	JtkBool dest_colorkey_enable;
	JtkPixel *pixel;
};

JtkImage* jtkCreateImage(unsigned int width, unsigned int height);
void jtkDestroyImage(JtkImage *image);
void jtkPutImagePixel(JtkImage *image, JtkPixel *pixel, int px, int py);
void jtkGetImagePixel(JtkImage *image, JtkPixel *pixel, int px, int py);
void jtkSetImageSrcColorkey(JtkImage *image, JtkPixel *pixel);
void jtkGetImageSrcColorkey(JtkImage *image, JtkPixel *pixel);
void jtkSetImageSrcColorkeyEnable(JtkImage *image, JtkBool src_colorkey_enable);
JtkBool jtkGetImageSrcColorkeyEnable(JtkImage *image);
void jtkSetImageDestColorkey(JtkImage *image, JtkPixel *pixel);
void jtkGetImageDestColorkey(JtkImage *image, JtkPixel *pixel);
void jtkSetImageDestColorkeyEnable(JtkImage *image, JtkBool dest_colorkey_enable);
JtkBool jtkGetImageDestColorkeyEnable(JtkImage *image);
int jtkGetImageWidth(JtkImage *image);
int jtkGetImageHeight(JtkImage *image);
void jtkBltImage(JtkImage *src, JtkImage *dest,
	int src_x, int src_y, int width, int height,
	int dest_x, int dest_y);
void jtkSetImageAlpha(JtkImage *image, unsigned char alpha);

/* JTK Handle */
typedef struct JtkGC JtkGC;
struct JtkGC;

typedef struct JtkWidget JtkWidget;
struct JtkWidget;

typedef union JtkEvent JtkEvent;
union JtkEvent;

typedef struct JtkFont JtkFont;
struct JtkFont;

/* JtkWidget */
typedef unsigned long JtkEventType;
enum JtkEventType{
	JTK_EVENT_KEYDOWN,
	JTK_EVENT_KEYUP,
	JTK_EVENT_BUTTONDOWN,
	JTK_EVENT_BUTTONUP,
	JTK_EVENT_MOTION,
	JTK_EVENT_ENTER,
	JTK_EVENT_LEAVE,
	JTK_EVENT_FOCUSIN,
	JTK_EVENT_FOCUSOUT,
	JTK_EVENT_CREATE,
	JTK_EVENT_DESTROY,
	JTK_EVENT_MAP,
	JTK_EVENT_UNMAP,
	JTK_EVENT_MOVE,
	JTK_EVENT_RESIZE,
	JTK_EVENT_EXPOSE,
	JTK_EVENT_CLOSE,
	JTK_EVENT_CLICK,
};

union JtkEvent
{
	JtkEventType type;
	
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}any;
	
	// type = JTK_EVENT_KEYDOWN
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keydown;
	
	// type = JTK_EVENT_KEYUP
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}keyup;
	
	// type = JTK_EVENT_BUTTONDOWN
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttondown;
	
	// type = JTK_EVENT_BUTTONUP
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		int button;
		JtkKeyMask keymask;
		JtkKeySym keysym;
	}buttonup;
	
	// type = JTK_EVENT_MOTION
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}motion;
	
	// type = JTK_EVENT_ENTER
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}enter;
	
	// type = JTK_EVENT_LEAVE
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
		int screen_px;
		int screen_py;
		JtkKeyMask keymask;
	}leave;
	
	// type = JTK_EVENT_FOCUSIN
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}focusin;
	
	// type = JTK_EVENT_FOCUSOUT
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}focusout;
	
	// type = JTK_EVENT_CREATE
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}create;
	
	// type = JTK_EVENT_DESTROY
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}destroy;
	
	// type = JTK_EVENT_MAP
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}map;
	
	// type = JTK_EVENT_UNMAP
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}unmap;
	
	// type = JTK_EVENT_MOVE
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int px;
		int py;
	}move;
	
	// type = JTK_EVENT_RESIZE
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int width;
		int height;
	}resize;
	
	// type = JTK_EVENT_EXPOSE
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int x;
		int y;
		int width;
		int height;
		int count;
	}expose;
	
	// type = JTK_EVENT_CLOSE
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
	}close;
	
	// type = JTK_EVENT_CLICK
	struct{
		JtkEventType type;
		JtkWidget *widget;
		void *data;
		int button;
	}click;
};

JtkWidget* jtkCreateWindow(JtkWidget *parent);
JtkWidget* jtkCreateButton(JtkWidget *parent);
JtkWidget* jtkCreateLogbox(JtkWidget *parent);
JtkWidget* jtkCreateDrawingArea(JtkWidget *parent);
JtkWidget* jtkCreateRemovableBox(JtkWidget *parent);
JtkWidget* jtkCreateTextEntry(JtkWidget *parent);

void jtkSetWidgetCallback(JtkWidget *widget, void *data,
								void (*func)(JtkEvent *event));
JtkWidget* jtkGetFocus();

JtkGC* jtkCreateGC(JtkWidget *widget, JtkGCMode mode, JtkGCType type);
void jtkDestroyWidget(JtkWidget *widget);
void jtkMapWidget(JtkWidget *widget);
void jtkUnmapWidget(JtkWidget *widget);
void jtkClearWidget(JtkWidget *widget,
	int px, int py, int width, int height, JtkBool exposures);
void jtkRaiseWidget(JtkWidget *widget);
void jtkLowerWidget(JtkWidget *widget);
void jtkSetWidgetPos(JtkWidget *widget, int px, int py);
void jtkSetWidgetSize(JtkWidget *widget, int width, int height);
void jtkGetWidgetPos(JtkWidget *widget, JtkPoint *point);
void jtkGetWidgetSize(JtkWidget *widget, JtkSize *size);
void jtkSetWidgetColor(JtkWidget *widget, JtkColor color);
void jtkSetWidgetBorderSize(JtkWidget *widget, int size);
void jtkSetWidgetBorderColor(JtkWidget *widget, JtkColor color);
void jtkSetWidgetTextColor(JtkWidget *widget, JtkColor color);
void jtkSetWidgetTextLines(JtkWidget *widget, int lines);
void jtkSetWidgetText(JtkWidget *widget, char *text);
char* jtkGetWidgetText(JtkWidget *widget);
void jtkClearWidgetText(JtkWidget *widget);
void jtkSetFocus(JtkWidget *widget);

/* event */
void jtkMain();
void jtkMainQuit();
void jtkSetIdleFunc(void (*idle)(void *data), void *data);
void jtkSetKeyboardFunc(void (*callback)(JtkEvent *event, void *data), void *data);
void jtkSleep(unsigned int ms);

/* screen */
int jtkGetScreenWidth();
int jtkGetScreenHeight();
int jtkGetScreenBPP();	/* BPP = Bit per pixel */

/* graphics */
void jtkDestroyGC(JtkGC *gc);
void jtkBitBlt(JtkGC *src, JtkGC *dest,
	int src_x, int src_y,
	int width, int height,
	int dest_x, int dest_y);
void jtkSetColor(JtkGC *gc, JtkColor color);
void jtkSetBackColor(JtkGC *gc, JtkColor color);
void jtkSetLineSize(JtkGC *gc, unsigned int line_size);
void jtkSetLineStyle(JtkGC *gc, JtkLineStyle line_style);
void jtkSetLineCapStyle(JtkGC *gc, JtkCapStyle cap_style);
void jtkSetLineJoinStyle(JtkGC *gc, JtkJoinStyle join_style);
void jtkSetDashes(JtkGC *gc, int offset, char dash_list[], int n);
void jtkDrawLine(JtkGC *gc, int x1, int y1, int x2, int y2);
void jtkDrawPoint(JtkGC *gc, int x, int y);
void jtkDrawRect(JtkGC *gc, int x, int y, int width, int height);
void jtkFillRect(JtkGC *gc, int x, int y, int width, int height);
void jtkDrawArc(JtkGC *gc, int x, int y, int width, int height,
					int angle1, int angle2);
void jtkFillArc(JtkGC *gc, int x, int y, int width, int height,
					int angle1, int angle2);
void jtkSetArcMode(JtkGC *gc, JtkArcMode mode);
void jtkDrawText(JtkGC *gc, int px, int py, char *text, int len);
void jtkDrawTextWC(JtkGC *gc, int px, int py, JtkWChar *text, int len);
void jtkGetTextSize(JtkGC *gc, char *text, int len, JtkSize *size);
void jtkGetTextSizeWC(JtkGC *gc, JtkWChar *text, int len, JtkSize *size);

JtkError jtkLockSurface(JtkGC *gc);
void jtkUnlockSurface(JtkGC *gc);
void* jtkGetSurfaceAddr(JtkGC *gc);
int jtkGetSurfaceBytesPerLine(JtkGC *gc);
int jtkGetSurfaceBytesPerPixel(JtkGC *gc);
void jtkReadSurfacePixel(JtkGC *gc, JtkPixel *pixel, int px, int py);
void jtkWriteSurfacePixel(JtkGC *gc, JtkPixel *pixel, int px, int py);
void jtkReadSurfaceImage(JtkGC *gc, JtkImage *image,
	int src_x, int src_y, int width, int height,
	int dest_x, int dest_y);
void jtkWriteSurfaceImage(JtkGC *gc, JtkImage *image,
	int src_x, int src_y, int width, int height,
	int dest_x, int dest_y);

void jtkCurrent(JtkGC *gc);
void jtkFlip(JtkGC *gc);
void jtkResizeGC(JtkGC *gc, int width, int height);
int jtkGetGCWidth(JtkGC *gc);
int jtkGetGCHeight(JtkGC *gc);

void jtkPutImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y);
void jtkGetImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y);

/* ImageFile */
JtkImage* jtkLoadImageFile(char *name, char *type);
void jtkSaveImageFile(JtkImage *image, char *name, char *type);

/* Multi-Thread */
typedef struct JtkThread JtkThread;
struct JtkThread;
typedef struct JtkSemaphore JtkSemaphore;
struct JtkSemaphore;
typedef struct JtkMutex JtkMutex;
struct JtkMutex;

JtkThread* jtkCreateThread(void (*func)(void *data), void *data);
void jtkKillThread(JtkThread *thread);
void jtkWaitThread(JtkThread *thread);
void jtkExitThread();
JtkSemaphore* jtkCreateSemaphore(unsigned int value);
JtkError jtkPostSemaphore(JtkSemaphore *sem);
JtkError jtkWaitSemaphore(JtkSemaphore *sem);
JtkError jtkDestroySemaphore(JtkSemaphore *sem);
JtkMutex* jtkCreateMutex();
JtkError jtkLockMutex(JtkMutex *mutex);
JtkError jtkUnlockMutex(JtkMutex *mutex);
JtkError jtkDestroyMutex(JtkMutex *mutex);

/* Timer */
typedef struct JtkTimer JtkTimer;
struct JtkTimer;

JtkTimer* jtkCreateTimer(unsigned int ms, void (*callback)(void *data), void *data);
void jtkDestroyTimer(JtkTimer *timer);

/* Joystick */
typedef enum JtkJoystickEventType JtkJoystickEventType;
enum JtkJoystickEventType
{
	JTK_JOYSTICK_EVENT_BUTTON,
	JTK_JOYSTICK_EVENT_AXIS,
};

typedef struct JtkJoystick JtkJoystick;
struct JtkJoystick;

typedef struct JtkJoystickEvent JtkJoystickEvent;
struct JtkJoystickEvent
{
	JtkJoystickEventType type;
	
	struct{
		JtkJoystickEventType type;
		JtkJoystick *joystick;
		void *data;
	}any;
	
	struct{
		JtkJoystickEventType type;
		JtkJoystick *joystick;
		void *data;
		int number;
		int state;
	}button;
	
	struct{
		JtkJoystickEventType type;
		JtkJoystick *joystick;
		void *data;
		int number;
		short value;
	}axis;
};

JtkJoystick* jtkOpenJoystick(int id);
void jtkCloseJoystick(JtkJoystick *joystick);
void jtkSetJoystickCallback(JtkJoystick *joystick, void *data,
								void (*callback)(JtkJoystickEvent *event));
void jtkUpdateJoystick(JtkJoystick *joystick);
char* jtkGetJoystickName(JtkJoystick *joystick);
int jtkGetJoystickAxisNum(JtkJoystick *joystick);
int jtkGetJoystickButtonNum(JtkJoystick *joystick);
short jtkGetJoystickAxis(JtkJoystick *joystick, int axis);
int jtkGetJoystickButton(JtkJoystick *joystick, int button);

#endif /* JTK_H */
