#include "x11-core.h"

/* JTK Pixel API */
void jtkMakePixel(JtkPixel *pixel,
	unsigned char r,
	unsigned char g,
	unsigned char b,
	unsigned char a)
{
	pixel->r = r;
	pixel->g = g;
	pixel->b = b;
	pixel->a = a;
}

unsigned char jtkGetPixelRValue(JtkPixel *pixel)
{
	return pixel->r;
}

unsigned char jtkGetPixelGValue(JtkPixel *pixel)
{
	return pixel->g;
}

unsigned char jtkGetPixelBValue(JtkPixel *pixel)
{
	return pixel->b;
}

unsigned char jtkGetPixelAValue(JtkPixel *pixel)
{
	return pixel->a;
}

/* JTK Image API */
JtkImage* jtkCreateImage(unsigned int width, unsigned int height)
{
	JtkImage *image;
	
	if(width == 0 || height == 0)
		return NULL;
	
	image = j_malloc(sizeof(JtkImage));
	if(image == NULL)
		return NULL;
	j_zero(image, sizeof(JtkImage));
	image->width = width;
	image->height = height;
	
	image->pixel = j_malloc(sizeof(JtkPixel) * width * height);
	if(image->pixel == NULL){
		j_free(image);
		return NULL;
	}
	j_zero(image->pixel, sizeof(JtkPixel) * width * height);
		
	return image;
}

void jtkDestroyImage(JtkImage *image)
{
	if(image->pixel != NULL)
		j_free(image->pixel);
	j_free(image);
}

void jtkPutImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y)
{
	JtkGC *surface;
	
	surface = jwkCreateGC(gc->jw, JTK_GCMODE_BUFFER, JTK_GCTYPE_SURFACE);
	
	jtkResizeGC(surface, image->width, image->height);
	jtkLockSurface(surface);
	jtkWriteSurfaceImage(surface, image, 0, 0, image->width, image->height, 0, 0);
	jtkUnlockSurface(surface);
	
	jtkBitBlt(surface, gc, src_x, src_y, width, height, dest_x, dest_y);
	
	jtkDestroyGC(surface);
}

void jtkGetImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y)
{
	JtkGC *surface;
	
	surface = jwkCreateGC(gc->jw, JTK_GCMODE_BUFFER, JTK_GCTYPE_SURFACE);
	
	jtkResizeGC(surface, jtkGetGCWidth(gc), jtkGetGCHeight(gc));
	jtkBitBlt(gc, surface,
		0, 0, jtkGetGCWidth(gc), jtkGetGCHeight(gc), 0, 0);

	jtkLockSurface(surface);
	jtkReadSurfaceImage(surface, image, src_x, src_y, width, height, dest_x, dest_y);
	jtkUnlockSurface(surface);
		
	jtkDestroyGC(surface);
}

void jtkPutImagePixel(JtkImage *image, JtkPixel *pixel, int px, int py)
{
	JtkPixel *p;
	
	if((px < 0) || (py < 0))
		return;
	if((px >= image->width) || (py >= image->height))
		return;
	
	p = image->pixel + image->width *py + px;
	p->r = pixel->r;
	p->g = pixel->g;
	p->b = pixel->b;
	p->a = pixel->a;
}

void jtkGetImagePixel(JtkImage *image, JtkPixel *pixel, int px, int py)
{
	JtkPixel *p;
	
	if((px < 0) || (py < 0))
		return;
	if((px >= image->width) || (py >= image->height))
		return;
	
	p = image->pixel + image->width * py + px;
	pixel->r = p->r;
	pixel->g = p->g;
	pixel->b = p->b;
	pixel->a = p->a;
}

void jtkSetImageSrcColorkey(JtkImage *image, JtkPixel *pixel)
{
	image->src_colorkey.r = pixel->r;
	image->src_colorkey.g = pixel->g;
	image->src_colorkey.b = pixel->b;
	image->src_colorkey.a = pixel->a;
}

void jtkGetImageSrcColorkey(JtkImage *image, JtkPixel *pixel)
{
	pixel->r = image->src_colorkey.r;
	pixel->g = image->src_colorkey.g;
	pixel->b = image->src_colorkey.b;
	pixel->a = image->src_colorkey.a;
}

void jtkSetImageSrcColorkeyEnable(JtkImage *image, JtkBool src_colorkey_enable)
{
	image->src_colorkey_enable = src_colorkey_enable;
}

JtkBool jtkGetImageSrcColorkeyEnable(JtkImage *image)
{
	return image->src_colorkey_enable;
}

void jtkSetImageDestColorkey(JtkImage *image, JtkPixel *pixel)
{
	image->dest_colorkey.r = pixel->r;
	image->dest_colorkey.g = pixel->g;
	image->dest_colorkey.b = pixel->b;
	image->dest_colorkey.a = pixel->a;
}

void jtkGetImageDestColorkey(JtkImage *image, JtkPixel *pixel)
{
	pixel->r = image->dest_colorkey.r;
	pixel->g = image->dest_colorkey.g;
	pixel->b = image->dest_colorkey.b;
	pixel->a = image->dest_colorkey.a;
}

void jtkSetImageDestColorkeyEnable(JtkImage *image, JtkBool dest_colorkey_enable)
{
	image->dest_colorkey_enable = dest_colorkey_enable;
}

JtkBool jtkGetImageDestColorkeyEnable(JtkImage *image)
{
	return image->dest_colorkey_enable;
}

int jtkGetImageWidth(JtkImage *image)
{
	return image->width;
}

int jtkGetImageHeight(JtkImage *image)
{
	return image->height;
}

void jtkBltImage(JtkImage *src, JtkImage *dest,
	int src_x, int src_y, int width, int height,
	int dest_x, int dest_y)
{
	int x, y;
	int psx, psy;
	int pdx, pdy;
	float src_alpha;
	unsigned long num;
	JtkPixel s_pixel;
	JtkPixel d_pixel;
	JtkPixel pixel;
	
	for(x=0; x<width; x++){
		for(y=0; y<height; y++){
			psx = src_x + x;
			psy = src_y + y;
			if((psx < 0) || (psy < 0) ||
				(psx >= src->width) || (psy >= src->height))
				continue;
			jtkGetImagePixel(src, &s_pixel, psx, psy);
			
			pdx = dest_x + x;
			pdy = dest_y + y;
			if((pdx < 0) || (pdy < 0) ||
				(pdx >= dest->width) || (pdy >= dest->height))
				continue;
			jtkGetImagePixel(dest, &d_pixel, pdx, pdy);
			
			if(src->src_colorkey_enable == JTK_TRUE){
				if((s_pixel.r == src->src_colorkey.r) &&
					(s_pixel.g == src->src_colorkey.g) &&
					(s_pixel.b == src->src_colorkey.b)){
					continue;
				}
			}
			if(src->dest_colorkey_enable == JTK_TRUE){
				if((d_pixel.r != src->dest_colorkey.r) ||
					(d_pixel.g != src->dest_colorkey.g) ||
					(d_pixel.b != src->dest_colorkey.b)){
					continue;
				}
			}
			
			src_alpha = (float)s_pixel.a / (float)255.0;
			num = d_pixel.r * src_alpha + s_pixel.r * (1.0 - src_alpha);
			pixel.r = num;
			num = d_pixel.g * src_alpha + s_pixel.g * (1.0 - src_alpha);
			pixel.g = num;
			num = d_pixel.b * src_alpha + s_pixel.b * (1.0 - src_alpha);
			pixel.b = num;
			num = d_pixel.a * src_alpha + s_pixel.a * (1.0 - src_alpha);
			pixel.a = num;
			
			jtkPutImagePixel(dest, &pixel, pdx, pdy);
		}
	}
}

void jtkSetImageAlpha(JtkImage *image, unsigned char alpha)
{
	int x, y;
	JtkPixel pixel;
	
	for(x=0; x<image->width; x++){
		for(y=0; y<image->height; y++){
			jtkGetImagePixel(image, &pixel, x, y);
			pixel.a = alpha;
			jtkPutImagePixel(image, &pixel, x, y);
		}
	}
}

