#include "jtk.h"

/* Button */
typedef struct Button Button;
struct Button
{
	JtkWidget *widget;
	JtkWindow *jw;
	JtkGC *gc;
	char *text;
};

static void callback_button(JtkWindowEvent *event)
{
	JtkWidgetEvent jwe;
	JtkWidget *widget = event->any.widget;
	Button *button = widget->widget;

	switch(event->type){
	case JTK_WINDOW_EVENT_EXPOSE:
		{
			JtkSize sb, st;
			
			if(widget->callback != NULL){
				jwe.type = JTK_WIDGET_EVENT_EXPOSE;
				jwe.expose.widget = widget;
				jwe.expose.data = widget->data;
				jwe.expose.x = event->expose.x;
				jwe.expose.y = event->expose.y;
				jwe.expose.width = event->expose.width;
				jwe.expose.height = event->expose.height;
				jwe.expose.count = event->expose.count;
				widget->callback(&jwe);
			}
			if(button->text != NULL){
				jtkGetWindowSize(button->jw, &sb);
				jtkGetTextSize(button->gc, button->text, j_strlen(button->text), &st);
				jtkDrawText(button->gc,
							(sb.width - st.width)/2, 
							(sb.height - st.height)/2,
							button->text, j_strlen(button->text));
			}
		}
		break;
	case JTK_WINDOW_EVENT_BUTTONDOWN:
		{
			if(widget->callback != NULL){
				jwe.type = JTK_WIDGET_EVENT_BUTTONCLICK;
				jwe.buttonclick.widget = widget;
				jwe.buttonclick.data = widget->data;
				widget->callback(&jwe);
			}
		}
		break;
	case JTK_WINDOW_EVENT_ENTER:
		{
			if(widget->callback != NULL){
				jwe.type = JTK_WIDGET_EVENT_ENTER;
				jwe.enter.widget = widget;
				jwe.enter.data = widget->data;
				jwe.enter.px = event->enter.px;
				jwe.enter.py = event->enter.py;
				jwe.enter.screen_px = event->enter.screen_px;
				jwe.enter.screen_py = event->enter.screen_py;
				jwe.enter.keymask = event->enter.keymask;
				widget->callback(&jwe);
			}
		}
		break;
	case JTK_WINDOW_EVENT_LEAVE:
		{
			if(widget->callback != NULL){
				jwe.type = JTK_WIDGET_EVENT_LEAVE;
				jwe.leave.widget = widget;
				jwe.leave.data = widget->data;
				jwe.leave.px = event->leave.px;
				jwe.leave.py = event->leave.py;
				jwe.leave.screen_px = event->leave.screen_px;
				jwe.leave.screen_py = event->leave.screen_py;
				jwe.leave.keymask = event->leave.keymask;
				widget->callback(&jwe);
			}
		}
		break;
	default:
		break;
	}
}

static void destroy_button(JtkWidget *widget)
{
	Button *button = widget->widget;

	jtkDestroyGC(button->gc);
	jtkDestroyWindow(button->jw);
	if(button->text != NULL)
		j_free(button->text);
	j_free(button);
}

static void map_button(JtkWidget *widget)
{
	Button *button = widget->widget;
	
	jtkMapWindow(button->jw);
}

static void unmap_button(JtkWidget *widget)
{
	Button *button = widget->widget;

	jtkUnmapWindow(button->jw);
}

static void set_button_pos(JtkWidget *widget, int px, int py)
{
	Button *button = widget->widget;

	jtkSetWindowPos(button->jw, px, py);
}

static void set_button_size(JtkWidget *widget, int width, int height)
{
	Button *button = widget->widget;

	jtkSetWindowSize(button->jw, width, height);
}

static void set_button_color(JtkWidget *widget, JtkColor color)
{
	Button *button = widget->widget;
	
	jtkSetWindowColor(button->jw, color);
}

static void set_button_border_size(JtkWidget *widget, int size)
{
	Button *button = widget->widget;
	
	jtkSetWindowBorderSize(button->jw, size);
}

static void set_button_border_color(JtkWidget *widget, JtkColor color)
{
	Button *button = widget->widget;
	
	jtkSetWindowBorderColor(button->jw, color);
}

static void set_button_text_color(JtkWidget *widget, JtkColor color)
{
	Button *button = widget->widget;
	
	jtkSetColor(button->gc, color);
}

/* set_button_text_lines */

static void set_button_text(JtkWidget *widget, char *text)
{
	Button *button = widget->widget;

	if(button->text != NULL){
		j_free(button->text);
		button->text = NULL;
	}
	
	if(text == NULL){
		jtkClearWindow(button->jw, 0, 0, 0, 0, JTK_TRUE);
		return;
	}
	
	button->text = j_malloc(j_strlen(text) + 1);
	if(button->text == NULL)
		return;
	j_zero(button->text, j_strlen(text) + 1);
	j_strcpy(button->text, text);
	jtkClearWindow(button->jw, 0, 0, 0, 0, JTK_TRUE);
}

static void clear_button_text(JtkWidget *widget)
{
	set_button_text(widget, NULL);
}

static JtkWidgetFunc button_func =
{
	NULL,
	NULL,
	destroy_button,
	map_button,
	unmap_button,
	NULL,
	NULL,
	set_button_pos,
	set_button_size,
	set_button_color,
	set_button_border_size,
	set_button_border_color,
	set_button_text_color,
	NULL,
	set_button_text,
	clear_button_text,
};

JtkWidget* jtkCreateButton(JtkWidget *parent)
{
	JtkWidget *widget;
	Button *button;
	
	widget = j_malloc(sizeof(JtkWidget));
	if(widget == NULL)
		return NULL;
	
	button = j_malloc(sizeof(Button));
	if(button == NULL){
		j_free(widget);
		return NULL;
	}
	
	j_zero(widget, sizeof(JtkWidget));
	j_zero(button, sizeof(Button));
	
	button->jw = jtkCreateSimpleWindow(jtkGetContainer(parent));
	button->gc = jtkCreateWindowGC(button->jw);
	
	widget->widget = button;
	widget->func = &button_func;
	
	jtkSetWindowEventMask(button->jw, JTK_WINDOW_EVENTMASK_EXPOSE |
												JTK_WINDOW_EVENTMASK_BUTTONDOWN |
												JTK_WINDOW_EVENTMASK_ENTER |
												JTK_WINDOW_EVENTMASK_LEAVE);
	jtkSetWidget(button->jw, callback_button, widget);
	jtkSetWindowColor(button->jw, jtkRGB(192,192,192));
	jtkSetWindowBorderSize(button->jw, 1);
	jtkSetWindowBorderColor(button->jw, jtkRGB(128,128,128));
	
	return widget;
}
