/*
	JTK Window Widget
*/

#include "jtk.h"

typedef struct Window Window;
struct Window
{
	JtkWindow *jw;
};

static void window_callback(JtkWindowEvent *event)
{
	JtkWidget *widget = event->any.widget;
	JtkWidgetEvent jwe;
	
	switch(event->type){
	case JTK_WINDOW_EVENT_DESTROY:
		jwe.type = JTK_WIDGET_EVENT_DESTROY;
		jwe.destroy.widget = widget;
		jwe.destroy.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	case JTK_WINDOW_EVENT_MAP:
		jwe.type = JTK_WIDGET_EVENT_MAP;
		jwe.map.widget = widget;
		jwe.map.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	case JTK_WINDOW_EVENT_UNMAP:
		jwe.type = JTK_WIDGET_EVENT_UNMAP;
		jwe.unmap.widget = widget;
		jwe.unmap.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	case JTK_WINDOW_EVENT_MOVE:
		jwe.type = JTK_WIDGET_EVENT_MOVE;
		jwe.move.widget = widget;
		jwe.move.data = widget->data;
		jwe.move.px = event->move.px;
		jwe.move.py = event->move.py;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	case JTK_WINDOW_EVENT_RESIZE:
		jwe.type = JTK_WIDGET_EVENT_RESIZE;
		jwe.resize.widget = widget;
		jwe.resize.data = widget->data;
		jwe.resize.width = event->resize.width;
		jwe.resize.height = event->resize.height;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	case JTK_WINDOW_EVENT_EXPOSE:
		jwe.type = JTK_WIDGET_EVENT_EXPOSE;
		jwe.expose.widget = widget;
		jwe.expose.data = widget->data;
		jwe.expose.x = event->expose.x;
		jwe.expose.y = event->expose.y;
		jwe.expose.width = event->expose.width;
		jwe.expose.height = event->expose.height;
		jwe.expose.count = event->expose.count;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	case JTK_WINDOW_EVENT_CLOSE:
		jwe.type = JTK_WIDGET_EVENT_CLOSE;
		jwe.close.widget = widget;
		jwe.close.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&jwe);
		break;
	default:
		break;
	}
}

static JtkWindow* window_get_container(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	return window->jw;
}

static JtkWindow* window_get_drawing_area(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	return window->jw;
}

static void destroy_window(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	jtkDestroyWindow(window->jw);
	j_free(window);
}

static void map_window(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	jtkMapWindow(window->jw);
}

static void unmap_window(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	jtkUnmapWindow(window->jw);
}

static void raise_window(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	jtkRaiseWindow(window->jw);
}

static void lower_window(JtkWidget *widget)
{
	Window *window = widget->widget;
	
	jtkLowerWindow(window->jw);
}

static void set_window_pos(JtkWidget *widget, int px, int py)
{
	Window *window = widget->widget;
	
	jtkSetWindowPos(window->jw, px, py);
}

static void set_window_size(JtkWidget *widget, int width, int height)
{
	Window *window = widget->widget;
	
	jtkSetWindowSize(window->jw, width, height);
}

static void set_window_color(JtkWidget *widget, JtkColor color)
{
	Window *window = widget->widget;
	
	jtkSetWindowColor(window->jw, color);
}

static void set_window_border_size(JtkWidget *widget, int size)
{
	Window *window = widget->widget;
	
	jtkSetWindowBorderSize(window->jw, size);
}

static void set_window_border_color(JtkWidget *widget, JtkColor color)
{
	Window *window = widget->widget;
	
	jtkSetWindowBorderColor(window->jw, color);
}

/* set_window_text_color */

/* set_window_text_lines */

static void set_window_text(JtkWidget *widget, char *text)
{
	Window *window = widget->widget;
	
	jtkSetWindowText(window->jw, text);
}

static void clear_window_text(JtkWidget *widget)
{
	set_window_text(widget, NULL);
}

static JtkWidgetFunc window_func =
{
	window_get_container,
	window_get_drawing_area,
	destroy_window,
	map_window,
	unmap_window,
	raise_window,
	lower_window,
	set_window_pos,
	set_window_size,
	set_window_color,
	set_window_border_size,
	set_window_border_color,
	NULL,
	NULL,
	set_window_text,
	clear_window_text,
};

JtkWidget* jtkCreateWindow(JtkWidget *parent)
{
	JtkWidget *widget;
	Window *window;
	
	widget = j_malloc(sizeof(JtkWidget));
	if(widget == NULL)
		return NULL;
	
	window = j_malloc(sizeof(Window));
	if(window == NULL){
		j_free(widget);
		return NULL;
	}
	
	j_zero(widget, sizeof(JtkWidget));
	j_zero(window, sizeof(Window));
	
	widget->widget = window;
	widget->func = &window_func;
	widget->mapping = JTK_FALSE;
	
	window->jw = jtkCreateSimpleWindow(jtkGetContainer(parent));
	jtkSetWidget(window->jw, window_callback, widget);
	jtkSetWindowEventMask(window->jw,
		JTK_WINDOW_EVENTMASK_DESTROY |
		JTK_WINDOW_EVENTMASK_MAP |
		JTK_WINDOW_EVENTMASK_UNMAP |
		JTK_WINDOW_EVENTMASK_MOVE |
		JTK_WINDOW_EVENTMASK_RESIZE |
		JTK_WINDOW_EVENTMASK_EXPOSE);
	
	return widget;
}
