/*
	linux-event.c
*/
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "jtk.h"
#include "x11-core.h"

static int quit_flag = 0;
static void (*idle_func)(void *data) = NULL;
static void *idle_data = NULL;

static void _x11_event(XEvent *event)
{
	JtkWindow *jw;
	JtkWindowEvent jwe;
	
	if((jw = x11_wlist_find_window(event->xany.window)) == NULL)
		return;
		
	j_zero(&jwe, sizeof(JtkWindowEvent));
	jwe.any.window = jw;
	jwe.any.widget = jw->widget;
	switch(event->type){
	case KeyPress:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_KEYDOWN))
			break;
		jwe.type = JTK_WINDOW_EVENT_KEYDOWN;
		jwe.keydown.px = event->xkey.x;
		jwe.keydown.py = event->xkey.y;
		jwe.keydown.screen_px = event->xkey.x_root;
		jwe.keydown.screen_py = event->xkey.y_root;
		jwe.keydown.keymask = event->xkey.state;
		jwe.keydown.keysym = XKeycodeToKeysym(display, event->xkey.keycode, 0);
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case KeyRelease:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_KEYUP))
			break;
		jwe.type = JTK_WINDOW_EVENT_KEYUP;
		jwe.keyup.px = event->xkey.x;
		jwe.keyup.py = event->xkey.y;
		jwe.keyup.screen_px = event->xkey.x_root;
		jwe.keyup.screen_py = event->xkey.y_root;
		jwe.keyup.keymask = event->xkey.state;
		jwe.keyup.keysym = XKeycodeToKeysym(display, event->xkey.keycode, 0);
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case ButtonPress:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_BUTTONDOWN))
			break;
		jwe.type = JTK_WINDOW_EVENT_BUTTONDOWN;
		jwe.buttondown.px = event->xbutton.x;
		jwe.buttondown.py = event->xbutton.y;
		jwe.buttondown.screen_px = event->xbutton.x_root;
		jwe.buttondown.screen_py = event->xbutton.y_root;
		jwe.buttondown.keymask = event->xbutton.state;
		jwe.buttondown.button = event->xbutton.button;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case ButtonRelease:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_BUTTONUP))
			break;
		jwe.type = JTK_WINDOW_EVENT_BUTTONUP;
		jwe.buttonup.px = event->xbutton.x;
		jwe.buttonup.py = event->xbutton.y;
		jwe.buttonup.screen_px = event->xbutton.x_root;
		jwe.buttonup.screen_py = event->xbutton.y_root;
		jwe.buttonup.keymask = event->xbutton.state;
		jwe.buttonup.button = event->xbutton.button;
		if(jw->callback != NULL)
			jw->callback(&jwe);		
		break;
	case MotionNotify:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_MOTION))
			break;
		jwe.type = JTK_WINDOW_EVENT_MOTION;
		jwe.motion.px = event->xmotion.x;
		jwe.motion.py = event->xmotion.y;
		jwe.motion.screen_px = event->xmotion.x_root;
		jwe.motion.screen_py = event->xmotion.y_root;
		jwe.motion.keymask = event->xmotion.state;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case EnterNotify:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_ENTER))
			break;
		jwe.type = JTK_WINDOW_EVENT_ENTER;
		jwe.enter.px = event->xcrossing.x;
		jwe.enter.py = event->xcrossing.y;
		jwe.enter.screen_px = event->xcrossing.x_root;
		jwe.enter.screen_py = event->xcrossing.y_root;
		jwe.enter.keymask = event->xcrossing.state;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case LeaveNotify:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_LEAVE))
			break;
		jwe.type = JTK_WINDOW_EVENT_LEAVE;
		jwe.leave.px = event->xcrossing.x;
		jwe.leave.py = event->xcrossing.y;
		jwe.leave.screen_px = event->xcrossing.x_root;
		jwe.leave.screen_py = event->xcrossing.y_root;
		jwe.leave.keymask = event->xcrossing.state;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case FocusIn:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_FOCUSIN))
			break;
		jwe.type = JTK_WINDOW_EVENT_FOCUSIN;
		if(jw->callback != NULL)
			jw->callback(&jwe);
			break;
	case FocusOut:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_FOCUSOUT))
			break;
		jwe.type = JTK_WINDOW_EVENT_FOCUSOUT;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case MapNotify:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_MAP))
			break;
		jwe.type = JTK_WINDOW_EVENT_MAP;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case UnmapNotify:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_UNMAP))
			break;
		jwe.type = JTK_WINDOW_EVENT_UNMAP;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case ConfigureNotify:
		if(jw->event_mask & JTK_WINDOW_EVENTMASK_MOVE){
			jwe.type = JTK_WINDOW_EVENT_MOVE;
			jwe.move.px = event->xconfigure.x;
			jwe.move.py = event->xconfigure.y;
			if(jw->callback != NULL)
				jw->callback(&jwe);
		}
		if(jw->event_mask & JTK_WINDOW_EVENTMASK_RESIZE){
			jwe.type = JTK_WINDOW_EVENT_RESIZE;
			jwe.resize.width = event->xconfigure.width;
			jwe.resize.height = event->xconfigure.height;
			if(jw->callback != NULL)
				jw->callback(&jwe);
		}
		break;
	case Expose:
		if(!(jw->event_mask & JTK_WINDOW_EVENTMASK_EXPOSE))
			break;
		jwe.type = JTK_WINDOW_EVENT_EXPOSE;
		jwe.expose.x = event->xexpose.x;
		jwe.expose.y = event->xexpose.y;
		jwe.expose.width = event->xexpose.width;
		jwe.expose.height = event->xexpose.height;
		jwe.expose.count = event->xexpose.count;
		if(jw->callback != NULL)
			jw->callback(&jwe);
		break;
	case ClientMessage:
		if(event->xclient.message_type == WM_PROTOCOLS){
			if(event->xclient.data.l[0] == WM_DELETE_WINDOW){
				jwe.type = JTK_WINDOW_EVENT_CLOSE;
				if(jw->callback != NULL)
					jw->callback(&jwe);
			}
		}
		break;
	default:
		break;
	}
}

/* Main event loop */
void jtkMain()
{
	XEvent event;
	
	quit_flag = 0;
	XFlush(display);
	while(!quit_flag){
		if(idle_func != NULL){
			if(XPending(display) > 0){
				XNextEvent(display, &event);
				_x11_event(&event);
			}else{
				idle_func(idle_data);
			}
		}else{
			XNextEvent(display, &event);
			_x11_event(&event);
		}
	}
}

void jtkMainQuit()
{
	quit_flag = 1;
}

void jtkSetIdleFunc(void (*idle)(void *data), void *data)
{
	idle_func = idle;
	idle_data = data;
}

void jtkSleep(unsigned int ms)
{
	usleep(ms * 1000);
}
