#include "jtk.h"

struct JtkTimer
{
	void (*callback)(void *data);
	void *data;
	unsigned int ms;
	JtkThread *thread;
};

static void timer_callback(void *data)
{
	JtkTimer *timer = data;
	
	while(1){
		jtkSleep(timer->ms);
		if(timer->callback != NULL)
			timer->callback(timer->data);
	}
}

JtkTimer* jtkCreateTimer(unsigned int ms, void (*callback)(void *data), void *data)
{
	JtkTimer *timer;
	
	timer = j_malloc(sizeof(JtkTimer));
	if(timer == NULL)
		return NULL;
	
	timer->callback = callback;
	timer->data = data;
	timer->ms = ms;
	
	if((timer->thread = jtkCreateThread(timer_callback, timer)) == NULL){
		j_free(timer);
		return NULL;
	}
	
	return NULL;
}

void jtkDestroyTimer(JtkTimer *timer)
{
	jtkKillThread(timer->thread);
	jtkWaitThread(timer->thread);
	j_free(timer);
}
