#include "x11-core.h"

Display *display = NULL;
Atom WM_PROTOCOLS;
Atom WM_DELETE_WINDOW;

static JtkWindow wlist;
static JtkWindow *wlist_head = &wlist;
static JtkWindow *wlist_foot = &wlist;

void x11_wlist_init()
{
	j_zero(&wlist, sizeof(JtkWindow));
}

void x11_wlist_add_window(JtkWindow *jw)
{
	wlist_foot->next = jw;
	wlist_foot = jw;
}

void x11_wlist_remove_window(JtkWindow *jw)
{
	JtkWindow *wl = wlist_head->next;
	JtkWindow *wl2 = wlist_head;
	
	while(wl != NULL){
		if(wl == jw){
			wl2->next = wl->next;
		}else{
			wl2 = wl;
		}
		wl = wl->next;
	}
}

JtkWindow* x11_wlist_find_window(Window window_id)
{
	JtkWindow *wl = wlist_head->next;
	
	while(wl != NULL){
		if(wl->window_id == window_id)
			return wl;
		
		wl = wl->next;
	}
	
	return NULL;
}

unsigned long x11_make_rgb(JtkColor color)
{
	Colormap cm;
	XColor xc;
	
	cm = DefaultColormap(display, 0);
	xc.red = jtkGetRValue(color) * 257;
	xc.green = jtkGetGValue(color) * 257;
	xc.blue = jtkGetBValue(color) * 257;
	XAllocColor(display, cm, &xc);
	return xc.pixel;
}
