#include "x11-core.h"

/* gl */
JtkGL* jtkGLCreateWindow(JtkWindow *jw)
{
	JtkGL *gl;
	int gl_attr[] = {
		GLX_RGBA,
		GLX_DOUBLEBUFFER,
		GLX_RED_SIZE, 1,
		GLX_GREEN_SIZE, 1,
		GLX_BLUE_SIZE, 1,
		None
	};
	XVisualInfo *vi;
	
	gl = j_malloc(sizeof(JtkGL));
	if(gl == NULL)
		return NULL;
	j_zero(gl, sizeof(JtkGL));
	
	vi = glXChooseVisual(display, DefaultScreen(display), gl_attr);
	gl->glx_context = glXCreateContext(display, vi, 0, GL_TRUE);
	XFree(vi);
	gl->drawable = jw->window_id;
	
	return gl;
}

JtkGL* jtkGLCreate(JtkWidget *widget)
{
	JtkWindow *jw;
	
	jw = jtkGetDrawingArea(widget);
	return jtkGLCreateWindow(jw);
}

void jtkGLDestroy(JtkGL *gl)
{
	glXMakeCurrent(display, 0, NULL);
	glXDestroyContext(display, gl->glx_context);
	j_free(gl);
}

void jtkGLCurrent(JtkGL *gl)
{
	if(gl == NULL)
		glXMakeCurrent(display, 0, NULL);
	else
	glXMakeCurrent(display, gl->drawable, gl->glx_context);
}

void jtkGLSwapBuffers(JtkGL *gl)
{
	if(gl != NULL)
		glXSwapBuffers(display, gl->drawable);
}
