#include "x11-core.h"

/* Window */
JtkWindow* jtkCreateSimpleWindow(JtkWindow *parent)
{
	JtkWindow *jw = NULL;
	Window p;
	XSizeHints hints;
	
	if(parent == NULL)
		p = RootWindow(display, 0);
	else
		p = parent->window_id;
	
	jw = j_malloc(sizeof(JtkWindow));
	if(jw == NULL)
		return NULL;
	j_zero(jw, sizeof(JtkWindow));
	
	jw->window_id = XCreateSimpleWindow(display, p, 0, 0, 32, 32, 0,
										BlackPixel(display, 0),
										WhitePixel(display, 0));
	x11_wlist_add_window(jw);
	
	if(parent == NULL){
		jw->top_level = 1;
		XSetWMProtocols(display, jw->window_id, &WM_DELETE_WINDOW, 1);
		
		memset(&hints, 0, sizeof(XSizeHints));
		hints.flags = USPosition | USSize;
		XSetWMNormalHints(display, jw->window_id, &hints);
	}
	
	return jw;
}

void jtkDestroyWindow(JtkWindow *jw)
{
	JtkWindowEvent jwe;

	x11_wlist_remove_window(jw);

	jwe.type = JTK_WINDOW_EVENT_DESTROY;
	jwe.any.window = jw;
	jwe.any.widget = jw->widget;
	if((jw->event_mask & JTK_WINDOW_EVENTMASK_DESTROY) &&
		(jw->callback != NULL))
		jw->callback(&jwe);
	XDestroyWindow(display, jw->window_id);
}

void jtkMapWindow(JtkWindow *jw)
{
	XMapWindow(display, jw->window_id);
	XFlush(display);
}

void jtkUnmapWindow(JtkWindow *jw)
{
	XUnmapWindow(display, jw->window_id);
	XFlush(display);
}

void jtkClearWindow(JtkWindow *jw, int x, int y,
						int width, int height,
						JtkBool exposures)
{
	if(exposures == JTK_TRUE)
		XClearArea(display, jw->window_id, x, y, width, height, True);
	else
		XClearArea(display, jw->window_id, x, y, width, height, False);
	XFlush(display);
}

void jtkRaiseWindow(JtkWindow *jw)
{
	XRaiseWindow(display, jw->window_id);
	XFlush(display);
}

void jtkLowerWindow(JtkWindow *jw)
{
	XLowerWindow(display, jw->window_id);
	XFlush(display);
}

void jtkSetWindowPos(JtkWindow *jw, int px, int py)
{
	XMoveWindow(display, jw->window_id, px, py);
	XFlush(display);
}

void jtkSetWindowSize(JtkWindow *jw, int width, int height)
{
	XResizeWindow(display, jw->window_id, width, height);
	XFlush(display);
}

void jtkSetWindowColor(JtkWindow *jw, JtkColor color)
{
	XSetWindowBackground(display, jw->window_id, x11_make_rgb(color));
	XFlush(display);
}

void jtkSetWindowBorderSize(JtkWindow *jw, int size)
{
	XSetWindowBorderWidth(display, jw->window_id, size);
	XFlush(display);
}

void jtkSetWindowBorderColor(JtkWindow *jw, JtkColor color)
{
	XSetWindowBorder(display, jw->window_id, x11_make_rgb(color));
	XFlush(display);
}

void jtkSetWindowText(JtkWindow *jw, char *text)
{	
	if(jw->top_level){
		XTextProperty ct;
		
		XmbTextListToTextProperty(display, &text, 1,
			XCompoundTextStyle, &ct);
		XSetWMName(display, jw->window_id, &ct);
		XSetWMIconName(display, jw->window_id, &ct);
		XFlush(display);
	}
}

void jtkGetWindowPos(JtkWindow *jw, JtkPoint *pos)
{
	Window w_root;
	int x, y;
	unsigned int width, height, border, depth;
	
	XGetGeometry(display, jw->window_id, &w_root,
		&x, &y, &width, &height, &border, &depth);
	
	pos->px = x;
	pos->py = y;
}

void jtkGetWindowSize(JtkWindow *jw, JtkSize *size)
{
	Window w_root;
	int x, y;
	unsigned int width, height, border, depth;
	
	XGetGeometry(display, jw->window_id, &w_root,
		&x, &y, &width, &height, &border, &depth);
	
	size->width = width;
	size->height = height;
}

void jtkSetWindowEventMask(JtkWindow *jw, int mask)
{
	int xmask = 0;
	
	if(mask & JTK_WINDOW_EVENTMASK_KEYDOWN)
		xmask |= KeyPressMask;
	if(mask & JTK_WINDOW_EVENTMASK_KEYUP)
		xmask |= KeyReleaseMask;
	if(mask & JTK_WINDOW_EVENTMASK_BUTTONDOWN)
		xmask |= ButtonPressMask;
	if(mask & JTK_WINDOW_EVENTMASK_BUTTONUP)
		xmask |= ButtonReleaseMask;
	if(mask & JTK_WINDOW_EVENTMASK_MOTION)
		xmask |= PointerMotionMask;
	if(mask & JTK_WINDOW_EVENTMASK_ENTER)
		xmask |= EnterWindowMask;
	if(mask & JTK_WINDOW_EVENTMASK_LEAVE)
		xmask |= LeaveWindowMask;
	if(mask & JTK_WINDOW_EVENTMASK_FOCUSIN)
		xmask |= FocusChangeMask;
	if(mask & JTK_WINDOW_EVENTMASK_FOCUSOUT)
		xmask |= FocusChangeMask;
	if(mask & JTK_WINDOW_EVENTMASK_MAP)
		xmask |= StructureNotifyMask;
	if(mask & JTK_WINDOW_EVENTMASK_UNMAP)
		xmask |= StructureNotifyMask;
	if(mask & JTK_WINDOW_EVENTMASK_MOVE)
		xmask |= StructureNotifyMask;
	if(mask & JTK_WINDOW_EVENTMASK_RESIZE)
		xmask |= StructureNotifyMask;
	if(mask & JTK_WINDOW_EVENTMASK_EXPOSE)
		xmask |= ExposureMask;
	
	XSelectInput(display, jw->window_id, xmask);
	jw->event_mask = mask;
}

void jtkSetWindowFocus(JtkWindow *jw)
{
	XSetInputFocus(display, jw->window_id, RevertToNone, 0);
	XFlush(display);
}

void jtkSetWidget(JtkWindow *jw,
					void (*callback)(JtkWindowEvent *event),
					JtkWidget *widget)
{
	jw->callback = callback;
	jw->widget = widget;
}
