/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity;

import java.util.Date;

/**
 * 登録日時、更新日時を実装したエンティティクラスです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public abstract class AuditableEntity implements Auditable {

    /** nullable persistent field */
    private Date createDate;

    /** nullable persistent field */
    private Date updateDate;


    /**
     * エンティティの登録日時を取得します。
     * @return エンティティの登録日時
     */
    public Date getCreateDate() {
        return this.createDate;
    }

    /**
     * エンティティの登録日時を設定します。
     * @param createDate エンティティの登録
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * エンティティの更新日時を取得します。
     * @return エンティティの更新日時
     */
    public Date getUpdateDate() {
        return this.updateDate;
    }

    /**
     * エンティティの更新日時を設定します。
     * @param updateDate エンティティの更新日時
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}
