/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.entity.mail;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * BCCメールテーブルのプライマリキークラスです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class MailBccTablePK implements Serializable {

    /** identifier field */
    private Integer id;

    /** identifier field */
    private Integer seq;

    /** full constructor */
    public MailBccTablePK(Integer id, Integer seq) {
        this.id = id;
        this.seq = seq;
    }

    /** default constructor */
    public MailBccTablePK() {
    }

    /**
     * @hibernate.property
     *  column="id"
     */
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * @hibernate.property
     *  column="seq"
     */
    public Integer getSeq() {
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .append("seq", getSeq())
            .toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof MailBccTablePK) ) return false;
        MailBccTablePK castOther = (MailBccTablePK) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId())
            .append(this.getSeq(), castOther.getSeq())
            .isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder()
            .append(getId())
            .append(getSeq())
            .toHashCode();
    }

}
