package org.jtp.entity.test;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jtp.entity.AuditableEntity;

/**
 * テスト詳細テーブルのエンティティクラスです。
 * 
 * @hibernate.class
 *  table="test_table_detail"
 *  mutable = "true"
 *  lazy = "false"
 * 
 * @hibernate.mapping
 *  auto-import = "true"
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
@SuppressWarnings("serial")
public class TestTableDetail extends AuditableEntity {

    /** identifier field */
    private TestTableDetailPK compId;

    /** nullable persistent field */
    private String hogehoge1;

    /** nullable persistent field */
    private String hogehoge2;

    /** nullable persistent field */
    private String hogehoge3;

    /** nullable persistent field */
    private String hogehoge4;

    /** nullable persistent field */
    private String hogehoge5;

    /** nullable persistent field */
    private String hogehoge6;

    /** nullable persistent field */
    private String hogehoge7;

    /** nullable persistent field */
    private String hogehoge8;

    /** nullable persistent field */
    private String hogehoge9;


    /** default constructor */
    public TestTableDetail() {}

    /** minimal constructor */
    public TestTableDetail(TestTableDetailPK compId) {
        this.compId = compId;
    }

    /**
     * @hibernate.id
     */
    public TestTableDetailPK getCompId() {
        return this.compId;
    }

    public void setCompId(TestTableDetailPK compId) {
        this.compId = compId;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge1"
     */
    public String getHogehoge1() {
        return this.hogehoge1;
    }

    public void setHogehoge1(String hogehoge1) {
        this.hogehoge1 = hogehoge1;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge2"
     */
    public String getHogehoge2() {
        return this.hogehoge2;
    }

    public void setHogehoge2(String hogehoge2) {
        this.hogehoge2 = hogehoge2;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge3"
     */
    public String getHogehoge3() {
        return this.hogehoge3;
    }

    public void setHogehoge3(String hogehoge3) {
        this.hogehoge3 = hogehoge3;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge4"
     */
    public String getHogehoge4() {
        return this.hogehoge4;
    }

    public void setHogehoge4(String hogehoge4) {
        this.hogehoge4 = hogehoge4;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge5"
     */
    public String getHogehoge5() {
        return this.hogehoge5;
    }

    public void setHogehoge5(String hogehoge5) {
        this.hogehoge5 = hogehoge5;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge6"
     */
    public String getHogehoge6() {
        return this.hogehoge6;
    }

    public void setHogehoge6(String hogehoge6) {
        this.hogehoge6 = hogehoge6;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge7"
     */
    public String getHogehoge7() {
        return this.hogehoge7;
    }

    public void setHogehoge7(String hogehoge7) {
        this.hogehoge7 = hogehoge7;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge8"
     */
    public String getHogehoge8() {
        return this.hogehoge8;
    }

    public void setHogehoge8(String hogehoge8) {
        this.hogehoge8 = hogehoge8;
    }

    /** 
     * @hibernate.property
     *  column="hogehoge9"
     */
    public String getHogehoge9() {
        return this.hogehoge9;
    }

    public void setHogehoge9(String hogehoge9) {
        this.hogehoge9 = hogehoge9;
    }

    public String toString() {
        return new ToStringBuilder(this).append("compId", getCompId()).toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof TestTableDetail) ) return false;
        TestTableDetail castOther = (TestTableDetail) other;
        return new EqualsBuilder().append(this.getCompId(), castOther.getCompId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(getCompId()).toHashCode();
    }
}
