/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.mail.MailAddressTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="mailAddressTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class MailAddressTableDaoImpl extends BaseDao implements MailAddressTableDao {
	
	/**
	 * 検索します。
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public List findAll() throws SampleException {
    	return getHibernateTemplate().loadAll(MailAddressTable.class);
    }
    
	/**
	 * 登録します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAddressTable mailAddressTable) throws SampleException {
    	getHibernateTemplate().save(mailAddressTable);
    	getHibernateTemplate().flush();
    }

	/**
	 * 更新します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(MailAddressTable mailAddressTable) throws SampleException {
    	getHibernateTemplate().update(mailAddressTable);
    	getHibernateTemplate().flush();
    }
    
	/**
	 * 削除します。
	 * @param mailAddressTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(MailAddressTable testTable) throws SampleException {
    	getHibernateTemplate().delete(testTable);
    	getHibernateTemplate().flush();
    }
}
