/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.Set;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.mail.MailAttachTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="mailAttachTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class MailAttachTableDaoImpl extends BaseDao implements MailAttachTableDao {
    
	/**
	 * 登録します。
	 * @param mailAttachTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailAttachTable mailAttachTable) throws SampleException {
    	getHibernateTemplate().save(mailAttachTable);
    }
    
	/**
	 * 登録します。
	 * @param mailAttachSet エンティティ
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public void save(Set mailAttachSet) throws SampleException {
    	getHibernateTemplate().saveOrUpdateAll(mailAttachSet);
    }
}
