/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.mail;

import java.util.Set;

import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.mail.MailCcTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="mailCcTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class MailCcTableDaoImpl extends BaseDao implements MailCcTableDao {
    
	/**
	 * 登録します。
	 * @param mailCcTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(MailCcTable mailCcTable) throws SampleException {
    	getHibernateTemplate().save(mailCcTable);
    }
    
	/**
	 * 登録します。
	 * @param mailCcSet エンティティ
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public void save(Set mailCcSet) throws SampleException {
    	getHibernateTemplate().saveOrUpdateAll(mailCcSet);
    }
}
