/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.test;

import java.util.List;

import org.jtp.SampleException;
import org.jtp.entity.test.TestTable;



/**
 * データアクセスインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public interface TestTableDao {
	
	/**
	 * 検索します。
	 * @param testTable エンティティ
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public List find(TestTable testTable) throws SampleException;
    
	/**
	 * 登録します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTable testTable) throws SampleException;
    
	/**
	 * 更新します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTable testTable) throws SampleException;
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTable testTable) throws SampleException;
}
