/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.test;

import java.util.List;

import org.hibernate.Query;
import org.jtp.SampleException;
import org.jtp.dao.BaseDao;
import org.jtp.entity.test.TestTable;

/**
 * データアクセスクラスです。
 * 
 * @spring.bean id="testTableDao" 
 * @spring.property name="sessionFactory" ref="sessionFactory" 
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class TestTableDaoImpl extends BaseDao implements TestTableDao {
	
	/**
	 * 検索します。
	 * @param testTable エンティティ
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public List find(TestTable testTable) throws SampleException {
        Query query = getSession().getNamedQuery("testTableList");
        query.setInteger("id", toCondition(testTable.getId()));
        query.setString("hoge1", toPartMatch(testTable.getHoge1()));
        query.setString("hoge2", toPartMatch(testTable.getHoge2()));
        query.setString("hoge3", toPartMatch(testTable.getHoge3()));
        return query.list();
    }
    
	/**
	 * 登録します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTable testTable) throws SampleException {
    	getHibernateTemplate().save(testTable);
    	getHibernateTemplate().flush();
    }

	/**
	 * 更新します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTable testTable) throws SampleException {
    	getHibernateTemplate().update(testTable);
    	getHibernateTemplate().flush();
    }
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTable testTable) throws SampleException {
    	getHibernateTemplate().delete(testTable);
    	getHibernateTemplate().flush();
    }
}
