/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.dao.test;

import org.jtp.SampleException;
import org.jtp.entity.test.TestTableDetail;


/**
 * データアクセスインターフェースです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public interface TestTableDetailDao {
    
	/**
	 * 登録します。
	 * @param testTableDetail エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTableDetail testTableDetail) throws SampleException;
    
	/**
	 * 更新します。
	 * @param testTableDetail エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void update(TestTableDetail testTableDetail) throws SampleException;
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void delete(TestTableDetail testTableDetail) throws SampleException;
}
