/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.logic.test;

import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.jtp.SampleException;
import org.jtp.dao.test.TestTableDao;
import org.jtp.dao.test.TestTableDetailDao;
import org.jtp.entity.test.TestTable;
import org.jtp.entity.test.TestTableDetail;
import org.jtp.entity.test.TestTableDetailPK;



/** 
 * テストテーブル情報のサービスクラスです。
 * 
 * @spring.bean id="testTableService" 
 * @spring.property name="testTableDao" ref="testTableDao"
 * @spring.property name="testTableDetailDao" ref="testTableDetailDao"
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 */
public class TestTableServiceImpl implements TestTableService {

	/** テストテーブル情報DAO */
	private TestTableDao testTableDao;
	
	/** テストテーブル詳細情報DAO */
	private TestTableDetailDao testTableDetailDao;


    /**
     * Setter Injection
     */
	public void setTestTableDao(TestTableDao dao) {
		this.testTableDao = dao;
	}

    /**
     * Setter Injection
     */
	public void setTestTableDetailDao(TestTableDetailDao dao) {
		this.testTableDetailDao = dao;
	}

	/**
	 * 検索します。
	 * @param testTable エンティティ
	 * @return エンティティのリスト
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public List find(TestTable testTable) throws SampleException {
    	return testTableDao.find(testTable);
    }
    
	/**
	 * 登録します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
    public void save(TestTable testTable) throws SampleException {
    	testTableDao.save(testTable);
    	TestTableDetailPK pk = new TestTableDetailPK(testTable.getId(), new Integer(1));
    	TestTableDetail detail = new TestTableDetail(pk);
       	testTableDetailDao.save(detail);
    }

	/**
	 * 更新します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public void update(TestTable testTable) throws SampleException {
    	testTableDao.update(testTable);
     	Set set = testTable.getTestTableDetails();
     	for (Iterator it = set.iterator(); it.hasNext();) {
     		TestTableDetail detail = (TestTableDetail) it.next();
        	testTableDetailDao.update(detail);
     	}
    }
    
	/**
	 * 削除します。
	 * @param testTable エンティティ
	 * @throws SampleException システム一般例外
	 */
	@SuppressWarnings("unchecked")
    public void delete(TestTable testTable) throws SampleException {
     	Set set = testTable.getTestTableDetails();
     	for (Iterator it = set.iterator(); it.hasNext();) {
     		TestTableDetail detail = (TestTableDetail) it.next();
        	testTableDetailDao.delete(detail);
     	}
    	testTableDao.delete(testTable);
    }
}
