/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.Iterator;
import java.util.List;

import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAccountTable;
import org.jtp.logic.mail.MailAccountTableService;
import org.jtp.web.action.SampleActionSupport;
import org.jtp.web.bean.MailAddressBean;

import com.opensymphony.xwork2.inject.Inject;

/**
 * アカウント変更画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/accountUpdate"
 *  scope="request"
 *  validate="true"
 *  input="/mail/account.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="success"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/mail/account.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class AccountUpdateAction extends SampleActionSupport {

    /** アカウントテーブル情報サービス */
    private MailAccountTableService mailAccountTableService;

    @Inject
    private MailAddressBean mailAddressBean;

    /**
     * アカウントテーブル情報サービスを設定します。
     * @param mailAccountTableService アカウントテーブル情報サービス
     */
	public void setMailAccountTableService(MailAccountTableService mailAccountTableService) {
		this.mailAccountTableService = mailAccountTableService;
	}

	public MailAddressBean getMailAddressBean() {
		return mailAddressBean;
	}

	public void setMailAddressBean(MailAddressBean mailAddressBean) {
		this.mailAddressBean = mailAddressBean;
	}

	/**
	 * 更新アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String success() throws Exception {
		
		Integer id = new Integer(getRequest().getParameter("id"));

		MailAccountTable entity = null;

		List list = (List) getRequest().getSession().getAttribute("accountList");
		for (Iterator it = list.iterator(); it.hasNext();) {
			entity = (MailAccountTable) it.next();
			if (entity.getId().intValue() == id.intValue()) {
				PropertyUtilsWrapper.copyProperties(getMailAddressBean(), entity);
				break;
			}
		}
		
		mailAccountTableService.update(entity);

    	return SUCCESS;
    }
}
