/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.Iterator;
import java.util.List;

import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAddressTable;
import org.jtp.logic.mail.MailAddressTableService;
import org.jtp.web.action.SampleActionSupport;
import org.jtp.web.bean.MailAddressBean;

import com.opensymphony.xwork2.inject.Inject;

/**
 * アドレス帳変更画面アクションクラスです。
 * 
 * @struts.action
 *  name="mailAddressForm"
 *  path="/mail/addressUpdate"
 *  scope="request"
 *  validate="true"
 *  input="/mail/address.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="success"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/mail/address.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class AddressUpdateAction extends SampleActionSupport {

    /** メールアドレステーブル情報サービス */
    private MailAddressTableService mailAddressTableService;

    @Inject
    private MailAddressBean mailAddressBean;

    /**
     * メールアドレステーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailAddressTableService(MailAddressTableService mailAddressTableService) {
		this.mailAddressTableService = mailAddressTableService;
	}

	public MailAddressBean getMailAddressBean() {
		return mailAddressBean;
	}

	public void setMailAddressBean(MailAddressBean mailAddressBean) {
		this.mailAddressBean = mailAddressBean;
	}

	/**
	 * 更新アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String success() throws Exception {
		
		Integer id = new Integer(getRequest().getParameter("id"));

		MailAddressTable entity = null;

		List list = (List) getRequest().getSession().getAttribute("addressList");
		for (Iterator it = list.iterator(); it.hasNext();) {
			entity = (MailAddressTable) it.next();
			if (entity.getId().intValue() == id.intValue()) {
				PropertyUtilsWrapper.copyProperties(getMailAddressBean(), entity);
				break;
			}
		}
		
		mailAddressTableService.update(entity);

    	return SUCCESS;
    }
}
