/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.sample;

import java.util.Iterator;
import java.util.List;

import org.jtp.SampleException;
import org.jtp.entity.test.TestTable;
import org.jtp.logic.test.TestTableService;
import org.jtp.web.action.SampleActionSupport;

/**
 * 削除画面アクションクラスです。
 * 
 * @struts.action
 *  name="sample/InputForm"
 *  path="/sample/remove"
 *  scope="request"
 *  validate="true"
 *  input="/sample/remove.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="success"
 *  path="/sample/search.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/sample/search.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class RemoveAction extends SampleActionSupport {

    /** テストテーブル情報サービス */
    private TestTableService testTableService;

    
    /**
     * テストテーブル情報サービスを設定します。
     * @param testTableService テストテーブル情報サービス
     */
	public void setTestTableService(TestTableService testTableService) {
		this.testTableService = testTableService;
	}

	/**
	 * 削除アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String success() throws Exception {

		Integer id = new Integer(getRequest().getParameter("id"));
    	List list = (List) getRequest().getSession().getAttribute("list");
    	for (Iterator it = list.iterator(); it.hasNext();) {
    		TestTable entity = (TestTable) it.next();
    		if (entity.getId().intValue() != id.intValue()) continue;
    		testTableService.delete(entity);
    		break;
    	}
		
		getRequest().getSession().setAttribute("list", testTableService.find(new TestTable()));
		
		return SUCCESS;
	}
}
