/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.listener;

import java.io.InputStream;
import java.util.Properties;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * WebアプリケーションにあるServletコンテキストの変更に関する通知を受け取るクラスです。
 * 
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 271 $ $Date: 2008-06-17 00:18:00 +0900 $
 */
public class StartupServletContextListener implements ServletContextListener {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(StartupServletContextListener.class);

	/**
	 * Webアプリケーションがリクエストを処理する準備ができたことを通知します。
	 * @param event Servletコンテキストに変更があったことを通知するためのイベント
	 */
	public void contextInitialized(ServletContextEvent event) {
		try {
			_log.info("initialize start");

			//データベース種別をコンテキストに設定します
			ServletContext context = event.getServletContext();
			InputStream stream = context.getResourceAsStream("/WEB-INF/database.properties");
	        Properties prop = new Properties();
	        prop.load(stream);
	        String dbType = prop.getProperty("database.type");

	        context.setAttribute("dbType", dbType);
			
			_log.info("initialize end");
		} 
		catch (Exception e) {
			_log.error(e.getMessage());
			throw new RuntimeException(e);
		}
	}

	/**
	 * Servletコンテキストがシャットダウン処理に入ることを通知します。
	 * @param event Servletコンテキストに変更があったことを通知するためのイベント
	 */
	public void contextDestroyed(ServletContextEvent event) {
		try {
			_log.info("destroy start");

			_log.info("destroy end");

		}
		catch (Exception e) {
			_log.error(e.getMessage());
		}
	}
}
