/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.SampleException;
import org.jtp.entity.mail.MailAttachTable;
import org.jtp.entity.mail.MailTable;
import org.jtp.web.action.BaseDownloadAction;

/**
 * メール送信履歴画面アクションクラスです。
 * 
 * @struts.action
 *  name="mail/InputForm"
 *  path="/mail/history"
 *  scope="request"
 *  validate="true"
 *  input="/mail/history.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="detail"
 *  path="/mail/history_detail.tiles"
 * @struts.action-forward
 *  name="page"
 *  path="/mail/history.tiles"
 * @struts.action-forward
 *  name="download"
 *  path="/mail/history_detail.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/mail/history.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class HistoryAction extends BaseDownloadAction {

	/**
	 * 詳細表示アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String detail() throws Exception {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	List list = (List) getRequest().getSession().getAttribute("historyList");
    	MailTable entity = (MailTable) list.get(index);
    	if (StringUtils.isNotEmpty(entity.getBody())) {
        	entity.setBody(entity.getBody().replaceAll("\r\n", "<br>"));
    	}
     	getRequest().setAttribute("mailTable", entity);
    	getRequest().setAttribute("index", String.valueOf(index));
    	return SUCCESS;
    }
    
    /**
     * {@inheritDoc}
     */
	@Override
    protected String getFileName() {
        return getMailAttachTable().getAttachName();
	}

    /**
     * {@inheritDoc}
     */
	@Override
    protected InputStream getDownloadStream() throws IOException {
        return new ByteArrayInputStream(getMailAttachTable().getAttach());
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected boolean isSkipTokenValid(ActionMapping mapping, HttpServletRequest request) {
		return "download".equals(getRequest().getParameter(""));
	}
	
	/**
	 * 選択された添付メールテーブルのエンティティを取得します
	 * @param request 処理しているHTTPリクエスト
	 * @return 選択された添付メールテーブルのエンティティ
	 */
	@SuppressWarnings("unchecked")
	private MailAttachTable getMailAttachTable() {
    	int index = Integer.parseInt(getRequest().getParameter("index"));
    	int seq = Integer.parseInt(getRequest().getParameter("seq"));
    	List list = (List) getRequest().getSession().getAttribute("historyList");
    	MailTable mailTable = (MailTable) list.get(index);
		Set mailAttachTables = mailTable.getMailAttachTables();
		
		MailAttachTable result = null;
        for (Iterator it = mailAttachTables.iterator(); it.hasNext();) {
        	MailAttachTable entity = (MailAttachTable) it.next();
        	if (entity.getId().getSeq().intValue() != seq) continue;
        	result = entity;
        }
        return result;
	}
}
