/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.jtp.SampleException;
import org.jtp.logic.mail.MailAccountTableService;
import org.jtp.logic.mail.MailAddressTableService;
import org.jtp.logic.mail.MailTableService;
import org.jtp.web.action.SampleActionSupport;

/**
 * ナビゲーション画面アクションクラスです。
 * 
 * @struts.action
 *  path="/mail/navigation"
 *  scope="request"
 *  validate="true"
 *  input="/mail/send.tiles"
 *  parameter="event"
 *  cancellable="true"
 * @struts.action-forward
 *  name="send"
 *  path="/mail/send.tiles"
 * @struts.action-forward
 *  name="history"
 *  path="/mail/history.tiles"
 * @struts.action-forward
 *  name="address"
 *  path="/mail/address.tiles"
 * @struts.action-forward
 *  name="account"
 *  path="/mail/account.tiles"
 * @struts.action-forward
 *  name="cancel"
 *  path="/jsp/common/menu.jsp"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class NavigationAction extends SampleActionSupport {
	
    /** このクラスで発生した実行状況をログに記録するためのオブジェクトです。 */
    private static final Log _log = LogFactory.getLog(NavigationAction.class);

    /** メールテーブル情報サービス */
    private MailTableService mailTableService;

    /** メールアドレステーブル情報サービス */
    private MailAddressTableService mailAddressTableService;

    /** アカウントテーブル情報サービス */
    private MailAccountTableService mailAccountTableService;

    
    /**
     * メールテーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailTableService(MailTableService mailTableService) {
		this.mailTableService = mailTableService;
	}
    
    /**
     * メールアドレステーブル情報サービスを設定します。
     * @param mailAddressTableService メールアドレステーブル情報サービス
     */
	public void setMailAddressTableService(MailAddressTableService mailAddressTableService) {
		this.mailAddressTableService = mailAddressTableService;
	}
    
    /**
     * アカウントテーブル情報サービスを設定します。
     * @param mailAccountTableService メールアドレステーブル情報サービス
     */
	public void setMailAccountTableService(MailAccountTableService mailAccountTableService) {
		this.mailAccountTableService = mailAccountTableService;
	}

    /**
     * {@inheritDoc}
     */
	@Override
    public String execute() throws Exception {
		getRequest().getSession().removeAttribute("accountList");
		getRequest().getSession().removeAttribute("addressList");
		getRequest().getSession().removeAttribute("historyList");
		return super.execute();
	}
	
	/**
	 * 送信アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	public String send() throws Exception {
		getRequest().getSession().setAttribute("accountList", mailAccountTableService.findAll());
		getRequest().getSession().setAttribute("addressList", mailAddressTableService.findAll());
    	return SUCCESS;
    }
    
    /**
     * 送信履歴アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String history() throws Exception {
		List result = mailTableService.findHistory();
		_log.info("history：" + ((result == null) ? 0 : result.size()));
		getRequest().getSession().setAttribute("historyList", result);
    	return SUCCESS;
    }
    
    /**
     * アドレス帳アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String address() throws Exception {
		List result = mailAddressTableService.findAll();
		getRequest().getSession().setAttribute("addressList", result);
    	return SUCCESS;
    }
    
    /**
     * アカウント設定アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
     */
	@SuppressWarnings("unchecked")
	public String account() throws Exception {
		List result = mailAccountTableService.findAll();
		getRequest().getSession().setAttribute("accountList", result);
    	return SUCCESS;
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected boolean isSkipTokenValid(ActionMapping mapping, HttpServletRequest request) {
		return true;
	}
}
