/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.action.mail;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jtp.SampleException;
import org.jtp.common.util.PropertyUtilsWrapper;
import org.jtp.entity.mail.MailAttachTable;
import org.jtp.entity.mail.MailAttachTablePK;
import org.jtp.entity.mail.MailBccTable;
import org.jtp.entity.mail.MailBccTablePK;
import org.jtp.entity.mail.MailCcTable;
import org.jtp.entity.mail.MailCcTablePK;
import org.jtp.entity.mail.MailTable;
import org.jtp.logic.mail.MailTableService;
import org.jtp.web.action.SampleActionSupport;
import org.jtp.web.bean.SendMailBean;

import com.opensymphony.xwork2.inject.Inject;

/**
 * メール送信画面アクションクラスです。
 * 
 * @struts.action
 *  name="mail/InputForm"
 *  path="/mail/send"
 *  scope="request"
 *  validate="true"
 *  input="/mail/send.tiles"
 *  parameter="event"
 * @struts.action-forward
 *  name="success"
 *  path="/mail/send.tiles"
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
@SuppressWarnings("serial")
public class SendAction extends SampleActionSupport {

    /** メールテーブル情報サービス */
    private MailTableService mailTableService;

    @Inject
    private SendMailBean sendMailBean;
    
    /**
     * メールテーブル情報サービスを設定します。
     * @param mailTableService メールテーブル情報サービス
     */
	public void setMailTableService(MailTableService mailTableService) {
		this.mailTableService = mailTableService;
	}

	public SendMailBean getSendMailBean() {
		return sendMailBean;
	}

	public void setSendMailBean(SendMailBean sendMailBean) {
		this.sendMailBean = sendMailBean;
	}

	/**
	 * 送信アクションを処理します。
     * @return 指定された非HTTPリクエストを処理して、 対応する非HTTPレスポンスを生成します
     * （またはレスポンスを生成する他のWebコンポーネントにリクエストをフォワードします）。
     * @throws SampleException システム例外
	 */
	@SuppressWarnings("unchecked")
	public String send() throws Exception {
		SendMailBean input = getSendMailBean();
		MailTable entity = new MailTable();
		PropertyUtilsWrapper.copyProperties(input, entity);
		
		if (StringUtils.isNotEmpty(input.getCc())) {
			entity.setMailCcTables(new HashSet());
			String[] args = input.getCc().trim().split(",");
			for (int i = 0; i < args.length; i++) {
				MailCcTable cc = new MailCcTable();
				cc.setId(new MailCcTablePK());
				cc.getId().setSeq(new Integer(i));
				cc.setCc(args[i]);
				entity.getMailCcTables().add(cc);
			}
		}
		
		if (StringUtils.isNotEmpty(input.getBcc())) {
			entity.setMailBccTables(new HashSet());
			String[] args = input.getBcc().trim().split(",");
			for (int i = 0; i < args.length; i++) {
				MailBccTable bcc = new MailBccTable();
				bcc.setId(new MailBccTablePK());
				bcc.getId().setSeq(new Integer(i));
				bcc.setBcc(args[i]);
				entity.getMailBccTables().add(bcc);
			}
		}
		
		File[] files = input.getAttachment();
		for (int i = 0; i < files.length; i++) {
			if (StringUtils.isEmpty(files[i].getName())) continue;
			if (entity.getMailAttachTables() == null) {
				entity.setMailAttachTables(new HashSet());
			}
			MailAttachTable attach = new MailAttachTable();
			attach.setId(new MailAttachTablePK());
			attach.getId().setSeq(new Integer(i));
			attach.setAttachName(files[i].getName());
			attach.setAttach(IOUtils.toByteArray(new FileInputStream(files[i])));
			entity.getMailAttachTables().add(attach);
		}
		
		mailTableService.save(entity);
		
    	return SUCCESS;
    }
}
