/*
 * Java Template Project
 * 
 * Copyright (C) 2006 Satoshi Nagashiba, All Rights Reserved.
 */
package org.jtp.web.report;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

import javax.servlet.ServletContext;

/**
 * 帳票データ生成を提供するインターフェースです。 
 *
 * @author <a href="mailto:sato-vista@tbb.t-com.ne.jp">Satoshi Nagashiba</a>
 * @version $Revision: 204 $ $Date: 2007-06-06 01:03:34 +0900 $
 */
public interface ReportGenerator {

	/**
     * 帳票出力情報オブジェクトを保持したコレクションを生成する
     * @param object 申込バッキングビーン
     * @param context サーブレットコンテキスト
     * @return 帳票出力情報オブジェクトを保持したコレクション
     * @throws IOException I/O例外
     */
	@SuppressWarnings("unchecked")
    public InputStream generate(ServletContext context, Collection collection) throws IOException;
}
