package com.jm.db;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.jm.JmPattern;
import com.jm.utility.JmException;

public class Dao {
	private static Dao instance = new Dao();
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateStmt = null;
	private SQLiteStatement deleteStmt = null;
	
	public static Dao getInstance(){
		return instance;
	}
	
	private Dao(){
		
	}
	
	public void init(SQLiteDatabase db)
	{
		db.execSQL(
				"create table pattern ("
				+ "id integer primary key, "
				+ "type integer not null, "
				+ "siteswap text not null, "
				+ "height integer, "
				+ "dwell integer, "
				+ "name integer, "
				+ "motion text);"
			);
		start(db);
	}
	
	public void start(SQLiteDatabase db){
		insertStmt = db.compileStatement(
				"insert into pattern ("
				+ "type, siteswap, height, dwell, name, motion"
				+ ") values ("
				+ "?, ?, ?, ?, ?, ?"
				+ ");");	
		updateStmt = db.compileStatement(
				"update pattern set "
				+ "siteswap = ?, height = ?, dwell = ?, name = ?, motion = ? "
				+ "where id = ?;");
		deleteStmt = db.compileStatement(
				"delete from pattern where id = ?;");
	}
	
	public void add(JmPattern jp) throws JmException{
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = insertStmt;
			stmt.bindLong(i++, jp.getType());
			stmt.bindString(i++, jp.getSiteSwap().toString());
			stmt.bindLong(i++, jp.getHeight());
			stmt.bindLong(i++, jp.getDwell());
			stmt.bindString(i++, jp.getName());
			stmt.bindString(i++, jp.motionToString());
			stmt.executeInsert();
			db.setTransactionSuccessful();
		} catch (SQLException e){
			throw new JmException(e);
		} finally {
			db.endTransaction();
		}
	}
	
	public void set(JmPattern jp) throws JmException{
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = updateStmt;
			stmt.bindString(i++, jp.getSiteSwap().toString());
			stmt.bindLong(i++, jp.getHeight());
			stmt.bindLong(i++, jp.getDwell());
			stmt.bindString(i++, jp.getName());
			stmt.bindString(i++, jp.motionToString());
			stmt.bindLong(i++, jp.getId());
			stmt.execute();
			db.setTransactionSuccessful();
		} catch (SQLException e){
				throw new JmException(e);
		} finally {
			db.endTransaction();
		}
	}

	public void delete(int id) throws JmException{
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = deleteStmt;
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} catch (SQLException e){
				throw new JmException(e);
		} finally {
			db.endTransaction();
		}
	}

	public JmPattern[] get(int type) throws JmException{
		JmPattern[] list = null;
		try {
			DatabaseHelper helper = DatabaseHelper.getInstance();
			SQLiteDatabase db = helper.getReadableDatabase();
			String selection = "type = " + type;
			Cursor c = db.query(
					"pattern",
					new String[] {
							"id",
							"type",
							"siteswap",
							"height",
							"dwell",
							"name",
							"motion"},
							selection, null, null, null, null);
			c.moveToFirst();
			list = new JmPattern[c.getCount()];
			for (int i = 0; i < list.length; i++) {
				JmPattern jp = new JmPattern(
						c.getInt(0), // id
						c.getInt(1), // type
						c.getString(5), // name
						c.getString(2), // siteswap
						c.getInt(3), // height
						c.getInt(4), // dwell
						JmPattern.getMotion(c.getString(6))); // motions
			    list[i] = jp;
			    c.moveToNext();
			}
			c.close();
		} catch (SQLException e){
			throw new JmException(e);
		}
		return list;
	}
	
	public JmPattern[] getFromId(int id) throws JmException{
		JmPattern[] list = null;
		try {
			DatabaseHelper helper = DatabaseHelper.getInstance();
			SQLiteDatabase db = helper.getReadableDatabase();
			String selection = "id = " + id;
			Cursor c = db.query(
					"pattern",
					new String[] {
							"id",
							"type",
							"siteswap",
							"height",
							"dwell",
							"name",
							"motion"},
							selection, null, null, null, null);
			c.moveToFirst();
			list = new JmPattern[c.getCount()];
			for (int i = 0; i < list.length; i++) {
				JmPattern jp = new JmPattern(
						c.getInt(0), // id
						c.getInt(1), // type
						c.getString(5), // name
						c.getString(2), // siteswap
						c.getInt(3), // height
						c.getInt(4), // dwell
						JmPattern.getMotion(c.getString(6))); // motions
			    list[i] = jp;
			    c.moveToNext();
			}
			c.close();
		} catch (SQLException e){
			throw new JmException(e);
		}
		return list;
	}

	public int count() throws JmException{
		int count = -1;
		try {
			DatabaseHelper helper = DatabaseHelper.getInstance();
			SQLiteDatabase db = helper.getReadableDatabase();
			String sql = "select count(*) from pattern;";
			Cursor c = db.rawQuery(sql, null);
			c.moveToFirst();
			count = c.getInt(0); // count;
			c.close();
		} catch (SQLException e){
			throw new JmException(e);
		}
		return count;
	}
}
