package org.junitdoc;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class JUnitDocPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.junitdoc.core";

	// The shared instance
	private static JUnitDocPlugin plugin;

	public static final String IMG_NEW_DECISIONTABLE = "icons/new_table.gif";

	public static final String IMG_NEW_DECISIONTABLE_ITEM = "icons/new_decisiontable.gif";

	public static final String IMG_EXPORT_DECISIONTABLE = "icons/export_wiz.gif";

	public static final String IMG_NEW_TESTMETHOD_ITEM = "icons/add_testmethod.gif";

	public static final String IMG_REFRESH = "icons/refresh.gif";

	public static final String IMG_SYNCED = "icons/synced.gif";

	private static boolean debug = false;

	public JUnitDocPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static JUnitDocPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public static void debugLog(Object message) {
		if (debug) {
			IStatus status = new Status(Status.INFO, PLUGIN_ID,
					toString(message));
			getDefault().getLog().log(status);
		}
	}

	private static String toString(Object message) {
		if (message == null) {
			return "null";
		}
		return message.toString();
	}

	public static void errorLog(String message) {
		IStatus status = new Status(Status.ERROR, PLUGIN_ID, message);
		getDefault().getLog().log(status);
	}

	public static void errorLog(String message, Throwable t) {
		IStatus status = new Status(Status.ERROR, PLUGIN_ID, message, t);
		getDefault().getLog().log(status);
	}

	public static void errorLog(Throwable t) {
		IStatus status = new Status(Status.ERROR, PLUGIN_ID, "ERROR!", t);
		getDefault().getLog().log(status);
	}
}
