package org.junitdoc.core.rewriter;

import java.util.List;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.junitdoc.core.decisiontable.DecisionTableModel;
import org.junitdoc.core.decisiontable.TestMethod;
import org.junitdoc.core.decisiontable.Type;
import org.junitdoc.core.jdt.Method;
import org.junitdoc.ui.Const;

public class ChangeStateHandler extends RewriteHandlerAdapter {

	private Type type;

	private TestMethod testMethod;

	private boolean isAddMode;

	public ChangeStateHandler(Type type, TestMethod testMethod) {
		this.type = type;
		this.testMethod = testMethod;
	}

	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		if (testMethod.isChecked(type)) {
			removeAnnotation(rewrite);
		} else {
			addAnnotation(node, rewrite);
		}
	}

	@Override
	public void afterRewrite(ICompilationUnit source) {
		JDTUtils.getActiveJavaEditor().selectAndReveal(0, 0);
		// if (isAddMode) {
		// CompilationUnit unit;
		// try {
		// unit = source.reconcile(ICompilationUnit.NO_AST, false, null,
		// null);
		//
		// MethodDeclaration method = ASTUtils.findMethodDeclaration(unit,
		// testMethod.getName(), testMethod.getSource()
		// .parameters());
		// new Method(method).selectAndReveal();
		//
		// } catch (JavaModelException e) {
		// e.printStackTrace();
		// }
		// }
	}

	private void removeAnnotation(ASTRewrite rewrite) {
		MarkerAnnotation marker = testMethod.getMarkerAnnotation(type);
		rewrite.remove(marker, null);
	}

	private void addAnnotation(ASTNode node, ASTRewrite rewrite) {
		isAddMode = true;

		AST ast = node.getAST();

		MethodDeclaration methodDeclaration = testMethod.getSource();

		ListRewrite listRewrite = rewrite.getListRewrite(methodDeclaration,
				MethodDeclaration.MODIFIERS2_PROPERTY);

		MarkerAnnotation newAnno = ast.newMarkerAnnotation();
		newAnno.setTypeName(ast.newName(type.getFullName()));

		List<MarkerAnnotation> annos = testMethod.getMarkerAnnotations();

		// No MarkerAnnotation
		if (annos.size() == 0) {
			listRewrite.insertFirst(newAnno, null);
			return;
		}

		DecisionTableModel decisionTable = testMethod.getDecisionTable();

		if (annos.size() == 1) {
			// only @Test
			if (annos.get(0).getTypeName().getFullyQualifiedName().equals(
					Const.TEST_ANNOTATION)) {
				listRewrite.insertFirst(newAnno, null);
				return;
			}

			// only @decisiontableName
			if (annos.get(0).getTypeName().getFullyQualifiedName().equals(
					decisionTable.getName())) {
				listRewrite.insertAfter(newAnno, annos.get(0), null);
				return;
			}
		}

		String conditionAnno = decisionTable.getName() + "."
				+ Const.CONDITION_TAG;
		String actionAnno = decisionTable.getName() + "." + Const.ACTION_TAG;

		String newAnnoName = newAnno.getTypeName().getFullyQualifiedName();

		for (MarkerAnnotation anno : annos) {

			String annoName = anno.getTypeName().getFullyQualifiedName();

			// If this annotation is @decisiontableName, skip.
			if (annoName.equals(decisionTable.getName())) {
				continue;
			}

			// For put conditions annotation before actions annotation.
			if (annoName.startsWith(conditionAnno)
					&& newAnnoName.startsWith(actionAnno)) {
				continue;
			}

			// For put some annotation before @Test
			if (annoName.equals(Const.TEST_ANNOTATION)) {
				listRewrite.insertBefore(newAnno, anno, null);
				return;
			}

			if (newAnnoName.compareTo(annoName) < 0) {
				listRewrite.insertBefore(newAnno, anno, null);
				return;
			}

			if (newAnnoName.compareTo(annoName) > 0) {
				listRewrite.insertAfter(newAnno, anno, null);
				return;
			}
		}
	}
}
