﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// GetYahoo抽象クラス
    /// </summary>
    public abstract class AbstractGetYahoo
    {
        /// <summary>
        /// CurrentContext
        /// </summary>
        protected CurrentContext context = null;
        /// <summary>
        /// 画面左下のコンソール
        /// </summary>
        protected TextBox console = null;
        /// <summary>
        /// ステータスバー
        /// </summary>
        protected StatusStrip console2 = null;
        /// <summary>
        /// EDINETリスト
        /// </summary>
        protected Hashtable edinetlist;
        /// <summary>
        /// ブラウザコントロール
        /// </summary>
        protected WebBrowserController ndbControl = null;
        /// <summary>
        /// 1画面辺りのタイトル数
        /// </summary>
        protected int displayRows = 0;
        /// <summary>
        /// ヤフー掲示板の個別銘柄として正しいコードであるか検証する。
        /// </summary>
        public bool isValidYahooCode = false;
        /// <summary>
        /// 返信用のURLを取得する。
        /// </summary>
        /// <param name="mid">メッセージID</param>
        /// <returns>返信用URL</returns>
        abstract public string GetReplyUrl(string mid);
        /// <summary>
        /// 旧ヤフー掲示板のスレッド表示用のURLを取得する
        /// ※textreamでは廃止
        /// </summary>
        /// <param name="mid">メッセージID</param>
        /// <returns>スレッド表示用のURL</returns>
        abstract public string GetThreadUrl(string mid);
        /// <summary>
        /// 6か月表示のチャートURLを取得する
        /// </summary>
        /// <returns>6か月表示のチャートURL</returns>
        abstract public string GetHalfYearChartUrl();
        /// <summary>
        /// ニュース表示用のURLを取得する
        /// </summary>
        /// <returns>ニュース表示用URL</returns>
        abstract public string GetNewsUrl();
        /// <summary>
        /// 「ニュースコラム」検索用のURLを取得する
        /// </summary>
        /// <returns>ニュースコラム検索用のURL</returns>
        abstract public string GetColum();
        /// <summary>
        /// 企業情報用のURLを取得する
        /// </summary>
        /// <returns>企業情報用のURL</returns>
        abstract public string GetCompanyInfo();
        /// <summary>
        /// ヤフー掲示板日次ランキング用のURLを取得する
        /// </summary>
        /// <returns>日次ランキング用のURL</returns>
        abstract public string GetDailyRankingUrl();
        /// <summary>
        /// ヤフー掲示板週次ランキング用のURLを取得する
        /// </summary>
        /// <returns>週次ランキング用のURL</returns>
        abstract public string GetWeeklyRankingUrl();
        /// <summary>
        /// ヤフー掲示板月次ランキング用のURLを取得する
        /// </summary>
        /// <returns>月次ランキング用のURL</returns>
        abstract public string GetMonthlyRankingUrl();
        /// <summary>
        /// 個別銘柄アクセス用の最初のURLを取得する
        /// </summary>
        /// <returns>個別銘柄アクセス用の最初のURL</returns>
        abstract public string GetBaseUrl();
        /// <summary>
        /// 個別のメッセージ用のURLを取得する
        /// </summary>
        /// <param name="mid">メッセージID</param>
        /// <returns>個別のメッセージ用のURL</returns>
        abstract public string GetMassageUrl(string mid);
        /// <summary>
        /// 「他の投稿を検索」用のURLを取得する
        /// </summary>
        /// <param name="sender">投稿者ID</param>
        /// <returns>「他の投稿を検索」用のURL</returns>
        abstract public string GetMessageListFromUserId(string sender);
        /// <summary>
        /// 返信用のURLを取得する。
        /// </summary>
        /// <returns>返信用のURL</returns>
        abstract public string GetPostedSelf() ;
        /// <summary>
        ///　適切なヤフー掲示板のコードであるかチェックする。
        /// </summary>
        /// <param name="code">銘柄コード</param>
        /// <returns>エラーページの場合は-1を戻す</returns>
        abstract public bool IsValidYahooCode(string code);
        /// <summary>
        /// チャート描画に必要なURLを取得する
        /// </summary>
        /// <param name="webBrowser1">WebBrowserオブジェクト</param>
        /// <returns></returns>
        abstract public string GetChartHtml(WebBrowser webBrowser1);
        /// <summary>
        ///  Yahoo掲示板のTopic ID (&amp;tid=xxxxxxx部分)を取得する.
        ///  この値は変則で、単に銘柄コード(ex.2432)もあれば、ランダム？(8136 -> a55a5sa5jaaa) 
        ///  パターンもある。
        ///  ※textreamの場合はどこからTIDを取ってくればいいのかわからない！
        ///  　とりあえず、固定値を使用する。
        ///  　存在しない場合は銘柄コードをそのまま返す。
        /// </summary>
        /// <param name="code">銘柄コード</param>
        /// <returns>トピックID</returns>
        abstract public string GetTid(string code);
        /// <summary>
        /// 1画面に表示するタイトルリストの長さを取得する。
        /// ※旧掲示板40件、Textream20件。
        /// </summary>
        /// <returns>1画面辺りのタイトルリスト数</returns>
        abstract public uint GetDisplayRows();
        /// <summary>
        /// URLナビゲートに必要以外のその他の情報を取得する。
        /// 旧掲示板：CLOSE,CHANGE等。
        /// 新掲示板：あまり取得するものはない。
        /// </summary>
        /// <param name="code">銘柄コード</param>
        /// <param name="doc">DOMオブジェクト</param>
        abstract public void GetOtherInfo(string code, HtmlDocument doc);
        /// <summary>
        /// 取得済みの最新メッセージIDを取得する。
        /// </summary>
        /// <param name="doc">DOMオブジェクト</param>
        /// <param name="isCheckLock"></param>
        /// <returns></returns>
        abstract public int GetMaxTitleNo(HtmlDocument doc, bool isCheckLock);
        /// <summary>
        /// 旧ヤフー掲示板のsidを取得する。
        /// &amp;sid=xxxxxxx部分
        /// </summary>
        /// <param name="code">銘柄コード</param>
        /// <returns>Sid※旧Yahoo掲示板のみ使用</returns>
        abstract public string GetSid(string code);
        /// <summary>
        /// 旧yahoo掲示板 board IDを取得する。
        /// &amp;board=xxxxxxx部分
        /// </summary>
        /// <param name="code">銘柄コード</param>
        /// <returns>Board※旧Yahoo掲示板のみ使用</returns>
        abstract public string GetBoard(string code);
        /// <summary>
        /// 引数のURLのメッセージコンテンツを取得する。 
        /// textream:コンテンツの内容はあらかじめ取得している事。
        /// </summary>
        /// <param name="mid">メッセージID</param>
        /// <returns>メッセージ内容</returns>
        abstract public string GetContents(string mid);
        /// <summary>
        /// タイトル一覧を取得する
        /// </summary>
        /// <param name="longCode">銘柄コード</param>
        /// <param name="pageNo"></param>
        abstract public void GetTitleLists(string longCode, int pageNo);
        ///<summary>
        /// HTMLから投稿タイトル一覧を全部取得してファイルに保存する
        ///</summary>
        abstract public void SaveAllTitleList(string code);
        /// <summary>
        /// 引数のドキュメントが正常なヤフー掲示板サイトならtrueを戻す
        /// </summary>
        /// <param name="doc">DOMオブジェクト</param>
        /// <returns></returns>
        abstract public bool IsValidUrl(HtmlDocument doc);

    }
}
