﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Threading;
using System.Xml;
using System.Collections;
using System.Diagnostics;

namespace カブラウザもどき
{
    /// <summary>
    /// メインフォーム。
    /// このアプリケーションの実行には.NET Framework 3.5が必要です。
    /// http://www.microsoft.com/downloads/ja-jp/details.aspx?displaylang=ja&FamilyID=0a391abd-25c1-4fc0-919f-b21f31ab88b7
    /// </summary>
    public partial class Form1 : Form 
    {
        #region クラス変数
        /// <summary>
        /// このアプリ内の改行文字
        /// </summary>
        public const string csCrLf = "\r\n";
        /// <summary>
        /// タイトル一覧（xxxx.dat）ファイルの格納場所
        /// </summary>
        public const string csDatDir = @".\Logs\kabu\";  // datファイル格納
        /// <summary>
        /// 無視リスト一覧
        /// </summary>
        public const string csNGFile = @".\NGName.txt";  // 無視リスト
        /// <summary>
        /// カブラウザのコード一覧（code.lst）の場所
        /// </summary>
        public const string csCDFile = @".\code.lst";
        /// <summary>
        /// カブラウザのコード一覧（edinet.lst）の場所
        /// </summary>
        public const string csEDIFile = @".\edinet.lst";
        /// <summary>
        /// 初期設定ファイル（殆ど空）
        /// </summary>
        public const string csIniFile = @".\kabu.ini";
        /// <summary>
        /// 既読リスト
        /// </summary>
        public const string csSaveFile = @".\Logs\save.dat";
        /// <summary>
        /// EDINET確認書類
        /// </summary>
        public string needEdinetDoc = ""; 
        /// <summary>
        /// 動作モード（上級/一般）
        /// </summary>
        public int execMode = 0;
        private uint displayRows;
        // 2013.2.24 textream対応 start
        //private GetYahoo yahoo;
        private AbstractGetYahoo yahoo;
        // 2013.2.24 textream対応 end
        private KVisited visited = new KVisited();

        private static CurrentContext context = null;     // 表示中の銘柄を管理する構造体(このアプリの肝)
        /// <summary>
        ///  EDINETコードリスト
        /// </summary>
        private Hashtable edinetlist = new Hashtable(); 
        private Hashtable ignorelist = new Hashtable();   // 無視リスト
        private Hashtable emphasislist = new Hashtable(); // ignorelistと同じ（灰色表示に使う）
        private Hashtable markline = new Hashtable();   // ここまで読んだ
        /// <summary>
        /// datファイルの区切り文字(絶対に使用されていない文字)
        /// </summary>
        public static char delimiter = char.Parse(Char.ConvertFromUtf32(128));
        private static char tvdelimiter = '　';          // TreeViewに表示した銘柄のコードと銘柄名称の区切り文字
        private static NonDispBrowser ndb = null;        // 裏で動く非表示のブラウザ(ActiveX制御あり)
        private WebBrowserController ndbControl = null;
        private string usedSkin = "";

        private enum ImageList  // アイコンリスト
        {
            CloseFolder = 0, OpenFolder = 1, File = 2, Search = 3, Note = 4, Reply = 5, AllGet = 6,
            DailyRank = 7, WeeklyRank = 8, MonthlyRank = 9, TextSearch = 10, NGOn = 11, NGOff = 12
        };

        private enum ImageListSub  // アイコンリスト
        {
            Short = 0, Think = 1, Timely = 2, News = 3, Edinet= 4, Setting = 5,
            Back = 6, Ahead = 7
        };

        private Hashtable ColorList = new Hashtable(); // このシステムの色リスト

        private SettingForm child = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Form1()
        {
            InitializeComponent();
        }

        #endregion

        #region 初期化

        /**
         * 
         * Formを初期化する
         * 
         */
        private void Form1_Load(object sender, EventArgs e)
        {
            this.Text = "カブラウザもどき";

            // メッセージ
            this.textBox2.AppendText("( ･∀･)ﾉ > きどうちゅうθ" + csCrLf);

            // メニューの初期化
            MenuInit();

            // kabu.iniファイル読込み
            //if (!LoadIniFile()) return ;
            LoadIniFile();

            // ツールストリップ初期化
            ToolStripInit();

            // リストビュー初期化
            ListViewInit();

            // TreeView初期化
            this.treeView1.Nodes.Clear();
            this.treeView1.ImageList = imageList1;
            LoadCodeList();
            this.treeView1.AllowDrop = true;
            this.treeView1.LabelEdit = true;
            // ダミーを最低1つはぶら下げる
            if (this.treeView1.Nodes.Count == 0)
            {
                TreeNode tn = new TreeNode("フォルダ１");
                tn.Name = "フォルダ１";
                tn.ImageIndex = (int)ImageList.CloseFolder;
                this.treeView1.Nodes.Add(tn);
            }

            // EDINETコード読込み
            LoadEDIList();

            // TextBox関連
            this.textBox3.Enabled = false;
            this.textBox4.Enabled = false;

            //CurrentContextをインスタンス化
            context = new CurrentContext();
            context.SetEdinetList(edinetlist);

            // WEBブラウザ
            ndb = new NonDispBrowser(this.statusStrip1);
            ndbControl = new WebBrowserController(ndb);

            // Yahoo掲示板クラスをインスタンス化
            yahoo = new GetYahooTextream(context, this.textBox2, this.statusStrip1, ndbControl, edinetlist);
            this.displayRows = yahoo.GetDisplayRows();

            context.SetSkin(new YahooSkin(this.usedSkin));

            return;
        }

        private void SwitchBrowseAndNavigate(string url)
        {
            this.webBrowser2.Visible = false;
            this.webBrowser1.Visible = true;
            this.webBrowser1.NavigateAndWait(url);
        }

        /// <summary>
        /// StripMenuを初期化する
        /// </summary>
        private void MenuInit()
        {
            //  ListViewに表示するメニュー
            ContextMenuStrip menu_listview = new ContextMenuStrip();
            ToolStripMenuItem menu_listview_1 = new ToolStripMenuItem();
//            ToolStripMenuItem menu_listview_2 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_3 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_4 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_5 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_6 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_7 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_8 = new ToolStripMenuItem();
            ToolStripMenuItem menu_listview_9 = new ToolStripMenuItem();

            menu_listview_1.Text = "返信";
            menu_listview_1.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].Text;
                    SwitchBrowseAndNavigate(yahoo.GetReplyUrl(mid));
                }
            };
/* 2013.2.24 textream対応 start 
 * スレッド表示は廃止
            menu_listview_2.Text = "スレッドを表示";
            menu_listview_2.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    SwitchBrowseAndNavigate(yahoo.GetThreadUrl(mid));
                }
            };
 */

            menu_listview_3.Text = "前のページを表示";
            menu_listview_3.Click += delegate
            {
                // 2013/2/24 textream対応 start
                //GetTitleListsFromHtml(context.GetCode(), -1);
                yahoo.GetTitleLists(context.GetCode(), -1);
                // 2013/2/24 textream対応 end
                RedisplayListView();
            };

            menu_listview_4.Text = "次のページを表示";
            menu_listview_4.Click += delegate
            {
                // 2013/2/24 textream対応 start
                //GetTitleListsFromHtml(context.GetCode(), 1);
                yahoo.GetTitleLists(context.GetCode(), 1);
                // 2013/2/24 textream対応 end
                RedisplayListView();
            };

            menu_listview_5.Text = "無視リストに入れる";
            menu_listview_5.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string tmpSender = listView1.SelectedItems[0].SubItems[2].Text;
                    InsertNGName(tmpSender);
                    LoadNGName();
                    this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOn;
                    RedisplayListView();
                }
            };

            menu_listview_6.Text = "無視リストから消去する";
            menu_listview_6.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string tmpSender = listView1.SelectedItems[0].SubItems[2].Text;
                    RemoveNGName(tmpSender);
                    RedisplayListView();
                }
            };

            menu_listview_7.Text = "ブラウザで表示する";
            menu_listview_7.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    // 2013/2/24 textream 対応 start
                    //string url = "http://messages.yahoo.co.jp/bbs?.mm=FN&action=m&board=" + context.GetPad() + context.GetCode() + "&tid=" + context.GetTid() + "&sid=" + context.GetPad() + context.GetCode() + "&mid=" + mid;
                    string url = "http://textream.yahoo.co.jp/message/" + context.GetBoard() + "/" + context.GetTid();
                    // 2013/2/24 textream 対応 end
                    Process.Start("IExplore.exe", url);
                }
            };

            menu_listview_8.Text = "ここまで読んだ";
            menu_listview_8.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0)
                {
                    string mid = listView1.SelectedItems[0].SubItems[0].Text;
                    markline[context.GetCode()] = mid;
                    listView1.SelectedItems[0].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[1].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[2].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[3].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[4].BackColor = Color.LightPink;
                    listView1.SelectedItems[0].SubItems[5].BackColor = Color.LightPink;
                }
            };

            menu_listview_9.Text = "他の投稿を検索する";
            menu_listview_9.Click += delegate
            {
                if (listView1.SelectedItems != null && listView1.SelectedItems.Count > 0) {

                    string mid = listView1.SelectedItems[0].Text;
                    //DisplaySelectedContents();
                    this.statusStrip1.ContextMenuStrip.Text = context.GetSkin().get("&M_FINDMSG");
                    if (context.GetSkin().get("&M_FINDMSG") != "") {
                        SwitchBrowseAndNavigate(context.GetSkin().get("&M_FINDMSG"));
                    } else {
                        MessageBox.Show("URLが取得できませんでした。");
                    }
                }
            };
            menu_listview.Items.Add(menu_listview_1);
//            menu_listview.Items.Add(menu_listview_2);
            menu_listview.Items.Add(menu_listview_3);
            menu_listview.Items.Add(menu_listview_4);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_5);
            menu_listview.Items.Add(menu_listview_6);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_8);
            menu_listview.Items.Add("-");
            menu_listview.Items.Add(menu_listview_7);
            menu_listview.Items.Add(menu_listview_9);

            //  TreeViewに表示するメニュー
            ContextMenuStrip menu_on_company = new ContextMenuStrip();
            ContextMenuStrip menu_on_folder = new ContextMenuStrip();
            ToolStripMenuItem menuCP1 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP2 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP3 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP4 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP5 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP6 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP7 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP8 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP9 = new ToolStripMenuItem();


            ToolStripMenuItem menuCP10 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP11 = new ToolStripMenuItem();
            ToolStripMenuItem menuCP12 = new ToolStripMenuItem();

            menuCP1.Text = "銘柄コード作成";
            menuCP2.Text = "削除";
            menuCP2.Click += delegate
            {

                if (MessageBox.Show("削除しますがよろしいですか？",
                    "確認",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2) == DialogResult.Yes)
                {
                    TreeNode tn = treeView1.SelectedNode;
                    tn.Remove();
                }
            };
            menuCP3.Text = "フォルダ作成";
            menuCP3.Click += delegate
            {
                TreeNode tn = new TreeNode();
                treeView1.Nodes.Add(tn);
                treeView1.SelectedNode = tn;
                treeView1.Focus();
                if (treeView1.SelectedNode != null)
                {
                    treeView1.LabelEdit = true;
                    treeView1.SelectedNode.BeginEdit();
                }
            };
            menuCP4.Text = "チャート表示";
            menuCP4.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    SwitchBrowseAndNavigate(yahoo.GetHalfYearChartUrl());
                }
            };
            menuCP5.Text = "ニュース表示";
            menuCP5.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    SwitchBrowseAndNavigate(yahoo.GetNewsUrl());
                }
            };
            menuCP6.Text = "企業情報を表示";
            menuCP6.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = treeView1.SelectedNode.Name;
                    SwitchBrowseAndNavigate(yahoo.GetCompanyInfo());
                }
            };

            menuCP7.Text = "保存する";
            menuCP7.Click += delegate
            {
                SaveCodeList();
                MessageBox.Show("code.lstに保存しました。");
            };

            menuCP8.Text = "ブラウザで表示する";
            menuCP8.Click += delegate
            {
                if (treeView1.SelectedNode != null && treeView1.SelectedNode.ImageIndex == (int)ImageList.File && treeView1.SelectedNode.Name.Length >= 4)
                {
                    string code = this.treeView1.SelectedNode.Name;
                    // 2013/2/24 textream対応 start
                    //string url = "http://messages.yahoo.co.jp/bbs?action=topics&board=" + context.GetPad() + code + "&sid=" + context.GetSid() + code + "";
                    string url = "http://textream.yahoo.co.jp/message/" + context.GetBoard() + "/" + context.GetTid() ;
                    // 2013/2/24 textream対応 end
                    Process.Start("IExplore.exe", url);
                }
            };

            menuCP9.Text = "編集";
            menuCP9.Click += delegate
            {
                TreeNode tn = treeView1.SelectedNode;
                treeView1.LabelEdit = true;
                if (tn != null && treeView1.LabelEdit )
                {
                    tn.BeginEdit();
                }
            };

            menuCP10.Text = "全て展開する";
            menuCP10.Click += delegate
            {
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Parent == null) tn.Expand();
                }
            };

            menuCP11.Text = "全て閉じる";
            menuCP11.Click += delegate
            {
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Parent == null) tn.Collapse();
                }
            };

            menuCP12.Text = "自分の投稿";
            menuCP12.Click += delegate
            {
                string url = yahoo.GetPostedSelf();
                Process.Start("IExplore.exe", url);
            };

            menu_on_folder.Items.Add(menuCP1);
            menu_on_folder.Items.Add(menuCP2);

            menu_on_company.Items.Add(menuCP4);
            menu_on_company.Items.Add(menuCP5);
            menu_on_company.Items.Add(menuCP6);
            menu_on_company.Items.Add(menuCP8);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP3);
            menu_on_company.Items.Add(menuCP2);
            menu_on_company.Items.Add(menuCP9);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP10);
            menu_on_company.Items.Add(menuCP11);
            menu_on_company.Items.Add(menuCP7);

            menu_on_company.Items.Add("-");
            menu_on_company.Items.Add(menuCP12);


            ContextMenuStrip menu_on_status = new ContextMenuStrip();
            ToolStripMenuItem menuST1 = new ToolStripMenuItem();
            menuST1.Text = "URLをコピーする";
            menuST1.Click += delegate
            {
                Clipboard.SetText(this.toolStripStatusLabel1.Text);
            };
            menu_on_status.Items.Add(menuST1);

            this.contextMenuStrip1 = menu_on_company;
            this.contextMenuStrip2 = menu_listview;
            this.contextMenuStrip3 = menu_on_folder;
            this.contextMenuStrip4 = menu_on_status;
            this.treeView1.ContextMenuStrip = menu_on_company;
            this.listView1.ContextMenuStrip = menu_listview;
            this.statusStrip1.ContextMenuStrip = menu_on_status;

            return;
        }


        /// <summary>
        /// ToolStripを初期化する
        /// </summary>
        private void ToolStripInit()
        {
            // 
            // toolStripButton1
            //
            ToolStripButton toolStripButton1 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Left;
            toolStripButton1.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton1.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            toolStripButton1.ImageIndex = (int)ImageList.Search;
            toolStripButton1.Name = "toolStripButton1";
            toolStripButton1.Text = "検索";
            toolStripButton1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            toolStripButton1.Click += new System.EventHandler(this.toolStripButton1_Click);
            // 
            // toolStripButton2
            // 
            ToolStripButton toolStripButton2 = new System.Windows.Forms.ToolStripButton();
            toolStripButton2.Alignment = ToolStripItemAlignment.Right;
            toolStripButton2.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton2.ImageIndex = (int)ImageList.Note;
            toolStripButton2.Name = "toolStripButton2";
            toolStripButton2.Text = "書込";
            toolStripButton2.Click += new System.EventHandler(this.toolStripButton2_Click);
            // 
            // toolStripButton3
            // 
            ToolStripButton toolStripButton3 = new System.Windows.Forms.ToolStripButton();
            toolStripButton3.Alignment = ToolStripItemAlignment.Right;
            toolStripButton3.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton3.ImageIndex = (int)ImageList.Reply;
            toolStripButton3.Name = "toolStripButton3";
            toolStripButton3.Text = "返信";
            toolStripButton3.Click += new System.EventHandler(this.toolStripButton3_Click);
            // 
            // toolStripButton4
            // 
            ToolStripButton toolStripButton4 = new System.Windows.Forms.ToolStripButton();
            toolStripButton4.Alignment = ToolStripItemAlignment.Right;
            toolStripButton4.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton4.ImageIndex = (int)ImageList.TextSearch;
            toolStripButton4.Name = "toolStripButton4";
            toolStripButton4.Text = "全文検索";
            toolStripButton4.Click += new System.EventHandler(this.toolStripButton4_Click);

            // 
            // toolStripButton5
            // 
            ToolStripButton toolStripButton5 = new System.Windows.Forms.ToolStripButton();
            toolStripButton5.Alignment = ToolStripItemAlignment.Right;
            toolStripButton5.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton5.ImageIndex = (int)ImageList.AllGet;
            toolStripButton5.Name = "toolStripButton5";
            toolStripButton5.Text = "全タイトル取得";
            toolStripButton5.Click += new System.EventHandler(this.toolStripButton5_Click);

            // 
            // toolStripButton6
            // 
            ToolStripButton toolStripButton6 = new System.Windows.Forms.ToolStripButton();
            toolStripButton6.Alignment = ToolStripItemAlignment.Right;
            toolStripButton6.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton6.ImageIndex = (int)ImageList.DailyRank;
            toolStripButton6.Name = "toolStripButton6";
            toolStripButton6.Text = "日次ランキング";
            toolStripButton6.Click += new System.EventHandler(this.toolStripButton6_Click);
            // 
            // toolStripButton7
            // 
            ToolStripButton toolStripButton7 = new System.Windows.Forms.ToolStripButton();
            toolStripButton7.Alignment = ToolStripItemAlignment.Right;
            toolStripButton7.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton7.ImageIndex = (int)ImageList.WeeklyRank;
            toolStripButton7.Name = "toolStripButton7";
            toolStripButton7.Text = "週次ランキング";
            toolStripButton7.Click += new System.EventHandler(this.toolStripButton7_Click);
            // 
            // toolStripButton8
            // 
            ToolStripButton toolStripButton8 = new System.Windows.Forms.ToolStripButton();
            toolStripButton8.Alignment = ToolStripItemAlignment.Right;
            toolStripButton8.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton8.ImageIndex = (int)ImageList.MonthlyRank;
            toolStripButton8.Name = "toolStripButton8";
            toolStripButton8.Text = "月次ランキング";
            toolStripButton8.Click += new System.EventHandler(this.toolStripButton8_Click);

            // 
            // toolStripButton9
            // 
            ToolStripButton toolStripButton9 = new System.Windows.Forms.ToolStripButton();
            toolStripButton9.Alignment = ToolStripItemAlignment.Right;
            toolStripButton9.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton9.ImageIndex = (int)ImageList.NGOn;
            toolStripButton9.Name = "toolStripButton9";
            toolStripButton9.Text = "無視リストの表示を切替";
            toolStripButton9.Click += new System.EventHandler(this.toolStripButton9_Click);

            // 
            // toolStripButton10
            // 
            ToolStripButton toolStripButton10 = new System.Windows.Forms.ToolStripButton();
            toolStripButton10.Alignment = ToolStripItemAlignment.Right;
            toolStripButton10.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton10.ImageIndex = (int)ImageListSub.Short;
            toolStripButton10.Name = "toolStripButton10";
            toolStripButton10.Text = "空売り残高を表示";
            toolStripButton10.Click += new System.EventHandler(this.toolStripButton10_Click);

            // 
            // toolStripButton11
            // 
            ToolStripButton toolStripButton11 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Right;
            toolStripButton11.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton11.ImageIndex = (int)ImageListSub.Think;
            toolStripButton11.Name = "toolStripButton11";
            toolStripButton11.Text = "考える株式投資";
            toolStripButton11.Click += new System.EventHandler(this.toolStripButton11_Click);

            // 
            // toolStripButton12
            // 
            ToolStripButton toolStripButton12 = new System.Windows.Forms.ToolStripButton();
            toolStripButton1.Alignment = ToolStripItemAlignment.Right;
            toolStripButton12.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton12.ImageIndex = (int)ImageListSub.Timely;
            toolStripButton12.Name = "toolStripButton12";
            toolStripButton12.Text = "東証適時開示システム";
            toolStripButton12.Click += new System.EventHandler(this.toolStripButton12_Click);

            // 
            // toolStripButton13
            // 
            ToolStripButton toolStripButton13 = new System.Windows.Forms.ToolStripButton();
            toolStripButton13.Alignment = ToolStripItemAlignment.Right;
            toolStripButton13.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton13.ImageIndex = (int)ImageListSub.News;
            toolStripButton13.Name = "toolStripButton13";
            toolStripButton13.Text = "Yahooニュース検索";
            toolStripButton13.Click += new System.EventHandler(this.toolStripButton13_Click);

            // 
            // toolStripButton14
            // 
            ToolStripButton toolStripButton14 = new System.Windows.Forms.ToolStripButton();
            toolStripButton14.Alignment = ToolStripItemAlignment.Right;
            toolStripButton14.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton14.ImageIndex = (int)ImageListSub.Edinet;
            toolStripButton14.Name = "toolStripButton14";
            toolStripButton14.Text = "EDINET";
            toolStripButton14.Click += new System.EventHandler(this.toolStripButton14_Click);

            // 
            // toolStripButton15
            // 
            ToolStripButton toolStripButton15 = new System.Windows.Forms.ToolStripButton();
            toolStripButton15.Alignment = ToolStripItemAlignment.Right;
            toolStripButton15.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton15.ImageIndex = (int)ImageListSub.Setting;
            toolStripButton15.Name = "toolStripButton15";
            toolStripButton15.Text = "設定";
            toolStripButton15.Click += new System.EventHandler(this.toolStripButton15_Click);

            // 
            // toolStripButton16
            // 
            ToolStripButton toolStripButton16 = new System.Windows.Forms.ToolStripButton();
            toolStripButton16.Alignment = ToolStripItemAlignment.Right;
            toolStripButton16.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton16.ImageIndex = (int)ImageListSub.Back;
            toolStripButton16.Name = "toolStripButton16";
            toolStripButton16.Text = "前のページ";
            toolStripButton16.Click += new System.EventHandler(this.toolStripButton16_Click);

            // 
            // toolStripButton17
            // 
            ToolStripButton toolStripButton17 = new System.Windows.Forms.ToolStripButton();
            toolStripButton17.Alignment = ToolStripItemAlignment.Right;
            toolStripButton17.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            toolStripButton17.ImageIndex = (int)ImageListSub.Ahead;
            toolStripButton17.Name = "toolStripButton17";
            toolStripButton17.Text = "次のページ";
            toolStripButton17.Click += new System.EventHandler(this.toolStripButton17_Click);

            this.toolStrip1.ImageList = imageList1;
            toolStrip1.Items.Add(toolStripButton9);
            toolStrip1.Items.Add(toolStripButton8);
            toolStrip1.Items.Add(toolStripButton7);
            toolStrip1.Items.Add(toolStripButton6);
            toolStrip1.Items.Add(toolStripButton5);
            toolStrip1.Items.Add(toolStripButton4);
            toolStrip1.Items.Add(toolStripButton3);
            toolStrip1.Items.Add(toolStripButton2);
            toolStrip1.Items.Add(toolStripButton1);

            //上級モード
            if (execMode == 1) {
                this.toolStrip2.ImageList = imageList2;
                this.toolStrip2.Items.Add(toolStripButton14);
                //this.toolStrip2.Items.Add(toolStripButton13);
                this.toolStrip2.Items.Add(toolStripButton12);
                this.toolStrip2.Items.Add(toolStripButton10);
                this.toolStrip2.Items.Add(toolStripButton11);
                this.toolStrip2.Visible = true;
                this.textBox5.Visible = true;
                this.label4.Visible = true;

            } else {

                this.toolStrip2.Visible = false;
                this.textBox5.Visible = false;
                this.label4.Visible = false;
            }

            
            this.toolStrip3.ImageList = imageList2;
            this.toolStrip3.Items.Add(toolStripButton15);

            this.toolStrip4.ImageList = imageList2;
            this.toolStrip4.Items.Add(toolStripButton17);
            this.toolStrip4.Items.Add(toolStripButton16);

            
        }


        /// <summary>
        /// ListViewを初期化する
        /// </summary>
        private void ListViewInit()
        {
            // **************   ここからListviewの設定
            //一覧表示
            this.listView1.View = View.Details;
            this.listView1.GridLines = true;

            // ヘッダ追加
            this.listView1.Columns.Add("No.", 70, HorizontalAlignment.Left);
            this.listView1.Columns.Add("メッセージ", 300, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿者", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿時の気持ち", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("投稿時間", 150, HorizontalAlignment.Left);
            this.listView1.Columns.Add("", 300, HorizontalAlignment.Left);  // 右端ダミー
            this.listView1.FullRowSelect = true;

            // 無視リスト読込み
            LoadNGName();

            this.ColorList["Visited"] = Color.MediumVioletRed;
            this.ColorList["NonVisited"] = Color.Blue;
            this.ColorList["BackGround"] = Color.Cornsilk;
            this.ColorList["Ignore"] = Color.SlateGray;
        
        }

        #endregion

        # region 設定ファイル

        /// <summary>
        /// iniファイルを読み込む
        /// </summary>
        private bool LoadIniFile()
        {
            StringBuilder sb = new StringBuilder(1024);

            // 動作モード
            this.execMode = (int)IniFileHandler.GetPrivateProfileInt("Application", "ExecMode", 0, csIniFile);

            // タイトルリスト
            //this.displayRows = IniFileHandler.GetPrivateProfileInt("TitleList", "PrefetchRow", 0, csIniFile);

            // skin
            IniFileHandler.GetPrivateProfileString("Application", "Skin", "sample.html", sb, (uint)sb.Capacity, csIniFile);
            usedSkin = sb.ToString();

            // EDINET確認書類
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument1", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + "," ;
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument2", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument3", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument4", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument5", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument6", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument7", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument8", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument9", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument10", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument11", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument12", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument13", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument14", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument15", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument16", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument17", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument18", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument19", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument20", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument21", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument22", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument23", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument24", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument25", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument26", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument27", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument28", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";
            IniFileHandler.GetPrivateProfileString("EDINET", "GetDocument29", "", sb, (uint)sb.Capacity, csIniFile); needEdinetDoc += sb.ToString() + ",";

            // NGName.txt, code.lstファイルチェック
            if (!File.Exists( csNGFile ) && !File.Exists(csCDFile)) {

                if (MessageBox.Show("カレントフォルダにNGName.txtとcode.lstが存在しません。\n\nカブラウザをお使いだった場合は、この２ファイルをコピーして\n再立ち上げして下さい。お使いでない場合は、\n２ファイルを新規に作成します。\n\n作成しますか？",
                    "確認",
                    MessageBoxButtons.YesNo,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2) == DialogResult.Yes) 
                {
                    File.Create(csNGFile).Close();
                    File.Create(csCDFile).Close();
                } else {
                    return false;
                }
            }
            return true;
        }

        /// <summary>
        /// カブラウザの設定ファイルであるcode.lstを読み込んでTreeViewを作成する
        /// </summary>
        public void LoadCodeList()
        {
            string path = csCDFile;
            List<int> expandes = new List<int>(); 

            if (!File.Exists(path)) return;

            this.textBox2.AppendText("( ･∀･)ﾉ > code.lstよみ込み" + csCrLf);
            using (StreamReader sr = new StreamReader(path, Encoding.GetEncoding("Shift_JIS")))
            {
                string contents;
                string line;
                string folder = "";
                string[] column;
                int tnFolderIndex = 0;

                contents = sr.ReadToEnd();
                sr.Close();

                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    column = line.Split('\t');
                    if (column.Length > 1 && column[0] != "" && column[1] != "") {

                        //フォルダ
                        if (column[0] == "1" || column[0] == "0")
                        {
                            tnFolderIndex = AddCompanyCodeList(column[1], "", "", false);
                            if ( column[0] == "1") {
                                expandes.Add(tnFolderIndex);
                            }
                            folder = column[1];
                        } else {

                            AddCompanyCodeList(folder, column[0] + tvdelimiter + column[1], column[0], false);
                        }
                    }
                }
                foreach (int exp in expandes)
                {
                    treeView1.Nodes[exp].Expand();
                }
                expandes = null;
            }
        }


        /// <summary>
        /// 銘柄コードとＥＤＩＮＥＴコードを紐付けるedinet.lstを読み込む
        /// 2013/2/24　拡張 Yahoo掲示板の Board, Tid, Sidをここで持つ
        /// フォーマット:
        ///    code edicode,borad,sid,tid
        /// </summary>
        public void LoadEDIList()
        {
            string path = csEDIFile;
            List<int> expandes = new List<int>();

            if (!File.Exists(path)) return;

            this.textBox2.AppendText("( ･∀･)ﾉ > edinet.lstよみ込み" + csCrLf);
            using (StreamReader sr = new StreamReader(path))
            {
                string contents;
                string line;
                string[] column;

                contents = sr.ReadToEnd();
                sr.Close();

                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null)
                {
                    column = line.Split('\t');
                    if (column.Length > 1 && column[0] != "" && column[1] != "")
                    {
                        edinetlist[column[0]] = column[1];
                    }
                }
            }
        }
        
        /// <summary>
        /// 設定ファイルcode.lstを保存する 
        /// </summary>
        public void SaveCodeList()
        {
            string path = csCDFile;
            this.textBox2.AppendText("( ･∀･)ﾉ > code.lst書き込み" + csCrLf);

            using (StreamWriter sw = new StreamWriter(path, false, System.Text.Encoding.GetEncoding("Shift_JIS")))
            {
                string code = "";
                string name = "";
                foreach (TreeNode tn in treeView1.Nodes)
                {
                    // フォルダの場合は配下の銘柄コードを全て保存
                    if (tn.ImageIndex == (int)ImageList.OpenFolder || tn.ImageIndex == (int)ImageList.CloseFolder)
                    {
                        code = (tn.IsExpanded) ? "1": "0"; 
                        name = tn.Text;
                        sw.WriteLine(code + "\t" + name);

                        // コード＋銘柄名称
                        foreach (TreeNode child in tn.Nodes)
                        {
                            code = child.Name;
                            name = child.Text.Replace(child.Name, "");
                            name = name.Trim();
                            sw.WriteLine(code + "\t" + name);
                        }
                    } else {

                        // 銘柄コードがRootにダイレクトに配置されている
                        string result ;
                        if (IsRegularCode(tn.Name, out result))
                        {
                            code = tn.Name;
                            name = tn.Text.Replace(tn.Name, "");
                            name = name.Trim();
                            sw.WriteLine(code + "\t" + name);
                        }
                    }
                }
                sw.Close();
            }
        }

        #endregion

        # region メニューストリップ

        /// <summary>
        /// senderを無視リストに入れる
        /// </summary>
        /// <param name="sender"></param>
        private void InsertNGName(string sender)
        {
            if (!File.Exists(csNGFile))
            {
                MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }

            using (StreamWriter sw = new StreamWriter( csNGFile, true, Encoding.GetEncoding("Shift_JIS")))
            {  
                sw.WriteLine(sender);
                sw.Close();
            }
        }

        /// <summary>
        /// 無視リストを読み直す
        /// </summary>
        private void LoadNGName()
        {
            if (!File.Exists(csNGFile))
            {
                // MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }
            
            using (StreamReader sr = new StreamReader(csNGFile, Encoding.GetEncoding("Shift_JIS")))
            {
                string igname = "";
                while ((igname = sr.ReadLine()) != null )
                {
                    ignorelist[igname] = igname;
                    emphasislist[igname] = igname;
                }
            }
        }

        /// <summary>
        /// senderを無視リストから外す
        /// </summary>
        /// <param name="sender"></param>
        private void RemoveNGName(string sender)
        {
            StringReader ignores;

            if (!File.Exists(csNGFile))  {
                MessageBox.Show("NGName.txtが存在しません。再度アプリケーションを立ち上げなおして、\nNGName.txtを作成してください。");
                return;
            }

            using (StreamReader sr = new StreamReader(csNGFile, Encoding.GetEncoding("Shift_JIS")))
            {
                ignores = new StringReader(sr.ReadToEnd());
                sr.Close();
            }
            using (StreamWriter sw = new StreamWriter(csNGFile, false, Encoding.GetEncoding("Shift_JIS")))
            {

                string line;
                while ((line = ignores.ReadLine()) != null)
                {
                    if (line != sender)
                    {
                        sw.WriteLine(line);
                    }
                }
                sw.Close();
            }
            emphasislist.Remove(sender);
        }

        #endregion

        #region ツールストリップ

        /// <summary>
        /// 検索ボタン
        /// テキストボックスに入力されたコードをCompanyCodeListペインに追加する
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            string code = this.textBox1.Text.Trim();
            GetTitleList("", code);
        }

        /// <summary>
        /// 掲示板に新規書き込み
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            this.textBox2.AppendText("( ･∀･)ﾉ > 書き込み！　 " + csCrLf);
            // write api url ilke this...
            //http://post.messages.yahoo.co.jp/bbs?.mm=FN&action=r&board=1006255&tid=6255&sid=1006255&mid=0
            string url = "";
            url = context.postUrl;
            toolStripStatusLabel1.Text = url;
            SwitchBrowseAndNavigate(url);
        }

        /// <summary>
        /// 返信 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            if (listView1.SelectedItems.Count > 0)
            {
                string mid = listView1.SelectedItems[0].Text;
                SwitchBrowseAndNavigate(yahoo.GetReplyUrl(mid));
            }
        }

        /// <summary>
        /// 全文検索 ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            if (textBox3.Text.Length == 0)
            {
                MessageBox.Show("検索ワードを入力してください。");
                return;
            }
            DoSearchAllTitles();
        }

        /// <summary>
        /// 全タイトルを取得 ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            if (this.textBox1.Text == "" || this.textBox1.Text.Length != 4)
            {
                MessageBox.Show("テキストボックスに銘柄コードを入力してください");
                return;
            }
            context.SetCode(this.textBox1.Text);
            yahoo.SaveAllTitleList(this.textBox1.Text);
            this.textBox3.Enabled = true;
            this.textBox4.Enabled = true;
            this.toolStripStatusLabel1.Text = "";
        }

        /// <summary>
        ///  ランキング表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_Click(object sender, EventArgs e)
        {
            SwitchBrowseAndNavigate(yahoo.GetDailyRankingUrl());
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - デイリー";
        }

        /// <summary>
        /// ランキング表示（週次）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_Click(object sender, EventArgs e)
        {
            SwitchBrowseAndNavigate(yahoo.GetWeeklyRankingUrl());
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - ウィークリー";
        }

        /// <summary>
        /// ランキング表示（月次）
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton8_Click(object sender, EventArgs e)
        {
            SwitchBrowseAndNavigate(yahoo.GetMonthlyRankingUrl());
            this.Text = "カブラウザもどき - Yahoo!掲示板 - 銘柄別投稿数ランキング - マンスリー";
        }

        /// <summary>
        /// 無視リストを切替
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton9_Click(object sender, EventArgs e)
        {
            if (ignorelist.Count != 0)
            {
                ignorelist = new Hashtable();
                this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOff;

            } else {
                LoadNGName();
                this.toolStrip1.Items[0].ImageIndex = (int)ImageList.NGOn;
            }
            RedisplayListView();
        }

        /// <summary>
        /// 空売り残高を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton10_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            } else {
                SwitchBrowseAndNavigate("http://www.your-alert-service.com/shortselling/" + context.GetCode() + ".html");
                this.toolStripStatusLabel1.Text = "http://www.your-alert-service.com/shortselling/" + context.GetCode() + ".html";
                //GetShortInterest();
            }
        }

        /// <summary>
        /// 考える株式投資を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton11_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
            } else {
                SwitchBrowseAndNavigate("http://g2s.biz/tool/edinet/" + context.GetCode());
            }
        }

        /// <summary>
        /// 東証適時開示システムを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton12_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
                return;
            }
            SwitchBrowseAndNavigate("https://www.release.tdnet.info/index.html");


            HtmlDocument doc = webBrowser1.Document.Window.Frames[0].Document;
            HtmlElementCollection sels = doc.GetElementsByTagName("SELECT");
            if (sels.Count > 0)
            {
                HtmlElement el1 = (HtmlElement)sels[0];
                HtmlElement el2 = (HtmlElement)sels[1];
                string today = DateTime.Now.ToString("yyyyMMdd");
                string before1m = DateTime.Now.AddMonths(-1).AddDays(1).ToString("yyyyMMdd");
                el1.SetAttribute("value", before1m);
                el2.SetAttribute("value", today);
                doc.GetElementById("q").SetAttribute("value", context.GetCode() + "0");
                doc.Forms[0].InvokeMember("submit");
                toolStripStatusLabel1.Text = "https://www.release.tdnet.info/index.html";
            }

            //      doc.DomDocument.frams[0].Document.form1.t0.Value = "20120531"; 

        }

        /// <summary>
        /// Yahooニュースを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton13_Click(object sender, EventArgs e)
        {
            if (context.GetCode() == "")
            {
                MessageBox.Show("銘柄コードを入力してください。");
                return;
            }
            SwitchBrowseAndNavigate(yahoo.GetColum());
            HtmlDocument doc = webBrowser1.Document;
            HtmlElementCollection elms = doc.GetElementsByTagName("LI");
            listView1.Items.Clear();

            string t_tilte = "";
            string t_sender = "";
            string t_pubDate = "";
            bool b_title = false;
            bool b_sender = false;

            foreach (HtmlElement el in elms)
            {

                if (el.GetAttribute("className") == "yjMt ymuiArrow1L")
                {
                    t_tilte = el.InnerText;
                    b_title = true;

                }
                else if (el.GetAttribute("className") == "yjSt marB2 ymuiDate padL10")
                {


                    t_pubDate = el.InnerText;
                    if (el.GetElementsByTagName("A").Count > 0)
                    {
                        t_sender = el.GetElementsByTagName("A")[0].InnerText;
                    }
                    b_sender = true;
                }

                if (b_title && b_sender)
                {
                    ListViewItem item = new ListViewItem();
                    item.Text = "　　　・";
                    item.SubItems.Add(t_tilte);
                    item.SubItems.Add(t_sender);
                    item.SubItems.Add("");
                    item.SubItems.Add(t_pubDate);
                    item.SubItems.Add("");
                    listView1.Items.Add(item);
                    b_title = false;
                    b_sender = false;
                }
            }
            DrawBackgrounColorListView();
            return;
        }

        /// <summary>
        /// EDINETを表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton14_Click(object sender, EventArgs e)
        {
            HtmlDocument doc;
            if (context.GetCode() == "" && this.textBox5.Text == "" )
            {
                MessageBox.Show("銘柄コードを入力してください。");
            }
            else if (edinetlist[this.textBox1.Text] != null)
            {
                // string edi = edinetlist[this.textBox1.Text].ToString();
                string edi = this.textBox5.Text;
                this.webBrowser1.Visible = false;
                this.webBrowser2.Visible = true;
                this.webBrowser2.NavigateAndWait("https://info.edinet-fsa.go.jp/E01EW/BLMainController.jsp?uji.verb=W1E62010YuKaBtn&uji.bean=ee.bean.EEW1E62030IBean&PID=currentPage&TID=W1E62030");
                doc = this.webBrowser2.Document;
                if ( doc != null && doc.Title == "EDINET")
                {
                    string[] targetdoc = needEdinetDoc.Split(',');
                    doc.GetElementById("edinetCode").SetAttribute("value", edi);
                    HtmlElementCollection elms = doc.All.GetElementsByName("documentsKind");
                    for (int i = 0; i < elms[0].All.Count; i++)
                    {
                        for (int j = 0; j < targetdoc.Length; j++)
                        {
                            if (elms[0].All[i].InnerText == targetdoc[j])
                            {
                                elms[0].All[i].SetAttribute("selected", "true");
                            }
                        }
                    }
                    doc.GetElementById("show3").SetAttribute("checked", "true"); // 100件表示
                    HtmlElementCollection buttons = doc.GetElementsByTagName("input");
                    foreach (HtmlElement b in buttons)
                    {
                        if (b.GetAttribute("type") == "button" && b.OuterHtml.IndexOf("検索") != -1)
                        {
                            b.InvokeMember("click");
                        }
                    }

                    Sleep s = new Sleep(1);
                    doc = this.webBrowser2.Document;
                    doc.GetElementById("show3").SetAttribute("checked", "true");  // 100件表示

                    elms = doc.GetElementsByTagName("a");
                    string tmpedi = (string)edinetlist[this.textBox1.Text];
                    tmpedi = tmpedi.Split(',')[0];
                    foreach (HtmlElement a in elms)
                    {
                        if (a.InnerText == tmpedi + " ")
                        {
                            a.InvokeMember("click");
                        }
                    }


                }

                //this.textBox5.Text = edi;
                this.toolStripStatusLabel1.Text = "https://info.edinet-fsa.go.jp/E01EW/BLMainController.jsp?uji.verb=W1E62010YuKaBtn&uji.bean=ee.bean.EEW1E62030IBean&PID=currentPage&TID=W1E62030";

            } else {
                this.textBox5.Text = "";
                MessageBox.Show("EDINETコードが不明でした");
            }
            return;
        }

        /// <summary>
        /// 設定を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton15_Click(object sender, EventArgs e)
        {
            SettingForm sf = new SettingForm(execMode, needEdinetDoc, this);
            this.child = sf;
            //Console.WriteLine(needEdinetDoc);
            sf.needEdinetDoc = needEdinetDoc;
            sf.ShowDialog();
            this.needEdinetDoc = sf.needEdinetDoc;
            //Console.WriteLine(needEdinetDoc);
        }

        /// <summary>
        /// 前の40件を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton16_Click(object sender, EventArgs e)
        {
            // 2013/2/24 textream対応 start
            //GetTitleListsFromHtml(context.GetCode(), -1);
            yahoo.GetTitleLists(context.GetCode(), -1);
            // 2013/2/24 textream対応 end
            RedisplayListView();
        }

        /// <summary>
        /// 次の40件を表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton17_Click(object sender, EventArgs e)
        {
            // 2013/2/24 textream対応 start
            //GetTitleListsFromHtml(context.GetCode(), 1);
            yahoo.GetTitleLists(context.GetCode(), 1);
            // 2013/2/24 textream対応 end
            RedisplayListView();
        }

        #endregion

        #region リストビュー

        /// <summary>
        /// CompanyCodeList(TreeView)ペインにフォルダ、または銘柄コードを加える
        /// folder, short_code, long_code には空でも必ず""(空文字)を渡すこと.
        /// </summary>
        /// <param name="folder"></param>
        /// <param name="long_code">銘柄コード＋銘柄名称( 5214　日本電気硝子 )</param>
        /// <param name="short_code">銘柄コードのみ(例 5214)</param>
        /// <param name="bChkNecessary"></param>
        /// <returns>登録したTreeNodeのIndex。失敗した場合は-1</returns>
        private int AddCompanyCodeList(string folder, string long_code, string short_code, bool bChkNecessary)
        {
            int ret = -1;

            //想定外
            if (folder == null || short_code == null || long_code == null 
                || (folder == "" && short_code == "" && long_code == "")) { return ret; }
            if (short_code == "" )
            {
                short_code = GetRegularCode(long_code);
            }
            
            // 銘柄コードがヤフー掲示板に存在するかチェックする
            if ( bChkNecessary )
            {
                bool isValid;
                isValid = yahoo.IsValidYahooCode(short_code);
                if (isValid && (long_code == "" || long_code == null)) {

                    long_code = short_code + tvdelimiter + context.comapnyName;

                } else {
                    return ret;
                }
            }
            // folderを追加する
            if (folder != "" && short_code == "")
            {
                TreeNode tnFolder = new TreeNode(folder, (int)ImageList.CloseFolder, (int)ImageList.OpenFolder);
                tnFolder.Name = folder;
                ret = treeView1.Nodes.Add(tnFolder);
            }
            // root直下にコードを追加する
            else if (folder == "" && short_code != "")
            {
                try
                {
                    TreeNodeCollection tnc = treeView1.Nodes;
                    if (tnc == null) return -1;
                    bool isNew = true;
                    foreach (TreeNode n in tnc)
                    {
                        // 自ノード調査
                        if (n.Name != null && n.Name == short_code)
                        {
                            //すでに登録済み
                            treeView1.SelectedNode = n;
                            treeView1.Focus();
                            isNew = false;
                            break;
                        }
                        // 子ノード調査
                        foreach (TreeNode child in n.Nodes)
                        {
                            if (child.Name != null && child.Name == short_code)
                            {
                                // すでに追加済み
                                treeView1.SelectedNode = child;
                                treeView1.Focus();
                                isNew = false;
                                break;
                            }
                        }
                        if (!isNew) break;
                    }
                    if (isNew)
                    {
                        // 親ノードを選択させて、ぶら下げる
                        TreeNode tn = new TreeNode(long_code.Trim(), (int)ImageList.File, (int)ImageList.File);
                        tn.Name = short_code;
                        ret = treeView1.Nodes.Add(tn);

                        // ダイアログ
                        /* 銘柄コードを入れる度に一々聞いてくるのはウザったいのでやめる。
                         * 親のいない銘柄コードを警告するのはアプリ終了時で十分。
                        ParentNodeList nodelist =  new ParentNodeList();
                        Hashtable param = new Hashtable();
                        for (int i = 0; i < this.treeView1.Nodes.Count; i++)
                        {
                            if (this.treeView1.Nodes[i].Parent == null && this.treeView1.Nodes[i].ImageIndex != (int)ImageList.File)
                            {
                                param[this.treeView1.Nodes[i].Index] = this.treeView1.Nodes[i].Text;
                            }
                        }
                        nodelist.Show(this.Owner, param);
                        TreeNode target = this.treeView1.Nodes[nodelist.resTnIndex];
                        TreeNode tnclone = (TreeNode)tn.Clone();
                        target.Nodes.Add(tnclone);
                        tn.Remove();
                        this.treeView1.SelectedNode = tnclone;
                        nodelist.Dispose();
                        */
                    }
                    else { ret = 0; }
                    
                }
                catch (NullReferenceException e)
                {
                    this.textBox2.AppendText(folder + "," + long_code + "," + bChkNecessary);
                    this.textBox2.AppendText(e.ToString() + csCrLf);
                }

            }
            // フォルダを指定してコード登録
            else if (folder != "" && short_code != "")
            {
                TreeNodeCollection tnc = treeView1.Nodes;
                TreeNode parent = null;
                foreach (TreeNode n in tnc)
                {
                    if (n.Text == folder)
                    {
                        parent = n;
                        break;
                    }
                }
                TreeNode tnCode = new TreeNode(long_code.Trim(), (int)ImageList.File, (int)ImageList.File);
                tnCode.Name = short_code;
                // 親ノードに追加
                if (parent != null)
                {
                    parent.Nodes.Add(tnCode);
                }
                // 親ノードと一緒に作成
                else
                {
                    TreeNode[] tnCodes = { tnCode } ;
                    TreeNode tnFolder = new TreeNode(folder, tnCodes);
                    ret = treeView1.Nodes.Add(tnFolder);
                }
            }
            return ret;
        }


        /// <summary>
        /// 銘柄コードのロック状態を確認して、タイトル一覧を表示する
        /// 銘柄コードが登録済みでなければ、TreeViewに登録する
        /// 呼び出し側は使わないcodeをnullでは無く、空文字("")で渡すこと
        /// </summary>
        /// <param name="long_code">銘柄コード＋銘柄名称(例 5214　日本電気硝子)
        ///   ※左側ペインのダブルクリック
        /// </param>
        /// <param name="short_code">銘柄コードのみ(例 5214)
        ///   ※銘柄コード入力
        /// </param>
        private void GetTitleList(string long_code, string short_code)
        {
            string chkedcode = null;

            
            this.textBox2.AppendText("( ･∀･)ﾉ > けんさく！　 " + short_code + csCrLf);

            if (short_code == null || long_code == null) return;
            if (short_code == "" && long_code != "")
            {
                short_code = GetRegularCode(long_code);
            }

            if (IsRegularCode(short_code, out chkedcode))
            {
                // TitleListペインを再表示
                listView1.Items.Clear();
                
                // GetTitleLists呼び出し
                yahoo.GetTitleLists(chkedcode, 0);
                if (yahoo.IsValidYahooCode(short_code)) {
                    RedisplayListView();

                    AddCompanyCodeList("", long_code, short_code, true);
                }
            }
        }


        /// <summary>
        /// 投稿タイトル一覧をローカルファイルから取得して配列に格納する.
        /// contextを介さないので直接Form1に実装する。
        /// </summary>
        /// <param name="longCode"></param>
        /// <param name="mid">中心となるMessageIdを指定する（前後20件を表示）</param>
        /// <returns></returns>
        public int GetTitleListsFromLocal(string longCode, string mid)
        {
            if (longCode == "") { return -1; }
            //string code = longCode.Substring(0, 4);
            string code = GetRegularCode(longCode);
            string[] lines = null;
            string line = "";
            int iMid = int.Parse(mid);

            listView1.Items.Clear();
            if (!File.Exists(csDatDir + context.GetCode() + ".dat")) return -1;

            ListViewItem item = new ListViewItem();
            item.Text = "次のページ（ローカル）";  // ローカルから取得する場合は"次のページ（ローカル）"と表示する 
            item.SubItems.Add("");  // title
            item.SubItems.Add("");  // sender
            item.SubItems.Add("");  // pubdate
            item.SubItems.Add("");  // emotion
            item.SubItems.Add("");  // dummy
            listView1.Items.Add(item);

            using (context.topicSr = new StreamReader(csDatDir + context.GetCode() + ".dat")) {
                // 既読リスト
                Hashtable ht = this.visited.GetMessagesHt(context.GetCode());

                while ((line = context.topicSr.ReadLine()) != null) {
                    lines = line.Split(Form1.delimiter);
                    if (iMid > 20 && int.Parse(lines[0]) > (iMid - 20) && int.Parse(lines[0]) < (iMid + 20)) {

                        item = new ListViewItem();
                        item.UseItemStyleForSubItems = false;
                        item.Text = lines[0];  // title id 
                        item.SubItems.Add(lines[1]);  // title
                        item.SubItems.Add(lines[2]);  // sender
                        item.SubItems.Add(lines[3]);  // pubdate
                        item.SubItems.Add(lines[4]);  // emotion
                        item.SubItems.Add("");  // dummy
                        listView1.Items.Add(item);

                        // 未読処理(2)
                        if (ht[lines[0]] == null) {
                            item.SubItems[1].ForeColor = (Color)ColorList["NonVisited"];
                        } else {
                            item.SubItems[1].ForeColor = (Color)ColorList["Visited"];
                        }

                        if (int.Parse(lines[0]) < (iMid - 20)) break;
                    }
                }
                lines = null;
            }

            item = new ListViewItem();
            item.Text = "前のページ（ローカル）";  // ローカルから取得する場合は"前のページ（ローカル）"と表示する 
            item.SubItems.Add("");  // title
            item.SubItems.Add("");  // sender
            item.SubItems.Add("");  // pubdate
            item.SubItems.Add("");  // emotion
            item.SubItems.Add("");  // dummy
            listView1.Items.Add(item);

            DrawBackgrounColorListView();
            return 0;
        }

        /// <summary>
        /// 引数の銘柄コードのタイトル一覧を表示する
        /// </summary>
        /// <param name="e">4ケタの銘柄コード</param>
        private void DisplayTitleList(string code)
        {
            if (code == null || code == "" || code.Length < 4) { return; }
            this.textBox2.AppendText("( ･∀･)ﾉ > 表示するよ！　 " + code + csCrLf);
            int ret = 0;

            // 2013/2/24 textream対応 start
            // GetTitleListsFromHtml(code, 0);
            yahoo.GetTitleLists(code, 0);
            // 2013/2/24 textream対応 end

            //int ret = GetTitleListsFromRSS(code, ref context.t);
            if (ret != -1) {

                this.textBox1.Text = code;

                // TitleListペインを再表示
                listView1.Items.Clear();
                RedisplayListView();

                foreach (TreeNode tn in treeView1.Nodes)
                {
                    if (tn.Name == code)
                    {
                        treeView1.SelectedNode = tn;
                    }
                }
                TextboxConditionChange(code);
            }
        }

        /// <summary>
        /// ListViewで選択されたメッセージを表示する
        /// </summary>
        private void DisplaySelectedContents()
        {
            if (listView1.SelectedItems.Count == 0) { return; }
            string mid = listView1.SelectedItems[0].Text;
            context.selectedTitle = listView1.SelectedItems[0].SubItems[1].Text;        
            switch (mid)
            {
                case "次のページ（ローカル）":
                    mid = listView1.Items[1].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "前のページ（ローカル）":
                    mid = listView1.Items[listView1.Items.Count - 2].Text;
                    GetTitleListsFromLocal(context.GetCode(), mid);
                    break;

                case "次のページ":
                    yahoo.GetTitleLists(mid, 1);
                    RedisplayListView();
                    break;

                case "前のページ":
                    yahoo.GetTitleLists(mid, -1);
                    RedisplayListView();
                    break;

                default:
                    if (listView1.SelectedItems.Count > 0)
                    {
                        listView1.SelectedItems[0].Font = new Font(listView1.SelectedItems[0].Font, FontStyle.Regular);
                        //listView1.SelectedItems[0].ForeColor = (Color)ColorList["Visited"];
                        listView1.SelectedItems[0].SubItems[1].ForeColor = (Color)ColorList["Visited"];
                        // 2013/2/24 textream対応 start
                        //DisplayContents(mid);
                        DisplayContentsFromLocal(mid);
                        // 2013/2/24 textream対応 end
                    }
                    break;
            }
            return;
        }


        /// <summary>
        /// 指定語句による全文検索結果表示
        /// Textream専用
        /// </summary>
        private void DoSearchAllTitles()
        {

            if (context.GetCode() == "") return;
            string contents = "";
            string line = "";
            int iCnt = 0;
            ArrayList contentArray = new ArrayList();
            ArrayList userArray = new ArrayList();
            if (!File.Exists(csDatDir + context.GetCode() + ".dat")) { textBox2.AppendText("(`皿´)> ファイルがねぇ"); return; }

            // 既読リスト
            Hashtable ht = this.visited.GetMessagesHt(context.GetCode());
            using (StreamReader sr = new StreamReader(csDatDir + context.GetCode() + ".dat")) {

                contents = sr.ReadToEnd();
                sr.Close();
                line = "";
                StringReader sr2 = new StringReader(contents);
                while ((line = sr2.ReadLine()) != null) {
                    string[] splittedline;
                    if (line.IndexOf(textBox3.Text) != -1) {
                        if (iCnt == 0) listView1.Items.Clear();
                        splittedline = line.Split(Form1.delimiter);

                        if (splittedline.Length == 7) {
                            ListViewItem item = new ListViewItem();
                            item.UseItemStyleForSubItems = false;
                            item.Text = splittedline[0];  // no
                            item.SubItems.Add(splittedline[1]);  // title
                            item.SubItems.Add(splittedline[2]);  // sender
                            item.SubItems.Add(splittedline[3]);  // pubdate
                            item.SubItems.Add(splittedline[4]);  // emotion
                            item.SubItems.Add("");  // dummy
                            // 未読処理(2)
                            if (ht[splittedline[0]] == null) {
                                item.SubItems[1].ForeColor = (Color)ColorList["NonVisited"];
                            } else {
                                item.SubItems[1].ForeColor = (Color)ColorList["Visited"];
                            }
                            listView1.Items.Add(item);

                            // user
                            userArray.Add(splittedline[5]);

                            // contents
                            contentArray.Add(splittedline[6]);
                            iCnt++;
                        }

                        context.s = new TitleLists[iCnt];
                        iCnt = 0;
                        foreach (ListViewItem item in listView1.Items) {
                            context.s[iCnt] = new TitleLists();
                            context.s[iCnt].titleNo = item.Text;
                            context.s[iCnt].title = item.SubItems[1].Text;
                            context.s[iCnt].sender = item.SubItems[2].Text;
                            context.s[iCnt].sendTime = item.SubItems[3].Text;
                            context.s[iCnt].emotion = item.SubItems[4].Text;

                            context.s[iCnt].userIcon = "http://i.yimg.jp/images/mb/textream/pc/thumb02.png";
                            context.s[iCnt].user = userArray[iCnt].ToString();
                            context.s[iCnt].content = contentArray[iCnt].ToString();
                            iCnt++;
                        }
                    }
                }
                sr2 = null;
            }
            DrawBackgrounColorListView();
            if (iCnt == 0) MessageBox.Show("検索結果が０件でした。");
            context.tFlag = false;
        }

        /// <summary>
        /// 銘柄コードを選択されたタイミングでその銘柄に対するキャッシュデータを
        ///  読み込んでハッシュマップに格納する
        ///  戻り値：-1 ファイル無し
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        private int ReadCache(string code)
        {
            string path = csDatDir + code + ".dat";
            if (!File.Exists(path)) return -1;

            // キャッシュデータフォーマット
            // [titleNo],[Title],[Sender],[upDate],[Emotion],[Status]
            this.textBox2.AppendText("( ･∀･)ﾉ > キャッシュよみ込み" + csCrLf);
            string[] aLine;
            using (StreamReader sr = new StreamReader(path))
            {
                string line;
                while ((line = sr.ReadLine()) != null)
                {
                    aLine = line.Split(Form1.delimiter);
                }
            }
            return 0;
        }

        /// <summary>
        ///  TreeView等に表示された、長いコード(long_code) 
        ///  例）　"1605 国際石油開発帝石", "998407 日経平均株価", "AUDJPY オーストラリアドル"
        ///  (4桁に限定されない)の銘柄コード部分を返す
        /// </summary>
        /// <param name="long_code"></param>
        /// <returns></returns>
        public static string GetRegularCode(string long_code)
        {
            // 正規化された銘柄コード
            string short_code = "";
            char[] delim = { ' ', '\t', tvdelimiter };
            if (long_code.Split(delim).Length > 0)
            {
                short_code = long_code.Split(delim)[0];
            } else {

                if (short_code.Length >= 6)
                {
                    short_code = short_code.Substring(0, 6);
                }
                else if (short_code.Length >= 4)
                {
                    short_code = short_code.Substring(0, 4);
                } else {

                    short_code = long_code;
                }
            }
            return short_code;
        }

        /// <summary>
        /// ListView1のバックグラウンドを偶数行=空色
        /// 奇数行=白に塗る
        /// </summary>
        private void DrawBackgrounColorListView()
        {
            for (int i = 0; i < listView1.Items.Count; i++)
            {
                if (i % 2 == 0)
                {
                    listView1.Items[i].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[1].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[2].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[3].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[4].BackColor = (Color)ColorList["BackGround"];
                    listView1.Items[i].SubItems[5].BackColor = (Color)ColorList["BackGround"];
                } else {

                    listView1.Items[i].BackColor = Color.White;
                    listView1.Items[i].SubItems[1].BackColor = Color.White;
                    listView1.Items[i].SubItems[2].BackColor = Color.White;
                    listView1.Items[i].SubItems[3].BackColor = Color.White;
                    listView1.Items[i].SubItems[4].BackColor = Color.White;
                    listView1.Items[i].SubItems[5].BackColor = Color.White;
                }
                if (markline[context.GetCode()] != null)
                {
                    if (listView1.Items[i].Text == (string)markline[context.GetCode()])
                    {
                        listView1.Items[i].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[1].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[2].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[3].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[4].BackColor = Color.LightPink;
                        listView1.Items[i].SubItems[5].BackColor = Color.LightPink;
                    }
                }
            }
            return;
        }

        /// <summary>
        /// TitleListペインを再描画する
        /// </summary>
        private void RedisplayListView()
        {
            listView1.Items.Clear();
            uint displayRows = 0;
            TitleLists[] t = null;
            
            displayRows = yahoo.GetDisplayRows();

            // 既読リスト
            Hashtable ht = this.visited.GetMessagesHt(context.GetCode());

            // タイトルリスト
            t = context.t;

            //次の40件
            if (context.nextPage != "")
            {
                ListViewItem item = new ListViewItem();
                item.Text = "次のページ";
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");

                listView1.Items.Add(item);
            }

            for (int i = 0; i < displayRows; i++)
            {
                // 無視リスト
                bool isIgnore = false;
                try {
                    if (ignorelist[t[i].sender] == null) {
                        isIgnore = false ;
                    } else isIgnore = true;
                } catch ( NullReferenceException e ) {
                    isIgnore = false;
                }

                if (t[i] != null && t[i].title != "" && !isIgnore)
                {
                    ListViewItem item = new ListViewItem();
                    item.UseItemStyleForSubItems = false;
                    item.Text = t[i].titleNo;
                    item.SubItems.Add(t[i].title);
                    item.SubItems.Add(t[i].sender);
                    item.SubItems.Add(t[i].emotion);
                    item.SubItems.Add(t[i].sendTime);
                    item.SubItems.Add("");
                    
                    // 未読処理(2)
                    if (ht[t[i].titleNo] == null) {
                        item.SubItems[1].ForeColor = (Color)ColorList["NonVisited"];
                        //item.ForeColor = (Color)ColorList["NonVisited"];
                    } else {
                        item.SubItems[1].ForeColor = (Color)ColorList["Visited"];
                        //item.ForeColor = (Color)ColorList["Visited"];
                    }
                    if (emphasislist[t[i].sender] != null)
                    {
                        item.SubItems[0].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[1].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[2].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[3].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[4].ForeColor = (Color)ColorList["Ignore"];
                        item.SubItems[5].ForeColor = (Color)ColorList["Ignore"];
                    }
                    
                    listView1.Items.Add(item);
                }
            }
            //前の40件
            if (context.prevPage != "")
            {
                ListViewItem item = new ListViewItem();
                item.Text = "前のページ";
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                item.SubItems.Add("");
                listView1.Items.Add(item);
            }
            DrawBackgrounColorListView();
            this.Text = "カブラウザもどき - " + context.title + "　" +  context.close + "　" +  context.change;
        }

        /*
         * RSSから投稿タイトル一覧を全部取得してファイルに保存する
         * 最新titleIDからmaxRow分はTitleListsクラスに格納する
         * 
         */
        /*** RSSフィードから過去分の記事を取得する方法が未定。本関数は暫くコメントアウトする
        public void SaveAllTitleListFromRSS(string longCode, ref TitleLists[] t)
        {
            if (longCode == "") { return ; }
            string code = longCode.Substring(0, 4);

            // RSSフィードURLを取得する
            string chkUrl = "http://messages.yahoo.co.jp/bbs?action=topics&board=100" + code + "&sid=100" + code + "";
            string rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=100" + code + "&sid=100" + code + "&tid=" + code;
            ndb.NavigateAndWait(chkUrl);
            HtmlDocument doc = ndb.Document;
            bool breakFlag = false;
            foreach (HtmlElement e in doc.GetElementsByTagName("LINK"))
            {
                string text = e.OuterHtml.Replace("&amp;", "&"); // リンク文字列
                string[] aTmp;
                if (text.IndexOf("rel=alternate") != -1)
                {
                    aTmp = text.Split('&');
                    foreach (string s in aTmp)
                    {
                        if (s.Length > 3 && s.Substring(0, 3) == "tid")
                        {
                            string regularTid = s.Split('=')[1];
                            regularTid = regularTid.Split('"')[0];
                            context.GetTid() = regularTid;
                            rssUrl = "http://messages.yahoo.co.jp/bbs?action=4&board=100" + code + "&sid=100" + code + "&tid=" + context.GetTid();
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }

                }
                if (breakFlag) break;
            }
            ndb = null;
            this.textBox2.AppendText("( ･∀･)ﾉ > ぶっこ抜き！　 " + rssUrl + csCrLf);

            //-----------------------------------------------------------------------------------------
            // URLパターン：
            // Page1: http://messages.yahoo.co.jp/bbs?.mm=FN&action=4&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281236
            // Page2: http://messages.yahoo.co.jp/bbs?.mm=FN&action=4&board=1006758&sid=1006758&tid=a5bda5ka1bc&start=281196
            // 最新のNo.を記憶して、50ずつ減少しながら構造体に格納する
            //-----------------------------------------------------------------------------------------

            // maxTitleNoを取得
        }
         */
        #endregion

        #region 投稿内容取得

        /// <summary>
        /// 引数のコードがYahoo掲示板のコードとして正しいか評価する
        /// 
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        private bool IsRegularCode(string code, out string result) {
            bool ret = false;
            string[] tmp ;

            if (code.IndexOf(tvdelimiter) > 0)
            {
                tmp = code.Split(tvdelimiter);
                result = tmp[0];
            } else {

                result = code;
            }

            if (result.Length < 4 || result.Length > 6)
            {
                result = null;
                ret = false;
            } else {

                if (result.Length == 4)
                {
                    int test;
                    ret = int.TryParse(result, out test);
                    if (!ret)
                    {
                        result = null;
                    }
                } else {

                    ret = true;
                }
            }
            return ret;
        }
        #endregion

        #region イベントハンドラ

        /// <summary>
        /// ListViewダブルクリック イベント制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listView1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            DisplaySelectedContents();
        }

        private void listView1_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter: // enterキー押下
                    DisplaySelectedContents();
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// 指定されたMessageIdをブラウズする
        /// </summary>
        /// <param name="mid"></param>
        private void DisplayContents(string mid)
        {
            // EDINETブラウザが活性状態なら消す
            // (※裏で動かれると鬱陶しい)
            if (this.webBrowser2.DocumentTitle != "empty") {
                this.webBrowser2.DocumentText = "<html><head><title>empty</title></head><body></body></html>";
            }

            // 投稿を表示
            string content = "";

            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = yahoo.GetChartHtml(this.webBrowser1);

            // 投稿内容を取得
            content = yahoo.GetContents(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            //s = GetContentsFromMobileSite(mid);

            // webBrowser1(通常版)に表示を切り替える
            this.webBrowser2.Visible = false;
            this.webBrowser1.Visible = true;

            // 既読リストに入れる
            visited.AddMessage(context.GetCode(), mid);

            // ブラウズするだけ（広告表示）
            //string url = yahoo.GetMassageUrl(mid);
            //webBrowser1.NavigateAndWait(url);

            context.mid = mid;

            // skinを変数で書き換えて表示
            webBrowser1.DocumentText = context.GetSkin().getConvertedHtml();
            this.listView1.Focus();

            return;
        }

        /// <summary>
        /// 指定されたMessageIdをブラウズする
        /// </summary>
        /// <param name="mid"></param>
        private void DisplayContentsFromLocal(string mid)
        {
            // EDINETブラウザが活性状態なら消す
            // (※裏で動かれると鬱陶しい)
            if (this.webBrowser2.DocumentTitle != "empty") {
                this.webBrowser2.DocumentText = "<html><head><title>empty</title></head><body></body></html>";
            }

            // 投稿を表示
            string s = "";

            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = yahoo.GetChartHtml(this.webBrowser1);

            // 投稿内容を取得
            s = yahoo.GetContents(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            //s = GetContentsFromMobileSite(mid);

            // webBrowser1(通常版)に表示を切り替える
            this.webBrowser2.Visible = false;
            this.webBrowser1.Visible = true;

            // 既読リストに入れる
            visited.AddMessage(context.GetCode(), mid);

            // ブラウズするだけ（広告表示）
            //string url = yahoo.GetMassageUrl(mid);
            //webBrowser1.NavigateAndWait(url);

            context.mid = mid;

            // skinを変数で書き換えて表示
            webBrowser1.DocumentText = context.GetSkin().getConvertedHtml();
            this.listView1.Focus();

            return;
        }


        /// <summary>
        /// Skinを変更してMessageIdを再表示する
        /// </summary>
        /// <param name="mid"></param>
        public void ReDisplayContents(string skin)
        {
            // 投稿を表示
            string s = "";
            string mid = "";

            mid = context.mid;
            // 表示するチャート描画
            string chartHtml = "";
            chartHtml = yahoo.GetChartHtml(this.webBrowser1);

            // 投稿内容を取得
            s = yahoo.GetContents(mid);
            toolStripStatusLabel1.Text = yahoo.GetMassageUrl(mid);
            //s = GetContentsFromMobileSite(mid);

            // skinを変数で書き換えて表示
            context.GetSkin().setSkinHtml(@".\skin\" + skin);
            webBrowser1.DocumentText = context.GetSkin().getConvertedHtml();
            this.listView1.Focus();

            return;
        }
        
        /// <summary>
        /// 銘柄コードでキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter:
                    this.textBox1.Text = this.textBox1.Text.Trim();
                    context.Clear();
                    context.tFlag = true;
                    context.SetCode(this.textBox1.Text);
                    GetTitleList("", this.textBox1.Text);
                    
                    TextboxConditionChange(this.textBox1.Text);

                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// メッセージID でキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox4_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch (e.KeyChar)
            {
                case (char)Keys.Enter:
                    if (textBox4.Text != "" && textBox1.Text != "")
                    {
                        GetTitleListsFromLocal(textBox1.Text, textBox4.Text);
                        if (listView1.Items.Count > 19)
                        {
                            listView1.Items[19].Selected = true;
                            listView1.EnsureVisible(listView1.SelectedIndices[0]);
                            listView1.FocusedItem = listView1.SelectedItems[0];
                            listView1.Focus();
                        }
                    }
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        ///  TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_ItemDrag(object sender, ItemDragEventArgs e)
        {
            TreeView tv = (TreeView)sender;
            tv.SelectedNode = (TreeNode)e.Item;
            tv.Focus();
            //ノードのドラッグを開始する
            DragDropEffects dde =
                tv.DoDragDrop(e.Item, DragDropEffects.All);
            //移動した時は、ドラッグしたノードを削除する
            if ((dde & DragDropEffects.Move) == DragDropEffects.Move)
                tv.Nodes.Remove((TreeNode)e.Item);
        }

        /// <summary>
        ///  TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_DragDrop(object sender, DragEventArgs e)
        {
            //ドロップされたデータがTreeNodeか調べる
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                TreeView tv = (TreeView)sender;
                //ドロップされたデータ(TreeNode)を取得
                TreeNode source =
                    (TreeNode)e.Data.GetData(typeof(TreeNode));
                //ドロップ先のTreeNodeを取得する
                TreeNode target =
                    tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                //マウス下のNodeがドロップ先として適切か調べる
                if (target != null && target != source &&
                    IsDruggable(source, target)) {
                    //ドロップされたNodeのコピーを作成
                    TreeNode cln = (TreeNode)source.Clone();
                    //Nodeを追加
                    if (target.Parent != null && source.ImageIndex == (int)ImageList.File) {
                        target.Parent.Nodes.Insert(target.Index, cln);
                    } else if (target.Parent == null && source.ImageIndex == (int)ImageList.File) {
                        target.Nodes.Insert(target.Index, cln);
                    } else if (target.Parent == null) {
                        this.treeView1.Nodes.Insert(target.Index, cln);
                    } else {

                        target.Nodes.Add(cln);
                    }
                    //ドロップ先のNodeを展開
                    target.Expand();
                    //追加されたNodeを選択
                    tv.SelectedNode = cln;
                } else {
                    e.Effect = DragDropEffects.None;
                }
            }
            else
                e.Effect = DragDropEffects.None;
        }

        /// <summary>
        /// あるTreeNodeがDrop先として適切か調べる
        /// </summary>
        /// <param name="source">移動元</param>
        /// <param name="target">移動先</param>
        /// <returns>Drop可能ならTrue</returns>
        private static bool IsDruggable(TreeNode source, TreeNode target)
        {
            if (target.Parent != null && (source.ImageIndex == (int)ImageList.CloseFolder 
                || source.ImageIndex == (int)ImageList.OpenFolder)) return false;  // フォルダを子ノードには追加できない
            if (source.Parent == source) return false; // 自ノードには追加できない
            return true;
        }

        /// <summary>
        /// TreeViewでドラッグ＆ドロップ　制御
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_DragOver(object sender, DragEventArgs e)
        {
            //ドラッグされているデータがTreeNodeか調べる
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                if ((e.KeyState & 8) == 8 &&
                    (e.AllowedEffect & DragDropEffects.Copy) ==
                    DragDropEffects.Copy)
                    //Ctrlキーが押されていればCopy
                    //"8"はCtrlキーを表す
                    e.Effect = DragDropEffects.Copy;
                else if ((e.AllowedEffect & DragDropEffects.Move) ==
                    DragDropEffects.Move)
                    //何も押されていなければMove
                    e.Effect = DragDropEffects.Move;
                else
                    e.Effect = DragDropEffects.None;
            }
            else
                //TreeNodeでなければ受け入れない
                e.Effect = DragDropEffects.None;

            //マウス下のNodeを選択する
            if (e.Effect != DragDropEffects.None)
            {
                TreeView tv = (TreeView)sender;
                //マウスのあるNodeを取得する
                TreeNode target =
                    tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                //ドラッグされているNodeを取得する
                TreeNode source =
                    (TreeNode)e.Data.GetData(typeof(TreeNode));
                //マウス下のNodeがドロップ先として適切か調べる
//                if (target != null && target != source &&
//                        IsDruggable(source, target))
                if (target != null && target != source)
                {
                    //Nodeを選択する
                    if (target.IsSelected == false)
                        tv.SelectedNode = target;
                }
                else
                    e.Effect = DragDropEffects.None;
            }
        }

        /// <summary>
        /// 銘柄コードを変えた場合の制御
        /// </summary>
        /// <param name="code"></param>
        private void TextboxConditionChange(string code)
        {

            if (File.Exists(csDatDir + code + ".dat"))
            {
                this.textBox3.Enabled = true;
                this.textBox4.Enabled = true;
            } else {

                this.textBox3.Text = "";
                this.textBox4.Text = "";
                this.textBox3.Enabled = false;
                this.textBox4.Enabled = false;
            }
            if (edinetlist.ContainsKey(this.textBox1.Text)) {
                this.textBox5.Text = edinetlist[this.textBox1.Text].ToString().Split(',')[0];
            }
            return;
        }

        /// <summary>
        /// TreeViewでキーを押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_KeyUp(object sender, KeyEventArgs e)
        {
            switch (e.KeyCode)
            {
                case Keys.Enter:
                    string short_code = "";
                    context.tFlag = true;
                    if (e == null) { return; }
                    if (!string.IsNullOrEmpty(treeView1.SelectedNode.Name) && treeView1.SelectedNode.Parent != null)
                    {
                        short_code = GetRegularCode(treeView1.SelectedNode.Name);
                        if (yahoo.IsValidYahooCode(short_code)) {
                            DisplayTitleList(short_code);
                        }
                    }
                    break;
                case Keys.F2:
                    TreeNode tn = treeView1.SelectedNode;
                    treeView1.LabelEdit = true;
                    if (tn != null && treeView1.LabelEdit && tn.IsEditing)
                    {
                        tn.BeginEdit();
                    }
                    break;
                case Keys.Delete:
                    TreeNode tntmp = treeView1.SelectedNode;
                    tntmp.Remove();
                    break;
                default:
                    break;
            }
        }

        /// <summary>
        /// TreeViewで選択されたオブジェクトがフォルダか確認する
        /// </summary>
        /// <param name="tn"></param>
        /// <returns></returns>
        private bool IsFolder(TreeNode tn)
        {
            bool ret = false;
            if (tn.Parent == null && (tn.ImageIndex == (int)ImageList.CloseFolder || tn.ImageIndex == (int)ImageList.OpenFolder))
            {
                ret = true;
            }
            return ret;
        }
        /// <summary>
        /// TreeViewでダブルクリック
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_MouseDoubleClick_1(object sender, MouseEventArgs e)
        {
            string short_code = "";
            if (e == null) { return; }
            TreeNode select = treeView1.SelectedNode ;
            // ファイルの場合はタイトル一覧を表示
            if (!string.IsNullOrEmpty(select.Name) && !IsFolder(select) && select.Name.Length >= 4)
            {
                short_code = treeView1.SelectedNode.Name;
                context.Clear();
                context.SetCode(short_code);
                DisplayTitleList(short_code);
            }
            // フォルダの場合はリネーム
            else if (!string.IsNullOrEmpty(select.Name) && IsFolder(select))
            {
                TreeNode tn = treeView1.SelectedNode;
                treeView1.LabelEdit = true;
                if (tn != null && treeView1.LabelEdit && tn.IsEditing)
                {
                    tn.BeginEdit();
                }
            }
        }
        /// <summary>
        /// このアプリを閉じる前の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if ((MessageBox.Show("アプリケーションを終了する前にcode.lstファイルを保存しますか？", "確認",
                    MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)) {
                        SaveCodeList();
                        this.visited.Save();
            }
        }
        /// <summary>
        /// 全文検索テキストボックスでキー押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            switch( e.KeyChar ) {
            case (char)Keys.Enter:
                if (textBox3.Text.Length == 0)
                {
                    MessageBox.Show("検索ワードを入力してください。");
                    return;
                }
                DoSearchAllTitles();
                break;
            default:
                break;
            }
        }
        /// <summary>
        /// TreeViewで名称変更後の処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void treeView1_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            try
            {
                bool editOk = true;
                if (e.Node.Parent == null)
                { // フォルダ
                    treeView1.SelectedNode.Text = e.Node.Text;
                    treeView1.SelectedNode.Name = e.Node.Text;
                    treeView1.SelectedNode.ImageIndex = (int)ImageList.CloseFolder;
                    e.Node.EndEdit(false);
                } else {

                    string outCode = "";
                    if (e.Label.Length > 0)
                    {
                        if (e.Label.IndexOf(tvdelimiter) == -1) editOk = false;
                        if (!IsRegularCode(e.Label, out outCode)) editOk = false;
                        if (!editOk)
                        {
                            MessageBox.Show("銘柄名称を変更する場合は、コードと名称の間を全角スペースで空けて下さい.");
                            e.CancelEdit = true;
                            e.Node.EndEdit(true);
                        } else {

                            treeView1.SelectedNode.Text = e.Label;
                            e.Node.EndEdit(false);
                        }
                    }
                }
                this.treeView1.LabelEdit = false;
            }
            catch (NullReferenceException exp)
            {
                e.CancelEdit = true;
                e.Node.EndEdit(true);
            }
        }

        private void webBrowser2_StartNewWindow(object sender, BrowserExtendedNavigatingEventArgs e)
        {
//            this.textBox2.AppendText("( ･∀･)ﾉ > StartNewWindowイベント補足" + csCrLf);
            FormBrowser fb = new FormBrowser();
            e.AutomationObject = fb.getBrowser().ApplicationAx;
        }

        private void webBrowser2_NewWindow(object sender, CancelEventArgs e)
        {
//            this.textBox2.AppendText("( ･∀･)ﾉ > NewWindowイベント補足" + csCrLf);
            
        }

        #endregion

    }




    /// <summary>
    /// 既読/未読制御クラス
    /// 銘柄コードをASCIIコードで、MIDをバイナリで保存
    /// ※いい加減な実装である
    /// </summary>
    public class KVisited
    {
        public Hashtable codes = new Hashtable();   // 銘柄コード
        
        public KVisited() {
            if (!File.Exists(Form1.csSaveFile)) {
                File.Create(Form1.csSaveFile);
            } else {
                byte[] readbuf = new byte[10];
                string code = "";
                using (FileStream fs = new FileStream(Form1.csSaveFile, FileMode.Open, FileAccess.Read))
                {
                    BinaryReader br = new BinaryReader(fs);
                    try {
                        int mid = 0;
                        int mid_plus = 0;
                        bool odd_byte = true;
                        for (; ; ) {
                            int i = br.ReadInt32();
                            if (i == -2 ) {
                                if (mid_plus == -1) {
                                    byte[] bb;
                                    bb = BitConverter.GetBytes(mid);
                                    code = Encoding.ASCII.GetString(bb);
                                } else {
                                    byte[] bb;
                                    bb = BitConverter.GetBytes(mid_plus);
                                    code = Encoding.ASCII.GetString(bb);
                                    bb = BitConverter.GetBytes(mid);
                                    code += Encoding.ASCII.GetString(bb,0,2);
                                }
                                codes[code] = new List<int>();
                                odd_byte = true;
                            } else if (i == -1) {
                                ((List<int>)(codes[code])).Add(mid);
                                odd_byte = true;
                            } else {
                                // 区切り文字以外のコードが連続
                                mid_plus = (odd_byte) ?  -1 :  mid;
                                mid = i;
                                odd_byte = false;
                            }
                        }
                    }
                    catch (EndOfStreamException eof) {
                        br.Close();
                        fs.Dispose();
                    }
                }
            }
        }        
        
        public Hashtable GetCodes()
        {
            return this.codes;
        }
        public List<int> GetMessages(string code)
        {
            return (List<int>)codes[code];
        }
        public Hashtable GetMessagesHt(string code)
        {
            Hashtable ht = new Hashtable();
            if (codes[code] != null) {
                foreach (int msg in (List<int>)codes[code]) {
                    string s = msg.ToString();
                    ht[s] = msg;
                }
            }
            return ht;
        }
        public void AddMessage( string code, string mid ){
            if ( codes[code] == null ) {
                codes[code] = new List<int>();
            }
            ((List<int>)(codes[code])).Add(int.Parse(mid));
        }
        public byte[] ToStream(ref int size)
        {
            const int BUFSIZE = 1000000;
            int offset = 0;
            string ret = "";
            byte[] b = new byte[BUFSIZE];
            for (int i = 0; i < BUFSIZE; i++) {
                b[i] = 0x00;
            }
            foreach ( string key in codes.Keys ) {
                int keylength = key.Length;
                // 銘柄コード
                foreach (byte bb in Encoding.ASCII.GetBytes(key)) {
                    b[offset] = bb;
                    offset++;
                }
                switch (keylength % 4) {
                    case 1:
                        b[offset] = 0xff;
                        b[++offset] = 0x00;
                        b[++offset] = 0x00;
                        offset++;
                        break;
                    case 2:
                        b[offset] = 0x00;
                        b[++offset] = 0x00;
                        offset++;
                        break;
                    case 3:
                        b[offset] = 0x00;
                        offset++;
                        break;
                    default:
                        break;
                }
                foreach (byte bb in BitConverter.GetBytes(-2)) {
                    b[offset] = bb;
                    offset++;
                }

                // 銘柄コードに紐づくメッセージID
                List<int> msgs = (List<int>)codes[key];
                foreach (int val in msgs) {
                    foreach (byte bb in BitConverter.GetBytes(val)) {
                        b[offset] = bb;
                        offset++;
                    }
                    foreach (byte bb in BitConverter.GetBytes(-1)) {
                        b[offset] = bb;
                        offset++;
                    }
                }
            }
            size = offset;
            return b;
        }
        public void Save()
        {
            if (!File.Exists(Form1.csSaveFile)) {
                File.Create(Form1.csSaveFile);
            }
            using (FileStream fs = new FileStream(Form1.csSaveFile, FileMode.Open, FileAccess.Write)) {
                int size = 0;
                byte[] b = ToStream(ref size);
                fs.Write(b, 0, size);
                //foreach (byte bb in b) {
                //}
                //fs.Close();
                fs.Dispose();
            }
            return ;
        }
    }

    /// <summary>
    /// Yahooスキン
    /// </summary>
    public class YahooSkin
    {
        private Hashtable yTemplate = new Hashtable();   // メッセージ表示置き換え用のテンプレー
        private string skinfile = "";
        private string skinHtml = "";

        public YahooSkin(string skin) {
            yTemplate["&TITLE"] = "";
            yTemplate["&DATE"] = "";
            yTemplate["&NUMBER"] = "";
            yTemplate["&COUNT"] = "";
            yTemplate["&FEELINGS"] = "";
            yTemplate["&NAME"] = "";
            yTemplate["&MESSAGE"] = "";
            yTemplate["&RESURL"] = "";
            yTemplate["&RESNUMBER"] = "";
            yTemplate["&RESNAME"] = "";
            yTemplate["&ABUSEURL"] = "";
            yTemplate["&COMPANYNAME"] = "";
            yTemplate["&COMPANYURL"] = "";
            yTemplate["&CHARTURL"] = "";
            yTemplate["&CHARTIMG"] = "";
            yTemplate["&CHARTDATE"] = "";
            yTemplate["&CHANGE"] = "";
            yTemplate["&CLOSE"] = "";
            yTemplate["&CODE"] = "";

            // これ以降はカブラウザもどき独自
            yTemplate["&M_FINDMSG"] = "";    // 投稿者の投稿一覧
            yTemplate["&M_NICKNAME"] = "";   // USERニックネーム
            yTemplate["&M_COMMENT_THM"] = ""; // USERサムネイル
            this.skinfile = @".\skin\" + skin;
            setSkinHtml(this.skinfile);
        }

        public string get(string key)
        {
            return (string)yTemplate[key];
        }
        public void set(string key, string value)
        {
            this.yTemplate[key] = value;
        }
        public string getConvertedHtml() {
            string afterconvert = skinHtml;
            foreach (string name in yTemplate.Keys)
            {
                if (yTemplate[name] != null) {
                    afterconvert = afterconvert.Replace(name, yTemplate[name].ToString());
                }
            }
            return afterconvert;
        }
        public void Clear()
        {
            /*
            try
            {
                for (int i = 0; i < yTemplate.Count; i++ )
                {
                    yTemplate[i] = "";
                }
            }
            catch (InvalidOperationException e)
            {
            }*/
        }
        public void setSkinHtml(string skinfile){
            using (StreamReader sr = new StreamReader(skinfile, Encoding.GetEncoding("Shift_JIS")))
            {
                this.skinHtml = sr.ReadToEnd();
                sr.Close();
            }
        }

        /// <summary>
        ///  YahooSkinに銘柄独自の情報をセットする
        ///  メッセーに紐づく情報はGetContentsFromPCSite()でセット
        /// </summary>
        /// <param name="context"></param>
        public void ContextToSkin(CurrentContext context){
            this.Clear();

            yTemplate["&TITLE"] = context.selectedTitle;
            yTemplate["&CODE"] = context.GetCodeAndExchange();
            yTemplate["&COUNT"] = context.GetMaxTitleNo().ToString();
            yTemplate["&COMPANYNAME"] = context.comapnyName;
            yTemplate["&CHARTURL"] = "http://stocks.finance.yahoo.co.jp/stocks/chart/?code=" + context.GetCodeAndExchange();
            yTemplate["&CHARTIMG"] = "http://rchart.yahoo.co.jp/t?s=" + context.GetCodeAndExchange();
            //yTemplate["&CHARTDATE"] = "";
            //yTemplate["&CHANGE"] = "";
            //yTemplate["&CLOSE"] = "";
            //yTemplate["&M_NICKNAME"] = "";
            //yTemplate["&M_FINDMSG"] = "";
            //yTemplate["&M_COMMENT_THM"] = context.
        }

    }

    /// <summary>
    /// 比較クラス
    /// </summary>
    class ListViewItemComparer : IComparer
    {
        private int col;
        private int sortOrder;

        // コンストラクタ
        public ListViewItemComparer(int col, int sortOrder)
        {
            this.col = col;
            this.sortOrder = sortOrder;
        }
        // 比較メソッド
        public int Compare(object x, object y)
        {
            int ret = 0;
            switch (col)
            {
                case 0:    // 文字列でソート
                    ret = String.Compare(((ListViewItem)x).SubItems[col].Text,
                        ((ListViewItem)y).SubItems[col].Text);
                    break;
                case 1:    // 数値でソート
                    ret = int.Parse(((ListViewItem)x).SubItems[col].Text) <
                       int.Parse(((ListViewItem)y).SubItems[col].Text) ? -1 : 1;
                    break;
            }
            return ret * sortOrder;
        }
    }


}