=begin
  PMutex - ץ/åɴ֤Ǥ¾󶡤ޤ

  Copyright(C) 2002-2004 FUKUOKA Tomoyuki.

  This file is part of KAGEMAI.  

  KAGEMAI is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: pmutex.rb 10 2004-07-06 11:44:32Z fukuoka $
=end

require 'thread'
require 'sync'

module Kagemai

  class PMutex
    SH = Sync::SH
    EX = Sync::EX

    @@mutex = Mutex.new
    @@sync = Hash.new

    def self.get_sync(filename)
      @@mutex.synchronize {
        unless @@sync.has_key?(filename) then
          @@sync[filename] = [0, Sync.new]
        end
        @@sync[filename][0] += 1
        @@sync[filename][1]
      }
    end

    def self.release_sync(filename)
      @@mutex.synchronize {
        @@sync[filename][0] -= 1
        if @@sync[filename][0] == 0 then
          @@sync.delete(filename)
        end
      }
    end

    def initialize(lockfile)
      @lockfilename = lockfile
      @lockfile = nil
      @sync = nil
    end

    def open_mode(mode)
      r = (mode == SH ? 'rb' : 'wb')
      r
    end

    def flock_mode(mode)
      r = (mode == SH ? File::LOCK_SH : File::LOCK_EX)
      r
    end

    def lock(mode = EX)
      @sync = PMutex.get_sync(@lockfilename)
      @sync.lock(mode)
      @lockfile = File.open(@lockfilename, open_mode(mode))
      @lockfile.flock(flock_mode(mode))
    end

    def unlock(mode = EX)
      if @lockfile then
        @lockfile.flock(File::LOCK_UN)
        @lockfile.close()
        @lockfile = nil
      end

      if @sync then
        @sync.unlock(mode)
        @sync = nil
        PMutex.release_sync(@lockfilename)
      end
    end

    def synchronize(mode = EX)
      begin
        lock(mode)
        yield
      ensure
        unlock(mode)
      end
    end

  end

end
